/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.protocol.Packet;
import com.yashandb.util.YasTime;
import java.sql.Time;
import java.util.Calendar;

public class TimeParameter
extends YasParameter {
    private static final int TIME_PARAM_LEN = 9;

    public TimeParameter() {
        this.type = 15;
    }

    @Override
    protected int processWrite(Packet packet) {
        packet.writeByte((byte)8);
        long intervalFromBase = (Long)this.value;
        packet.writeLong(intervalFromBase);
        return 8;
    }

    @Override
    public void setValue(Object obj) {
        if (obj == null) {
            this.value = ParameterFactory.getNullObject();
            return;
        }
        if (obj == ParameterFactory.getNullObject()) {
            this.value = obj;
            return;
        }
        long timeInterval = ((Time)obj).getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInterval);
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.hour = calendar.get(11);
        internalTimeStamp.minute = calendar.get(12);
        internalTimeStamp.second = calendar.get(13);
        internalTimeStamp.fraction = calendar.get(14) * 1000;
        if (obj instanceof YasTime) {
            internalTimeStamp.fraction = ((YasTime)obj).getNanos() / 1000;
        }
        this.value = InternalTimeStamp.transTimeToValue(internalTimeStamp);
    }

    @Override
    protected int getParamLength() {
        return 9;
    }
}

