/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.parameter;

import com.yashandb.parameter.ParameterFactory;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.protocol.Packet;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimeStampParameter
extends YasParameter {
    private static final int TIMESTAMP_PARAM_LEN = 12;

    public TimeStampParameter() {
        this.type = 16;
    }

    @Override
    protected int processWrite(Packet packet) {
        packet.writeByte((byte)12);
        long intervalFromBase = (Long)this.value;
        packet.writeLong(intervalFromBase);
        packet.writeShort(0);
        packet.writeShort(0);
        return 12;
    }

    @Override
    public void setValue(Object obj) {
        if (obj == null) {
            this.value = ParameterFactory.getNullObject();
            return;
        }
        if (obj == ParameterFactory.getNullObject()) {
            this.value = obj;
            return;
        }
        long timeInterval = ((Timestamp)obj).getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInterval);
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        internalTimeStamp.year = calendar.get(1);
        internalTimeStamp.month = calendar.get(2) + 1;
        internalTimeStamp.date = calendar.get(5);
        internalTimeStamp.hour = calendar.get(11);
        internalTimeStamp.minute = calendar.get(12);
        internalTimeStamp.second = calendar.get(13);
        internalTimeStamp.fraction = calendar.get(14) * 1000;
        internalTimeStamp.fraction = ((Timestamp)obj).getNanos() / 1000;
        this.value = InternalTimeStamp.transTimeStampToValue(internalTimeStamp);
    }

    @Override
    protected int getParamLength() {
        return 13;
    }
}

