/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.protocol.Buffer;
import com.yashandb.util.ByteConverter;
import java.nio.charset.Charset;

public abstract class BaseBuffer
implements Buffer {
    private byte[] buffer;
    protected int position = 0;
    private int capacity;
    private Charset charset;

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getPostion() {
        return this.position;
    }

    @Override
    public int getRemainSize() {
        return this.capacity - this.position;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public void writeFixString(String str, int i) {
        this.ensureCapacity(i);
        byte[] b = this.buffer;
        System.arraycopy(str.getBytes(this.charset), 0, b, this.position, str.getBytes(this.charset).length);
        this.position += i;
    }

    @Override
    public void writeString(String str) {
        byte[] strBytes = str.getBytes(this.charset);
        this.ensureCapacity(strBytes.length);
        byte[] b = this.buffer;
        System.arraycopy(strBytes, 0, b, this.position, strBytes.length);
        this.position += strBytes.length;
    }

    @Override
    public void writeStringWithByteLength(String str) {
        byte[] strBytes = str.getBytes(this.charset);
        this.writeByte((byte)strBytes.length);
        this.ensureCapacity(strBytes.length);
        byte[] b = this.buffer;
        System.arraycopy(strBytes, 0, b, this.position, strBytes.length);
        this.position += strBytes.length;
    }

    @Override
    public void writeLong(long v) {
        this.ensureCapacity(8);
        ByteConverter.int8(this.buffer, this.position, v);
        this.position += 8;
    }

    @Override
    public void writeInt(int v) {
        this.ensureCapacity(4);
        ByteConverter.int4(this.buffer, this.position, v);
        this.position += 4;
    }

    @Override
    public void writeShort(int v) {
        this.ensureCapacity(2);
        this.writeShort(this.position, v);
        this.position += 2;
    }

    @Override
    public void writeByte(byte v) {
        this.ensureCapacity(1);
        this.buffer[this.position++] = v;
    }

    @Override
    public void writeFloat(float v) {
        this.ensureCapacity(4);
        this.writeFloat(this.position, v);
        this.position += 4;
    }

    @Override
    public void writeDouble(double v) {
        this.ensureCapacity(8);
        this.writeDouble(this.position, v);
        this.position += 8;
    }

    @Override
    public float getFloat() {
        return 0.0f;
    }

    @Override
    public double getDouble() {
        return 0.0;
    }

    @Override
    public void writeBytes(byte[] i) {
        this.ensureCapacity(i.length);
        byte[] b = this.buffer;
        System.arraycopy(i, 0, b, this.position, i.length);
        this.position += i.length;
    }

    @Override
    public byte[] getBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.buffer, this.position, b, 0, len);
        this.position += len;
        return b;
    }

    public byte[] getBytes(int len, byte[] bytes) {
        byte[] b = bytes;
        System.arraycopy(this.buffer, this.position, b, 0, len);
        this.position += len;
        return b;
    }

    @Override
    public int getInt() {
        int p = this.position;
        this.position += 4;
        return this.getInt(p);
    }

    @Override
    public long getLong() {
        int p = this.position;
        this.position += 8;
        return this.getLong(p);
    }

    @Override
    public String getString(int len) {
        int p = this.position;
        this.position += len;
        return this.getString(p, len);
    }

    @Override
    public short getShort() {
        int p = this.position;
        this.position += 2;
        return this.getShort(p);
    }

    @Override
    public byte getByte() {
        int p = this.position++;
        return this.getByte(p);
    }

    @Override
    public void skip(int size) {
        this.position += size;
    }

    @Override
    public void clean() {
        this.position = 8;
    }

    public final void ensureCapacity(int additionalData) {
        if (this.position + additionalData > this.buffer.length) {
            throw new OutOfMemoryError("pos out message capcity");
        }
    }

    public BaseBuffer(int capacity) {
        this.capacity = capacity;
        this.buffer = new byte[capacity];
    }

    public BaseBuffer(Buffer buffer) {
        this.buffer = buffer.getBuffer();
        this.capacity = buffer.getCapacity();
    }

    protected int getInt(int pos) {
        return ByteConverter.int4(this.buffer, pos);
    }

    protected long getLong(int pos) {
        return ByteConverter.int8(this.buffer, pos);
    }

    protected String getString(int pos, int len) {
        if (this.charset == null) {
            return new String(this.buffer, pos, len);
        }
        return new String(this.buffer, pos, len, this.charset);
    }

    protected byte getByte(int pos) {
        return this.buffer[pos];
    }

    protected short getShort(int pos) {
        return ByteConverter.int2(this.buffer, pos);
    }

    protected void setByte(int i, byte value) {
        this.buffer[i] = value;
    }

    protected void writeShort(int p, int value) {
        ByteConverter.int2(this.buffer, p, value);
    }

    protected void writeByte(int p, byte v) {
        this.buffer[p] = v;
    }

    protected void writeFloat(int p, float v) {
        ByteConverter.float4(this.buffer, p, v);
    }

    protected void writeDouble(int p, double v) {
        ByteConverter.float8(this.buffer, p, v);
    }

    protected void writeInt(int i, int value) {
        ByteConverter.int4(this.buffer, i, value);
    }

    @Override
    public void writeBytes(byte[] i, int start, int len) {
        this.ensureCapacity(len);
        byte[] b = this.buffer;
        System.arraycopy(i, start, b, this.position, len);
        this.position += len;
    }

    protected void setPostion(int pos) {
        this.position = pos;
        if (this.position > this.capacity) {
            throw new OutOfMemoryError("pos out message capcity");
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

