/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.jdbc.YasConnection;
import com.yashandb.protocol.accessor.Accessor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public abstract class ClassInstanceConverter<T> {
    private final Class<T> classType;
    private static final Map<Class, ClassInstanceConverter> CLASS_INSTANCE_CONV_MAP = new HashMap<Class, ClassInstanceConverter>();

    private ClassInstanceConverter(Class<T> classType) {
        this.classType = classType;
    }

    public static <T> ClassInstanceConverter<T> getClassConverter(Class<T> classType) {
        return CLASS_INSTANCE_CONV_MAP.get(classType);
    }

    public abstract T redirect(Accessor var1, byte[] var2, YasConnection var3) throws SQLException;

    static {
        CLASS_INSTANCE_CONV_MAP.put(LocalDateTime.class, new ClassInstanceConverter<LocalDateTime>(LocalDateTime.class){

            @Override
            public LocalDateTime redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getLocalDateTime(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(LocalDate.class, new ClassInstanceConverter<LocalDate>(LocalDate.class){

            @Override
            public LocalDate redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getLocalDate(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(LocalTime.class, new ClassInstanceConverter<LocalTime>(LocalTime.class){

            @Override
            public LocalTime redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getLocalTime(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(OffsetDateTime.class, new ClassInstanceConverter<OffsetDateTime>(OffsetDateTime.class){

            @Override
            public OffsetDateTime redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getOffsetDateTime(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(OffsetTime.class, new ClassInstanceConverter<OffsetTime>(OffsetTime.class){

            @Override
            public OffsetTime redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getOffsetTime(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(ZonedDateTime.class, new ClassInstanceConverter<ZonedDateTime>(ZonedDateTime.class){

            @Override
            public ZonedDateTime redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getZonedDateTime(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Date.class, new ClassInstanceConverter<Date>(Date.class){

            @Override
            public Date redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getDate(bytes, null);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Timestamp.class, new ClassInstanceConverter<Timestamp>(Timestamp.class){

            @Override
            public Timestamp redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getTimestamp(bytes, null);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Time.class, new ClassInstanceConverter<Time>(Time.class){

            @Override
            public Time redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getTime(bytes, null);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(java.util.Date.class, new ClassInstanceConverter<java.util.Date>(java.util.Date.class){

            @Override
            public java.util.Date redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getJavaUtilDate(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Calendar.class, new ClassInstanceConverter<Calendar>(Calendar.class){

            @Override
            public Calendar redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getCalendar(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Double.class, new ClassInstanceConverter<Double>(Double.class){

            @Override
            public Double redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getDouble(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Float.class, new ClassInstanceConverter<Float>(Float.class){

            @Override
            public Float redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return Float.valueOf(accessor.getFloat(bytes));
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Long.class, new ClassInstanceConverter<Long>(Long.class){

            @Override
            public Long redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getLong(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Integer.class, new ClassInstanceConverter<Integer>(Integer.class){

            @Override
            public Integer redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getInt(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Short.class, new ClassInstanceConverter<Short>(Short.class){

            @Override
            public Short redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getShort(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Byte.class, new ClassInstanceConverter<Byte>(Byte.class){

            @Override
            public Byte redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getByte(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Boolean.class, new ClassInstanceConverter<Boolean>(Boolean.class){

            @Override
            public Boolean redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getBoolean(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(BigDecimal.class, new ClassInstanceConverter<BigDecimal>(BigDecimal.class){

            @Override
            public BigDecimal redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getBigDecimal(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(String.class, new ClassInstanceConverter<String>(String.class){

            @Override
            public String redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getString(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Reader.class, new ClassInstanceConverter<Reader>(Reader.class){

            @Override
            public Reader redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getCharacterStream(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(InputStream.class, new ClassInstanceConverter<InputStream>(InputStream.class){

            @Override
            public InputStream redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getBinaryStream(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(BigInteger.class, new ClassInstanceConverter<BigInteger>(BigInteger.class){

            @Override
            public BigInteger redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getBigInteger(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(byte[].class, new ClassInstanceConverter<byte[]>(byte[].class){

            @Override
            public byte[] redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getBytes(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(RowId.class, new ClassInstanceConverter<RowId>(RowId.class){

            @Override
            public RowId redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getRowId(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Period.class, new ClassInstanceConverter<Period>(Period.class){

            @Override
            public Period redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getPeriod(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Duration.class, new ClassInstanceConverter<Duration>(Duration.class){

            @Override
            public Duration redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getDuration(bytes);
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Clob.class, new ClassInstanceConverter<Clob>(Clob.class){

            @Override
            public Clob redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getClob(bytes, connection.getSession());
            }
        });
        CLASS_INSTANCE_CONV_MAP.put(Blob.class, new ClassInstanceConverter<Blob>(Blob.class){

            @Override
            public Blob redirect(Accessor accessor, byte[] bytes, YasConnection connection) throws SQLException {
                return accessor.getBlob(bytes, connection.getSession());
            }
        });
    }
}

