/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.sql.SQLException;

public enum ConnectionServerMode {
    SHARED_MODE("shared", 0),
    DEDICATE_MODE("dedicated", 1);

    private final int value;
    private final String mode;

    private ConnectionServerMode(String mode, int value) {
        this.mode = mode;
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ConnectionServerMode getServerMode(String mode) throws SQLException {
        for (ConnectionServerMode serverMode : ConnectionServerMode.values()) {
            if (!serverMode.mode.equalsIgnoreCase(mode)) continue;
            return serverMode;
        }
        throw SQLError.createSQLException(Messages.get("invalid server mode {0}", mode), YasState.DATA_ERROR);
    }
}

