/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.TransactionState;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.Packet;
import java.sql.SQLException;
import java.util.HashMap;

public class ExecuteResult {
    private int batchRows;
    private final short outParams;
    private final short marginColumns;
    private final long affectedRows;
    private final long xactStatus;
    private final long xisoLevel;
    private final boolean hasMoreRows;
    private boolean hasBatchRows;
    private final boolean hasBatchError;
    private int[] dmlRows;
    private boolean inBatchMode = false;
    private HashMap<Integer, BatchError> batchErrors;

    public ExecuteResult(Packet ack) throws SQLException {
        this(ack, false);
    }

    public ExecuteResult(Packet ack, boolean inBatchMode) throws SQLException {
        this.batchRows = ack.getInt();
        this.outParams = ack.getShort();
        this.marginColumns = ack.getShort();
        long flag = ack.getLong();
        this.affectedRows = flag & 0xFFFFFFFFFFL;
        this.xactStatus = (flag & 0x30000000000L) >>> 40;
        this.xisoLevel = (flag & 0xC0000000000L) >>> 42;
        this.hasMoreRows = (flag & 0x100000000000L) == 0x100000000000L;
        this.hasBatchRows = (flag & 0x200000000000L) == 0x200000000000L;
        this.hasBatchError = (flag & 0x400000000000L) == 0x400000000000L;
        this.inBatchMode = inBatchMode;
    }

    public void getDMLError(Packet ack) throws SQLException {
        if (this.hasBatchRows) {
            this.dmlRows = this.processDMLRows(ack);
            if (this.hasBatchError) {
                this.batchErrors = this.processBatchErrors(ack, this.dmlRows);
            }
        }
        if (this.inBatchMode && this.dmlRows == null) {
            this.hasBatchRows = true;
            this.batchRows = 1;
            this.dmlRows = new int[1];
            this.dmlRows[0] = (int)this.affectedRows;
        }
    }

    public boolean isHasMoreRows() {
        return this.hasMoreRows;
    }

    public int getBatchRows() {
        return this.batchRows;
    }

    public short getOutParams() {
        return this.outParams;
    }

    public short getMarginColumns() {
        return this.marginColumns;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public TransactionState getXactStatus() {
        return TransactionState.values()[(int)this.xactStatus];
    }

    public long getXisoLevel() {
        return this.xisoLevel;
    }

    private int[] processDMLRows(Packet ack) {
        int len = ack.getInt();
        int[] dmlRows = new int[len];
        for (int i = 0; i < len; ++i) {
            dmlRows[i] = ack.getInt();
        }
        return dmlRows;
    }

    private HashMap<Integer, BatchError> processBatchErrors(Packet ack, int[] dmlRows) throws SQLException {
        HashMap<Integer, BatchError> batchErrors = new HashMap<Integer, BatchError>();
        int len = ack.getInt();
        for (int i = 0; i < len; ++i) {
            int num = ack.getInt();
            if (num < 0 || dmlRows == null || num > dmlRows.length) {
                throw SQLError.createSQLException("BatchError protocol wrong.", YasState.UNKNOWN_STATE);
            }
            int errCode = ack.getInt();
            int msgLen = ack.getInt();
            String errMsg = ack.getString(msgLen);
            batchErrors.put(num, new BatchError(errCode, errMsg));
        }
        return batchErrors;
    }

    public int[] getDmlRows() {
        return this.dmlRows;
    }

    public HashMap<Integer, BatchError> getBatchErrors() {
        return this.batchErrors;
    }

    public boolean isHasBatchRows() {
        return this.hasBatchRows;
    }

    public boolean isHasBatchError() {
        return this.hasBatchError;
    }
}

