/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

public class InternalTimeStamp {
    public int year;
    public int month;
    public int date;
    public int hour;
    public int minute;
    public int second;
    public int fraction;

    public static InternalTimeStamp transValueToTimeStamp(long timeValue) {
        int tmpYear;
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        long jDateUs = timeValue + 210866803200000000L;
        int jDate = (int)(jDateUs / 86400000000L);
        int quad = (jDate += 32044) / 146097;
        int extra = (jDate - quad * 146097) * 4 + 3;
        jDate += 60 + quad * 3 + extra / 146097;
        jDate = ((tmpYear = (jDate -= (quad = jDate / 1461) * 1461) * 4 / 1461) != 0 ? (jDate + 305) % 365 : (jDate + 306) % 366) + 123;
        internalTimeStamp.year = (tmpYear += quad * 4) - 4800;
        quad = jDate * 2141 / 65536;
        internalTimeStamp.date = jDate - 7834 * quad / 256;
        internalTimeStamp.month = (quad + 10) % 12 + 1;
        long remainUs = jDateUs % 86400000000L;
        internalTimeStamp.hour = (int)(remainUs / 3600000000L);
        internalTimeStamp.minute = (int)((remainUs -= (long)internalTimeStamp.hour * 3600000000L) / 60000000L);
        internalTimeStamp.second = (int)((remainUs -= (long)internalTimeStamp.minute * 60000000L) / 1000000L);
        internalTimeStamp.fraction = (int)(remainUs % 1000000L);
        return internalTimeStamp;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static long transTimeStampToValue(InternalTimeStamp internalTimeStamp) {
        int year = internalTimeStamp.year;
        int month = internalTimeStamp.month;
        if (month > 2) {
            ++month;
            year += 4800;
        } else {
            month += 13;
            year += 4799;
        }
        int century = year / 100;
        int jDate = year * 365 - 32167;
        jDate += year / 4 - century + century / 4;
        long tmpDate = (long)(jDate += 7834 * month / 256 + internalTimeStamp.date) * 86400000000L;
        tmpDate += (long)internalTimeStamp.hour * 3600000000L;
        tmpDate += (long)internalTimeStamp.minute * 60000000L;
        tmpDate += (long)(internalTimeStamp.second * 1000000);
        long timeValue = (tmpDate += (long)internalTimeStamp.fraction) - 210866803200000000L;
        return timeValue;
    }

    public static InternalTimeStamp transValueToTime(long timeValue) {
        InternalTimeStamp internalTimeStamp = new InternalTimeStamp();
        long remainUs = timeValue % 86400000000L;
        internalTimeStamp.hour = (int)(remainUs / 3600000000L);
        internalTimeStamp.minute = (int)((remainUs -= (long)internalTimeStamp.hour * 3600000000L) / 60000000L);
        internalTimeStamp.second = (int)((remainUs -= (long)internalTimeStamp.minute * 60000000L) / 1000000L);
        internalTimeStamp.fraction = (int)(remainUs % 1000000L);
        return internalTimeStamp;
    }

    public static long transTimeToValue(InternalTimeStamp internalTimeStamp) {
        long tmpDate = 0L;
        tmpDate += (long)internalTimeStamp.hour * 3600000000L;
        tmpDate += (long)internalTimeStamp.minute * 60000000L;
        tmpDate += (long)(internalTimeStamp.second * 1000000);
        long timeValue = tmpDate += (long)internalTimeStamp.fraction;
        return timeValue;
    }
}

