/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.YasConstants;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Period;

public class IntervalType {
    private static int getIntervalSign(String strInterval) {
        int sign = 0;
        if (strInterval.charAt(0) == '-') {
            sign = 1;
        }
        return sign;
    }

    private static String stripSign(String strInterval) {
        char firstChar = strInterval.charAt(0);
        if (firstChar == '-' || firstChar == '+') {
            return strInterval.substring(1);
        }
        return strInterval;
    }

    private static String getIntervalElement(String strInterval) throws SQLException {
        int iCount;
        IntervalType.checkInterval(strInterval);
        for (iCount = 0; iCount < strInterval.length() && Character.isDigit(strInterval.charAt(iCount)); ++iCount) {
        }
        if (iCount > 9) {
            throw SQLError.createSQLException("the leading precision is too small", YasState.DATA_ERROR);
        }
        return strInterval.substring(0, iCount);
    }

    private static int getElementValue(String digitPart) throws SQLException {
        long value;
        try {
            value = Long.parseLong(digitPart);
        }
        catch (NumberFormatException exception) {
            throw SQLError.createSQLException("the interval is invalid", YasState.DATA_ERROR);
        }
        if (value > 0xFFFFFFFFL) {
            throw SQLError.createSQLException("the leading precision is too small", YasState.DATA_ERROR);
        }
        return (int)value;
    }

    private static String skipSplitChar(String strInterval, char split) throws SQLException {
        IntervalType.checkInterval(strInterval);
        if (strInterval.charAt(0) != split) {
            throw SQLError.createSQLException("the interval is invalid", YasState.DATA_ERROR);
        }
        return strInterval.substring(1);
    }

    private static void checkInterval(String strInterval) throws SQLException {
        if (strInterval.isEmpty()) {
            throw SQLError.createSQLException("the interval is invalid", YasState.DATA_ERROR);
        }
    }

    private static int getYear(String strDigit) throws SQLException {
        int year = IntervalType.getElementValue(strDigit);
        if (year > 178000000) {
            throw SQLError.createSQLException("the year is out of range", YasState.DATA_ERROR);
        }
        return year;
    }

    private static int getMonth(String strDigit) throws SQLException {
        int month = IntervalType.getElementValue(strDigit);
        if (month >= 12) {
            throw SQLError.createSQLException("not a valid month", YasState.DATA_ERROR);
        }
        return month;
    }

    private static int getDay(String strDigit) throws SQLException {
        int day = IntervalType.getElementValue(strDigit);
        if (day > 100000000) {
            throw SQLError.createSQLException("the day is out of range", YasState.DATA_ERROR);
        }
        return day;
    }

    private static int getHour(String strDigit) throws SQLException {
        int hour = IntervalType.getElementValue(strDigit);
        if (hour >= 24) {
            throw SQLError.createSQLException("not a valid hour", YasState.DATA_ERROR);
        }
        return hour;
    }

    private static int getMinute(String strDigit) throws SQLException {
        int minute = IntervalType.getElementValue(strDigit);
        if (minute >= 60) {
            throw SQLError.createSQLException("not a valid minute", YasState.DATA_ERROR);
        }
        return minute;
    }

    private static int getSecond(String strDigit) throws SQLException {
        int second = IntervalType.getElementValue(strDigit);
        if (second >= 60) {
            throw SQLError.createSQLException("not a valid second", YasState.DATA_ERROR);
        }
        return second;
    }

    private static int getFraction(String strInterval) throws SQLException {
        IntervalType.checkInterval(strInterval);
        int fraction = 0;
        for (int i = 0; i < strInterval.length(); ++i) {
            if (!Character.isDigit(strInterval.charAt(i))) {
                throw SQLError.createSQLException("not a valid fraction", YasState.DATA_ERROR);
            }
            fraction *= 10;
            fraction += strInterval.charAt(i) - 48;
        }
        if (strInterval.length() > 9) {
            throw SQLError.createSQLException("the leading precision is too small", YasState.DATA_ERROR);
        }
        if (strInterval.length() > 6) {
            double tempFraction = (double)fraction / (double)YasConstants.PrecisionLimit[strInterval.length() - 6];
            fraction = (int)Math.round(tempFraction);
        }
        if (strInterval.length() < 6) {
            fraction *= YasConstants.PrecisionLimit[6 - strInterval.length()];
        }
        return fraction;
    }

    public static long convertStringToDsInterval(String strInterval) throws SQLException {
        strInterval = strInterval.trim();
        long dsInterVal = 0L;
        IntervalType.checkInterval(strInterval);
        int sign = IntervalType.getIntervalSign(strInterval);
        strInterval = IntervalType.stripSign(strInterval).trim();
        String digitPart = IntervalType.getIntervalElement(strInterval);
        int day = IntervalType.getDay(digitPart);
        dsInterVal += (long)day * 86400000000L;
        strInterval = strInterval.substring(digitPart.length());
        strInterval = IntervalType.skipSplitChar(strInterval, ' ').trim();
        digitPart = IntervalType.getIntervalElement(strInterval);
        int hour = IntervalType.getHour(digitPart);
        dsInterVal += (long)hour * 3600000000L;
        strInterval = strInterval.substring(digitPart.length()).trim();
        strInterval = IntervalType.skipSplitChar(strInterval, ':').trim();
        digitPart = IntervalType.getIntervalElement(strInterval);
        int minute = IntervalType.getMinute(digitPart);
        dsInterVal += (long)minute * 60000000L;
        strInterval = strInterval.substring(digitPart.length()).trim();
        strInterval = IntervalType.skipSplitChar(strInterval, ':').trim();
        digitPart = IntervalType.getIntervalElement(strInterval);
        int second = IntervalType.getSecond(digitPart);
        dsInterVal += (long)second * 1000000L;
        strInterval = strInterval.substring(digitPart.length());
        if (strInterval.length() > 0) {
            strInterval = strInterval.trim();
            strInterval = IntervalType.skipSplitChar(strInterval, '.').trim();
            int fraction = IntervalType.getFraction(strInterval);
            dsInterVal += (long)fraction;
        }
        if (dsInterVal > 8640000000000000000L) {
            throw SQLError.createSQLException("the interval is out of range", YasState.UNKNOWN_STATE);
        }
        if (sign > 0) {
            dsInterVal = -dsInterVal;
        }
        return dsInterVal;
    }

    public static String convertDsIntervalToString(long interval) {
        String strInterval = "";
        String sign = "+";
        if (interval < 0L) {
            sign = "-";
            interval = -interval;
        }
        strInterval = strInterval + sign;
        int day = (int)(interval / 86400000000L);
        strInterval = strInterval + String.format("%02d", day);
        strInterval = strInterval + ' ';
        int hour = (int)(interval / 3600000000L % 24L);
        strInterval = strInterval + String.format("%02d", hour);
        strInterval = strInterval + ':';
        int minute = (int)(interval / 60000000L % 60L);
        strInterval = strInterval + String.format("%02d", minute);
        strInterval = strInterval + ':';
        int second = (int)(interval / 1000000L % 60L);
        strInterval = strInterval + String.format("%02d", second);
        strInterval = strInterval + '.';
        int fraction = (int)(interval % 1000000L);
        strInterval = strInterval + String.format("%06d", fraction);
        return strInterval;
    }

    public static Duration convertDsIntervalToDuration(long interval) {
        int day = (int)(interval / 86400000000L);
        Duration duration = Duration.ofDays(day);
        int hour = (int)(interval / 3600000000L % 24L);
        duration = duration.plusHours(hour);
        int minute = (int)(interval / 60000000L % 60L);
        duration = duration.plusMinutes(minute);
        int second = (int)(interval / 1000000L % 60L);
        duration = duration.plusSeconds(second);
        int fraction = (int)(interval % 1000000L);
        duration = duration.plusNanos(fraction * 1000);
        return duration;
    }

    public static int convertStringToYmInterval(String strInterval) throws SQLException {
        strInterval = strInterval.trim();
        int ymInterVal = 0;
        IntervalType.checkInterval(strInterval);
        int sign = IntervalType.getIntervalSign(strInterval);
        strInterval = IntervalType.stripSign(strInterval).trim();
        String digitPart = IntervalType.getIntervalElement(strInterval);
        int year = IntervalType.getYear(digitPart);
        ymInterVal += year * 12;
        strInterval = strInterval.substring(digitPart.length());
        strInterval = IntervalType.skipSplitChar(strInterval, '-').trim();
        digitPart = IntervalType.getIntervalElement(strInterval);
        int month = IntervalType.getMonth(digitPart);
        ymInterVal += month;
        strInterval = strInterval.substring(digitPart.length());
        if (strInterval.length() != 0) {
            throw SQLError.createSQLException("the interval is invalid", YasState.DATA_ERROR);
        }
        if (ymInterVal > 2136000000) {
            throw SQLError.createSQLException("the interval is out of range", YasState.DATA_ERROR);
        }
        if (sign > 0) {
            ymInterVal = -ymInterVal;
        }
        return ymInterVal;
    }

    public static String convertYmIntervalToString(int interval) {
        String strInterval = "";
        String sign = "+";
        if (interval < 0) {
            sign = "-";
            interval = -interval;
        }
        strInterval = strInterval + sign;
        int year = interval / 12;
        strInterval = strInterval + String.format("%02d", year);
        strInterval = strInterval + '-';
        int month = interval % 12;
        strInterval = strInterval + String.format("%02d", month);
        return strInterval;
    }

    public static Period convertYmIntervalToPeriod(int interval) {
        int year = interval / 12;
        int month = interval % 12;
        return Period.of(year, month, 0);
    }
}

