/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.Session;
import com.yashandb.YasConstants;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasRuntimeException;
import com.yashandb.exception.YasState;
import com.yashandb.exception.YasWarning;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.ServerErrorMessage;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.AckConnBuffer;
import com.yashandb.protocol.Buffer;
import com.yashandb.protocol.ConnectionServerMode;
import com.yashandb.protocol.ErrorBuffer;
import com.yashandb.protocol.MsgType;
import com.yashandb.protocol.Packet;
import com.yashandb.protocol.Protocol;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.util.CharacterSet;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import com.yashandb.util.YasEncrypt;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;

public class NativeProtocol
implements Protocol {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeProtocol.class.getName());
    protected final YasSocketConnection yasSocketConnection;
    protected final Session session;
    private int packetSize = 0;
    private boolean isBigEndian;
    private boolean isPasswordEncrypt = false;
    private short charset;
    private Packet send;
    private Packet receive;
    private byte conServerMode = 0;

    public NativeProtocol(Session session, YasSocketConnection stream) {
        this.yasSocketConnection = stream;
        this.session = session;
        this.send = null;
        this.receive = null;
    }

    @Override
    public void connect(String user, String password, Properties info) throws SQLException {
        try {
            String sslRootCer;
            int socketTimeoutBackup = this.yasSocketConnection.getNetworkTimeout();
            int loginTimeout = Utils.toMillisecond(YasProperty.LOGIN_TIMEOUT.getInt(info));
            if (loginTimeout > 0) {
                this.yasSocketConnection.setNetworkTimeout(loginTimeout);
            }
            if ((sslRootCer = YasProperty.SSL_ROOT_CER.get(info)) != null && !sslRootCer.trim().equals("")) {
                this.yasSocketConnection.setSslRootCer(sslRootCer);
            }
            this.ackConnection();
            this.doAuthentication(user, password, info);
            this.loadSessionParameters();
            this.yasSocketConnection.setNetworkTimeout(socketTimeoutBackup);
        }
        catch (IOException e) {
            LOGGER.error("login fail: " + e.getMessage());
            throw SQLError.createSQLException("login fail: " + e.getMessage(), YasState.IO_ERROR, (Throwable)e);
        }
    }

    public void cancel() throws SQLException {
        this.ackConnection();
        Packet sendPacket = this.getSendPacket();
        sendPacket.writeShort(this.session.getSID());
        sendPacket.skip(2);
        sendPacket.writeInt(this.session.getSessionKey());
        this.sendCommand(sendPacket, MsgType.CMD_CANCEL_CURR, 0);
    }

    @Override
    public void sendBuffer(Buffer buffer) throws SQLException {
        try {
            this.yasSocketConnection.send(buffer);
        }
        catch (IOException e) {
            throw SQLError.createSQLException("io fail:" + e.getMessage(), YasState.IO_ERROR, (Throwable)e);
        }
    }

    @Override
    public void sendPacket(Packet packet) throws SQLException {
        packet.encode(this.session.getConnectVersion());
        this.sendBuffer(packet);
        try {
            this.yasSocketConnection.flush();
        }
        catch (IOException e) {
            throw SQLError.createSQLException(Messages.get("protocol error", new Object[0]), YasState.IO_ERROR);
        }
    }

    @Override
    public YasSocketConnection getSocketConnection() {
        return this.yasSocketConnection;
    }

    private void receiveHeader(Packet packet) throws YasException {
        try {
            this.yasSocketConnection.receive(packet, 0, 8);
        }
        catch (IOException e) {
            throw SQLError.createSQLException("io fail:" + e.getMessage(), YasState.IO_ERROR, (Throwable)e);
        }
    }

    @Override
    public Packet receivePacket() throws SQLException {
        if (this.receive == null) {
            this.receive = new Packet(this.packetSize, CharacterSet.getCharSet(this.charset));
        }
        this.receive.clean();
        this.receiveHeader(this.receive);
        try {
            this.yasSocketConnection.receive(this.receive, 8, this.receive.getMessageSize());
        }
        catch (IOException e) {
            throw SQLError.createSQLException("io fail:" + e.getMessage(), YasState.IO_ERROR, (Throwable)e);
        }
        this.checkServerCmdVersion(this.receive);
        this.checkServerError(this.receive);
        return this.receive;
    }

    @Override
    public Packet sendCommand(Packet packet, MsgType msgType, int flags) throws SQLException {
        packet.setCmd(msgType);
        this.sendPacket(packet);
        return this.receivePacket();
    }

    public void sendCommandOnly(Packet packet, MsgType msgType, int flags) throws SQLException {
        packet.setCmd(msgType);
        this.sendPacket(packet);
    }

    @Override
    public Packet getSendPacket() {
        if (this.send == null) {
            this.send = new Packet(this.packetSize, CharacterSet.getCharSet(this.charset));
        }
        this.send.clean();
        return this.send;
    }

    @Override
    public void setServerMode(ConnectionServerMode mode) {
        this.conServerMode = (byte)mode.getValue();
    }

    private void ackConnection() throws SQLException {
        AckConnBuffer conMsg = new AckConnBuffer();
        try {
            this.yasSocketConnection.receive(conMsg, 0, 16);
            this.isBigEndian = conMsg.getEndian();
            this.packetSize = conMsg.getPacketSize();
            conMsg.setPostion(1);
            byte encryptMode = conMsg.getByte();
            if (encryptMode == 1) {
                this.isPasswordEncrypt = true;
            } else if (encryptMode == 2) {
                this.isPasswordEncrypt = true;
                this.yasSocketConnection.changeSocketToSsl();
            }
            this.charset = conMsg.getShort();
            conMsg.setPostion(8);
            if (!Arrays.equals(conMsg.getBytes(8), YasConstants.YasNumber)) {
                throw new YasRuntimeException("Incorrect protocol implementation");
            }
        }
        catch (IOException e) {
            throw SQLError.createSQLException("io fail:" + e.getMessage(), YasState.IO_ERROR, (Throwable)e);
        }
    }

    private void loadSessionParameters() throws SQLException {
        Packet packet = this.getSendPacket();
        Packet param = this.sendCommand(packet, MsgType.CMD_SESSION_PARAM, 0);
        int count = param.getShort();
        for (int i = 0; i < count; ++i) {
            byte[] bytes;
            byte nameLen = param.getByte();
            String paramName = new String(param.getBytes(nameLen, bytes = new byte[nameLen]));
            if (paramName.equals("NCHARSET")) {
                param.skip(1);
                this.session.setnCharset(param.getShort());
                continue;
            }
            byte valueLen = param.getByte();
            bytes = new byte[valueLen];
            param.getBytes(valueLen, bytes);
        }
    }

    private void doAuthentication(String user, String password, Properties info) throws SQLException {
        this.sendLogin(user, password, info);
        this.session.setSID(this.receive.getShort());
        this.receive.skip(2);
        this.session.setCharset(this.charset);
        int revConnectVersion = this.receive.getInt();
        if (ConnectVersion.valueOf(revConnectVersion) == ConnectVersion.UNINITIALIZED) {
            revConnectVersion = ConnectVersion.VER1.getValue();
        }
        this.session.setConnectVersion(ConnectVersion.valueOf(revConnectVersion));
        this.session.setSessionKey(this.receive.getInt());
    }

    private void sendLogin(String user, String password, Properties info) throws SQLException {
        if (this.isPasswordEncrypt) {
            this.doSecretLogin(user, password, info);
            return;
        }
        this.doNormalLogin(user, password, info);
    }

    private void doNormalLogin(String user, String password, Properties info) throws SQLException {
        String osUser = System.getProperty("user.name");
        String localName = this.yasSocketConnection.getSocket().getLocalAddress().getCanonicalHostName();
        if (localName == null) {
            localName = "";
        }
        String program = YasProperty.PROGRAM_NAME.get(info);
        Packet packet = this.getSendPacket();
        packet.writeInt(this.session.getConnectVersion().getValue());
        user = this.transformUser(user);
        packet.writeFixString(user, 68);
        packet.writeFixString(password, 64);
        packet.writeFixString(osUser, 68);
        packet.writeFixString(localName, 256);
        packet.writeFixString(program, 256);
        this.sendCommand(packet, MsgType.CMD_LOGIN, 0);
    }

    private String getHostName() {
        String osName = System.getProperty("os.name").toLowerCase();
        String hostName = osName.contains("windows") ? System.getenv("COMPUTERNAME") : System.getenv("HOSTNAME");
        if (hostName != null) {
            return hostName;
        }
        return this.yasSocketConnection.getSocket().getLocalAddress().getCanonicalHostName();
    }

    private String transformUser(String user) {
        if (this.session.isUserCaseSensitive()) {
            user = "\"" + user + "\"";
        }
        return user;
    }

    public void doSecretLogin(String user, String password, Properties info) throws SQLException {
        String osUser = System.getProperty("user.name");
        String localName = this.getHostName();
        if (localName == null) {
            localName = "";
        }
        String program = YasProperty.PROGRAM_NAME.get(info);
        Packet packet = this.getSendPacket();
        packet.writeInt(this.session.getConnectVersion().getValue());
        packet.writeByte((byte)1);
        packet.writeByte((byte)0);
        packet.writeByte(this.conServerMode);
        packet.writeByte((byte)0);
        user = this.transformUser(user);
        packet.writeStringWithByteLength(user);
        packet.writeStringWithByteLength(osUser);
        packet.writeStringWithByteLength(localName);
        packet.writeStringWithByteLength(program);
        Packet revPacket = this.sendCommand(packet, MsgType.CMD_LOGIN, 0);
        int encryVersion = revPacket.getInt();
        int transEncryVersion = revPacket.getInt();
        short saltLen = revPacket.getShort();
        String salt = revPacket.getString(saltLen);
        short secretKeyLen = revPacket.getShort();
        byte[] secretKeyArray = revPacket.getBytes(secretKeyLen);
        String keyPassword = YasEncrypt.encryptSHA(password, salt, encryVersion);
        if (keyPassword == null) {
            throw SQLError.createSQLException("Encrypt SHA password fail", YasState.UNKNOWN_STATE);
        }
        byte[] plainKey = YasEncrypt.decryptAES(keyPassword.getBytes(), secretKeyArray, transEncryVersion);
        if (plainKey == null) {
            throw SQLError.createSQLException("decryptDes plainKey fail", YasState.UNKNOWN_STATE);
        }
        byte[] secretPassword = YasEncrypt.encryptAES(plainKey, password.getBytes(), transEncryVersion);
        if (secretPassword == null) {
            throw SQLError.createSQLException("encryptDes secretPassword fail", YasState.UNKNOWN_STATE);
        }
        Packet packet2 = this.getSendPacket();
        packet2.writeShort((short)secretPassword.length);
        packet2.writeBytes(secretPassword);
        this.sendCommand(packet2, MsgType.CMD_DIGEST, 0);
    }

    private void checkServerCmdVersion(Packet packet) throws SQLException {
        MsgType msgType = packet.getCmd();
        if (packet.getCmdVersion() != msgType.getVersion(this.session.getConnectVersion())) {
            throw SQLError.createSQLException("protocol error, command version is not compatible", YasState.PROTOCOL_VIOLATION);
        }
    }

    public void checkServerError(Packet packet) throws SQLException {
        if (packet.isError()) {
            ErrorBuffer errorPacket = new ErrorBuffer(packet, CharacterSet.getCharSet(this.charset));
            ServerErrorMessage errorMessage = new ServerErrorMessage(errorPacket.getErrorCode(), errorPacket.getLine(), errorPacket.getColumn(), errorPacket.getErrorMsg());
            LOGGER.error(errorMessage.toString());
            throw SQLError.createSQLException(errorMessage, true);
        }
        if (packet.hasInfo()) {
            ErrorBuffer warningPacket = new ErrorBuffer(packet, CharacterSet.getCharSet(this.charset));
            ServerErrorMessage warningMessage = new ServerErrorMessage(warningPacket.getErrorCode(), warningPacket.getLine(), warningPacket.getColumn(), warningPacket.getErrorMsg());
            YasWarning warning = new YasWarning(warningMessage);
            this.session.addWarning(warning);
            LOGGER.warn(warningMessage.toString());
        }
    }
}

