/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.ConnectVersion;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.BaseBuffer;
import com.yashandb.protocol.Buffer;
import com.yashandb.protocol.MsgType;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class Packet
extends BaseBuffer {
    public static final int HEAD_PACKET_LEN = 8;
    public static final int SUCESS = 0;
    public static final int SUCCESS_WITH_INFO = 1;
    public static final int ERROR = -1;
    public static final int COLHEAD_NULL = 255;
    public static final int COLHEAD_LONG = 253;
    private static final int HEAD_FLAG_MORE_DATA = 1;
    private static final int HEAD_FLAG_NO_MORE_DATA = 254;
    private static final int HEAD_PACKET_SIZE_OFFSET = 0;
    private static final int HEAD_CMD_OFFSET = 4;
    private static final int HEAD_RESULT_OFFSET = 5;
    private static final int HEAD_FLAG_OFFSET = 6;
    private static final int HEAD_CMD_VER_OFFSET = 7;
    MsgType msgType;
    int result;
    int flag = 0;

    public Packet(int capacity, Charset charset) {
        super(capacity);
        this.setCharset(charset);
    }

    public Packet(Buffer buffer, Charset charset) {
        super(buffer);
        this.setCharset(charset);
    }

    public int getRowSize() {
        int colHead = this.getByte() & 0xFF;
        if (colHead == 255) {
            return 0;
        }
        if (colHead < 253) {
            return colHead;
        }
        return this.getShort() & 0xFFFF;
    }

    public void encode(ConnectVersion clientVersion) {
        this.writeInt(0, this.position);
        this.writeByte(4, (byte)this.msgType.getValue());
        this.writeByte(5, (byte)this.result);
        this.writeByte(6, (byte)this.flag);
        this.writeByte(7, (byte)this.msgType.getVersion(clientVersion));
    }

    public int getMessageSize() {
        int msgSize = this.getInt(0);
        return msgSize - 8;
    }

    public MsgType getCmd() throws SQLException {
        byte cmdType = this.getByte(4);
        if (cmdType >= MsgType.values().length) {
            SQLError.createSQLException("protocol error, invalid command type", YasState.PROTOCOL_VIOLATION);
        }
        return MsgType.values()[cmdType];
    }

    public void setCmd(MsgType cmd) {
        this.msgType = cmd;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public boolean isError() {
        return this.getByte(5) == -1;
    }

    public boolean hasInfo() {
        return this.getByte(5) == 1;
    }

    public byte getCmdVersion() {
        return this.getByte(7);
    }

    public void setHasMore(boolean hasMore) {
        this.flag = hasMore ? (int)((byte)(this.flag | 1)) : (int)((byte)(this.flag & 0xFE));
    }

    @Override
    public void clean() {
        super.clean();
        this.result = 0;
        this.flag = 0;
    }

    public boolean hasReadToEnd() {
        return this.position >= this.getMessageSize() + 8;
    }
}

