/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.ParameterList;
import com.yashandb.SessionImpl;
import com.yashandb.YasResultSet;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.DebugFrame;
import com.yashandb.jdbc.DebugFrameImpl;
import com.yashandb.jdbc.DebugVar;
import com.yashandb.jdbc.DebugVarImpl;
import com.yashandb.jdbc.Field;
import com.yashandb.jdbc.ResultSetFactory;
import com.yashandb.jdbc.ResultSetImpl;
import com.yashandb.jdbc.Row;
import com.yashandb.jdbc.RowData;
import com.yashandb.jdbc.RowDataFactory;
import com.yashandb.jdbc.StatementImpl;
import com.yashandb.jdbc.YasDebugCallableStatement;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.YasStatement;
import com.yashandb.jdbc.exception.BatchError;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasBatchUpdateException;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.parameter.YasParameter;
import com.yashandb.protocol.DebugOperation;
import com.yashandb.protocol.DebugVarInfo;
import com.yashandb.protocol.ExecuteResult;
import com.yashandb.protocol.LobOperation;
import com.yashandb.protocol.MsgType;
import com.yashandb.protocol.Packet;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.protocol.accessor.AccessorFactory;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.CharacterSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;

public class PacketProcessor {
    private static final int PREPARE_MASK_LEN = -2;
    private static final int SQL_LEN_MORE_FLAG = 1;
    private static final int PREPARE_ACK_NULLABLE_FLAG = 1;
    private static final int EXECUTE_FLAG_AUTO_COMMIT = 1;
    private static final int EXECUTE_FLAG_DML_ROW = 4;
    private static final int EXECUTE_FLAG_BATCH_ERROR = 8;
    private static final int EXECUTE_FLAG_DEBUG = 128;

    public static void writeReqSql(Packet sendPacket, byte[] sqlBytes, int start, int sqlLen, boolean sqlMore) {
        if (sqlLen <= 0) {
            return;
        }
        int reqLenFlag = 0;
        int reqLen = sqlLen << 1;
        reqLenFlag |= (reqLen &= 0xFFFFFFFE);
        if (sqlMore) {
            reqLenFlag |= 1;
        }
        sendPacket.writeInt(reqLenFlag);
        sendPacket.writeBytes(sqlBytes, start, sqlLen);
    }

    public static void writeReqPrepare(StatementImpl statement, Packet preparePacket) {
        preparePacket.writeShort(statement.getID());
        preparePacket.skip(2);
    }

    private static byte getExecFlag(boolean autoCommit) {
        byte executeFlag = 0;
        if (autoCommit) {
            executeFlag = (byte)(executeFlag | 1);
        }
        return executeFlag;
    }

    private static byte getExecFlag(boolean autoCommit, boolean isDebug) {
        byte executeFlag = 0;
        if (autoCommit) {
            executeFlag = (byte)(executeFlag | 1);
        }
        if (isDebug) {
            executeFlag = (byte)(executeFlag | 0x80);
        }
        return executeFlag;
    }

    private static byte getExecFlag(boolean autoCommit, boolean dmlRow, boolean batchError) {
        byte executeFlag = 0;
        if (autoCommit) {
            executeFlag = (byte)(executeFlag | 1);
        }
        if (dmlRow) {
            executeFlag = (byte)(executeFlag | 4);
        }
        if (batchError) {
            executeFlag = (byte)(executeFlag | 8);
        }
        return executeFlag;
    }

    private static byte getExecFlag(boolean autoCommit, boolean dmlRow, boolean batchError, boolean isDebug) {
        byte executeFlag = 0;
        if (autoCommit) {
            executeFlag = (byte)(executeFlag | 1);
        }
        if (dmlRow) {
            executeFlag = (byte)(executeFlag | 4);
        }
        if (batchError) {
            executeFlag = (byte)(executeFlag | 8);
        }
        if (isDebug) {
            executeFlag = (byte)(executeFlag | 0x80);
        }
        return executeFlag;
    }

    public static void writeReqLob(Packet sendPacket, LobOperation lobOperation, YasLobProcessor lobProcessor, int reqLen, long offset) {
        byte[] lobLocator = lobProcessor.getLobLocator();
        int lobType = lobProcessor.getLobType();
        sendPacket.writeByte((byte)lobOperation.getValue());
        sendPacket.writeByte((byte)0);
        sendPacket.writeByte((byte)lobType);
        if (lobLocator == null) {
            sendPacket.writeByte((byte)lobProcessor.getCsLobLocatorSize());
        } else {
            sendPacket.writeByte((byte)lobLocator.length);
        }
        sendPacket.writeInt(reqLen);
        sendPacket.writeLong(offset);
        if (lobLocator == null) {
            sendPacket.skip(80);
        } else {
            sendPacket.writeBytes(lobLocator);
        }
    }

    public static void writeReqLobByLobLocator(Packet sendPacket, LobOperation lobOperation, YasLobProcessor lobProcessor, int reqLen, long offset) {
        byte[] lobLocator = lobProcessor.getLobLocator();
        int lobType = lobProcessor.getLobType();
        sendPacket.writeByte((byte)lobOperation.getValue());
        sendPacket.writeByte((byte)1);
        sendPacket.writeByte((byte)lobType);
        if (lobLocator == null) {
            sendPacket.writeByte((byte)lobProcessor.getCsLobLocatorSize());
        } else {
            sendPacket.writeByte((byte)lobLocator.length);
        }
        sendPacket.writeInt(reqLen);
        sendPacket.writeLong(offset);
        if (lobLocator == null) {
            sendPacket.skip(80);
        } else {
            sendPacket.writeBytes(lobLocator);
        }
    }

    public static void writeReqExecute(YasStatement statement, Packet sendPacket, boolean autoCommit) {
        sendPacket.writeShort(statement.getID());
        sendPacket.writeByte(PacketProcessor.getExecFlag(autoCommit));
        sendPacket.writeByte((byte)0);
        sendPacket.writeShort(0);
        sendPacket.writeShort(1);
        int fetchSize = 0;
        try {
            fetchSize = statement.getFetchSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sendPacket.writeInt(fetchSize);
    }

    public static void writeReqExecute(YasStatement statement, Packet sendPacket, boolean autoCommit, boolean isDebug) {
        sendPacket.writeShort(statement.getID());
        sendPacket.writeByte(PacketProcessor.getExecFlag(autoCommit, isDebug));
        sendPacket.writeByte((byte)0);
        sendPacket.writeShort(0);
        sendPacket.writeShort(1);
        int fetchSize = 0;
        try {
            fetchSize = statement.getFetchSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        sendPacket.writeInt(fetchSize);
    }

    public static void writeFetchCursor(short cursorId, Packet sendPacket, int preFetchSize) {
        sendPacket.writeShort(cursorId);
        sendPacket.writeByte(PacketProcessor.getExecFlag(false));
        sendPacket.writeByte((byte)0);
        sendPacket.writeShort(0);
        sendPacket.writeShort(1);
        sendPacket.writeInt(preFetchSize);
    }

    public static void writeReqFetch(YasStatement statement, Packet sendPacket) {
        sendPacket.writeShort(statement.getID());
        sendPacket.writeShort(0);
    }

    public static void writeReqExecute(StatementImpl statement, Packet sendPacket, ParameterList[] parameters, boolean autoCommit, boolean isDebug) throws SQLException {
        sendPacket.writeShort(statement.getID());
        if (parameters.length > 1) {
            boolean dmlRow = true;
            sendPacket.writeByte(PacketProcessor.getExecFlag(autoCommit, dmlRow, statement.getIsBatchError(), isDebug));
        } else {
            sendPacket.writeByte(PacketProcessor.getExecFlag(autoCommit, isDebug));
        }
        sendPacket.writeByte((byte)0);
        if (parameters.length > 0) {
            sendPacket.writeShort(parameters[0].getParameterCount());
        } else {
            sendPacket.writeShort(0);
        }
        sendPacket.writeShort((short)parameters.length);
        sendPacket.writeInt(statement.getFetchSize());
        PacketProcessor.putParamType(parameters[0], sendPacket);
    }

    public static void writeReqDirectExecute(StatementImpl statement, Packet sendPacket, ParameterList[] parameters, boolean autoCommit, boolean isDebug) throws SQLException {
        sendPacket.writeShort(statement.getID());
        if (parameters.length > 1) {
            boolean dmlRow = true;
            sendPacket.writeByte(PacketProcessor.getExecFlag(autoCommit, dmlRow, statement.getIsBatchError(), isDebug));
        } else {
            sendPacket.writeByte(PacketProcessor.getExecFlag(autoCommit, isDebug));
        }
        sendPacket.writeByte((byte)0);
        if (parameters.length > 0) {
            sendPacket.writeShort(parameters[0].getParameterCount());
        } else {
            sendPacket.writeShort(0);
        }
        sendPacket.writeShort((short)parameters.length);
        sendPacket.writeInt(statement.getFetchSize());
    }

    public static void writeReqExecuteParamType(StatementImpl statement, Packet sendPacket, ParameterList[] parameters) throws SQLException {
        PacketProcessor.putParamType(parameters[0], sendPacket);
    }

    private static void putParamType(ParameterList parameter, Packet reqExecute) throws YasException {
        if (parameter != null) {
            for (int i = 0; i < parameter.getParameterCount(); ++i) {
                YasParameter yasParameter = parameter.getParameters()[i];
                if (yasParameter == null) {
                    throw SQLError.createSQLException("Parameter is missing,index:" + (i + 1), YasState.UNKNOWN_STATE);
                }
                yasParameter.writeInfo(reqExecute);
            }
        }
    }

    public static long processLobMetaDataAck(YasLobProcessor lobProcessor, Packet ackPacket, LobOperation operation) throws SQLException {
        byte[] lobLocator = lobProcessor.getLobLocator();
        int locatorLen = ackPacket.getByte();
        byte dataInfo = ackPacket.getByte();
        boolean hasData = (dataInfo & 1) != 0;
        boolean dataEof = (dataInfo & 2) != 0;
        ackPacket.skip(2);
        int dataLen = ackPacket.getInt();
        long retValue = ackPacket.getLong();
        byte[] ackLocator = ackPacket.getBytes(locatorLen);
        if (operation == LobOperation.LOB_WRITE || operation == LobOperation.LOB_TRIM) {
            lobProcessor.setLobLocator(ackLocator);
        } else {
            for (int i = 0; i < locatorLen; ++i) {
                if (ackLocator[i] == lobLocator[i]) continue;
                throw new YasException("ack lob locator verify fail", YasState.DATA_ERROR);
            }
        }
        return retValue;
    }

    public static byte[] processLobCreateAck(Packet ackPacket) throws SQLException {
        byte locatorLen = ackPacket.getByte();
        byte dataInfo = ackPacket.getByte();
        ackPacket.skip(2);
        int dataLen = ackPacket.getInt();
        long retValue = ackPacket.getLong();
        return ackPacket.getBytes(locatorLen);
    }

    public static int processLobDataAck(byte[] lobLocator, Packet ackPacket, byte[] cacheData) throws SQLException {
        int locatorLen = ackPacket.getByte();
        byte dataInfo = ackPacket.getByte();
        boolean hasData = (dataInfo & 1) != 0;
        boolean dataEof = (dataInfo & 2) != 0;
        ackPacket.skip(2);
        int dataLen = ackPacket.getInt();
        long retValue = ackPacket.getLong();
        byte[] ackLocator = ackPacket.getBytes(locatorLen);
        for (int i = 0; i < locatorLen; ++i) {
            if (ackLocator[i] == lobLocator[i]) continue;
            throw new YasException("ack lob locator verify fail", YasState.DATA_ERROR);
        }
        if (hasData) {
            if (dataLen < 0) {
                throw new YasException("lob data length wrong: " + dataLen, YasState.DATA_ERROR);
            }
            if (cacheData.length < dataLen) {
                throw new YasException("lob cache buffer size: " + cacheData.length + " is small than ack data length: " + dataLen, YasState.OUT_OF_MEMORY);
            }
            ackPacket.getBytes(dataLen, cacheData);
            return dataLen;
        }
        return 0;
    }

    public static Packet processInteractPacket(StatementImpl statement, Packet ackPacket, SessionImpl session) throws SQLException {
        while (ackPacket.getCmd() == MsgType.CMD_RETURN_RESULT) {
            short cursorId = ackPacket.getShort();
            YasResultSet resultSet = session.fetchReturnResultSet(cursorId);
            statement.addImplicitResultSet(resultSet);
            ackPacket = session.continueExecute();
        }
        return ackPacket;
    }

    public static YasResultSet processFetchImplicitResultAck(StatementImpl stmt, Packet fetchCursorAck, SessionImpl session) throws SQLException {
        short stmtID = fetchCursorAck.getShort();
        short columnCount = fetchCursorAck.getShort();
        short paramCount = fetchCursorAck.getShort();
        byte sqlType = fetchCursorAck.getByte();
        fetchCursorAck.skip(1);
        ExecuteResult exeResult = new ExecuteResult(fetchCursorAck);
        exeResult.getDMLError(fetchCursorAck);
        stmt.setStmtID(stmtID, sqlType);
        if (columnCount <= 0 || paramCount > 0) {
            throw SQLError.createSQLException("invalid return result", YasState.DATA_ERROR);
        }
        Field[] resultFields = PacketProcessor.getPrepColumns(fetchCursorAck, columnCount);
        stmt.setFields(resultFields);
        return PacketProcessor.getCacheResultSetFromExecResult(stmt, resultFields, exeResult, fetchCursorAck, session);
    }

    public static YasResultSet processDirectExecuteAck(StatementImpl stmt, Packet ackPacket, SessionImpl session) throws SQLException {
        short stmtID = ackPacket.getShort();
        short columnCount = ackPacket.getShort();
        short paramCount = ackPacket.getShort();
        byte sqlType = ackPacket.getByte();
        ackPacket.skip(1);
        stmt.setStmtID(stmtID, sqlType);
        ExecuteResult result = new ExecuteResult(ackPacket);
        if (columnCount > 0) {
            Field[] resultFields = PacketProcessor.getPrepColumns(ackPacket, columnCount);
            stmt.setFields(resultFields);
        } else {
            stmt.setFields(null);
        }
        if (paramCount > 0) {
            Field[] parameterFields = PacketProcessor.getPrepParams(ackPacket, paramCount);
            stmt.setParameters(parameterFields);
        }
        result.getDMLError(ackPacket);
        return PacketProcessor.getResultSetFromExecResult(stmt, result, ackPacket, session);
    }

    public static YasResultSet processExecuteAck(StatementImpl stmt, Packet ack, SessionImpl session) throws SQLException {
        ExecuteResult result = new ExecuteResult(ack);
        result.getDMLError(ack);
        return PacketProcessor.getResultSetFromExecResult(stmt, result, ack, session);
    }

    public static YasResultSet processExecuteAckInBatchMode(StatementImpl stmt, Packet ack, SessionImpl session) throws SQLException {
        ExecuteResult result = new ExecuteResult(ack, true);
        result.getDMLError(ack);
        return PacketProcessor.getResultSetFromExecResult(stmt, result, ack, session);
    }

    public static void processPrepareAck(StatementImpl query, Packet ack) throws SQLException {
        short stmtID = ack.getShort();
        short columnCount = ack.getShort();
        short paramCount = ack.getShort();
        byte sqlType = ack.getByte();
        ack.skip(1);
        query.setStmtID(stmtID, sqlType);
        if (columnCount > 0) {
            Field[] resultFields = PacketProcessor.getPrepColumns(ack, columnCount);
            query.setFields(resultFields);
        }
        if (paramCount > 0) {
            Field[] parameterFields = PacketProcessor.getPrepParams(ack, paramCount);
            query.setParameters(parameterFields);
        }
    }

    private static Field[] getPrepParams(Packet ack, short paramCount) {
        Field[] fields = new Field[paramCount];
        for (short i = 0; i < paramCount; i = (short)(i + 1)) {
            int packSize = ack.getRowSize();
            String name = ack.getString(packSize);
            fields[i] = new Field(i, name, 0, -1, 0, 0, 0);
        }
        return fields;
    }

    private static Field[] getPrepColumns(Packet ack, short columnCount) throws SQLException {
        Field[] fields = new Field[columnCount];
        for (short i = 0; i < columnCount; i = (short)(i + 1)) {
            int packSize = ack.getRowSize();
            short id = ack.getShort();
            short size = ack.getShort();
            byte type = ack.getByte();
            byte precision = ack.getByte();
            byte scale = ack.getByte();
            int nullable = ack.getByte() & 1;
            byte nameLen = ack.getByte();
            String name = ack.getString(nameLen);
            if (nameLen + 9 != packSize) {
                throw SQLError.createSQLException("prepare ack protocol error", YasState.UNKNOWN_STATE);
            }
            fields[i] = new Field(id, name, type, size, nullable, precision, scale);
        }
        return fields;
    }

    private static YasResultSet getCacheResultSetFromExecResult(StatementImpl statement, Field[] fields, ExecuteResult exeResult, Packet ackPacket, SessionImpl session) throws SQLException {
        session.setTransactionState(exeResult.getXactStatus());
        RowData rowData = RowDataFactory.createRowDataImpl(session, statement, ackPacket, exeResult);
        rowData.decodeRows(0);
        return ResultSetFactory.createCachedResultSet(statement, fields, rowData);
    }

    private static YasResultSet getResultSetFromExecResult(StatementImpl statement, ExecuteResult result, Packet ackPacket, SessionImpl session) throws SQLException {
        YasResultSet results;
        if (result.getOutParams() > 0) {
            byte[][] row = new byte[result.getOutParams()][];
            for (int i = 0; i < result.getOutParams(); ++i) {
                int len;
                if (ackPacket.hasReadToEnd()) {
                    ackPacket = session.moreData();
                }
                row[i] = (byte[])((len = ackPacket.getRowSize()) == 0 ? null : ackPacket.getBytes(len));
            }
            Row outParameterRow = new Row(row);
            statement.createParameterResult(outParameterRow);
        }
        session.setTransactionState(result.getXactStatus());
        if (statement.getColumnCount() == 0) {
            if (result.isHasBatchRows()) {
                if (result.isHasBatchError() && !statement.getIsBatchError()) {
                    int num = result.getBatchErrors().keySet().iterator().next();
                    BatchError batchError = result.getBatchErrors().values().iterator().next();
                    throw new YasBatchUpdateException(num, batchError, result.getDmlRows());
                }
                results = new ResultSetImpl(result.getAffectedRows(), session.getConnection(), statement, result.getDmlRows(), result.getBatchErrors());
            } else {
                results = new ResultSetImpl(result.getAffectedRows(), session.getConnection(), statement);
            }
        } else {
            RowData r = RowDataFactory.createRowDataImpl(session, statement, ackPacket, result);
            r.decodeRows(0);
            results = statement.createResultSet(r);
        }
        return results;
    }

    public static void writeReqDebug(YasStatement statement, Packet sendPacket, DebugOperation debugOperation, int reqLength) {
        sendPacket.writeShort(statement.getID());
        sendPacket.writeByte((byte)debugOperation.getValue());
        sendPacket.writeByte((byte)0);
        sendPacket.writeInt(reqLength);
        sendPacket.writeInt(0);
    }

    public static Object processDebugMetaDataAck(SessionImpl session, YasDebugCallableStatement statement, Packet ackPacket, DebugOperation operation) throws SQLException {
        byte debugCmd = ackPacket.getByte();
        byte debugStatus = ackPacket.getByte();
        ackPacket.skip(2);
        int varCount = ackPacket.getInt();
        DebugOperation ackOperation = DebugOperation.valueOf(debugCmd);
        if (ackOperation == DebugOperation.DBG_ADD_BP) {
            ackPacket.skip(29);
            int valueLength = ackPacket.getRowSize();
            return ackPacket.getInt();
        }
        if (ackOperation == DebugOperation.DBG_SHOW_VARS) {
            ArrayList<DebugVar> debugVarList = new ArrayList<DebugVar>();
            if (varCount > 0) {
                PacketProcessor.getDebugVars(session, ackPacket, varCount, debugVarList);
            }
            return debugVarList;
        }
        if (ackOperation == DebugOperation.DBG_SHOW_FRAMES) {
            ArrayList<DebugFrame> debugFrameList = new ArrayList<DebugFrame>();
            if (varCount > 0) {
                PacketProcessor.getDebugFrames(session, ackPacket, varCount, debugFrameList);
            }
            return debugFrameList;
        }
        if (ackOperation == DebugOperation.DBG_START || ackOperation == DebugOperation.DBG_CONTINUE || ackOperation == DebugOperation.DBG_STEP_INTO || ackOperation == DebugOperation.DBG_STEP_NEXT || ackOperation == DebugOperation.DBG_STEP_OUT) {
            PacketProcessor.updateDebugStatus(session, statement, ackPacket);
            return null;
        }
        return null;
    }

    public static YasResultSet processDebugExecutePacket(YasDebugCallableStatement statement, Packet ackPacket, SessionImpl session, DebugOperation operation) throws SQLException {
        if (ackPacket.getCmd() == MsgType.CMD_DEBUG) {
            PacketProcessor.processDebugMetaDataAck(session, statement, ackPacket, operation);
            return null;
        }
        session.setDebugOff();
        return PacketProcessor.processExecuteAck(statement, ackPacket, session);
    }

    private static void getDebugVars(SessionImpl session, Packet ack, int varCount, ArrayList<DebugVar> debugVarList) throws SQLException {
        for (int i = 0; i < varCount; i = (int)((short)(i + 1))) {
            int varLength;
            if (ack.hasReadToEnd()) {
                ack = session.moreData();
            }
            DebugVarImpl var = new DebugVarImpl();
            DebugVarInfo debugVarInfo = new DebugVarInfo(ack);
            int type = debugVarInfo.getType();
            var.setName(debugVarInfo.getName());
            var.setDataType(type);
            var.setBlockNo(debugVarInfo.getBlockNo());
            var.setGlobal(debugVarInfo.isGlobal());
            if (type == 0) {
                var.setVar(null);
                debugVarList.add(var);
                continue;
            }
            if (ack.hasReadToEnd()) {
                ack = session.moreData();
            }
            if ((varLength = ack.getRowSize()) <= 0) {
                var.setVar(null);
                debugVarList.add(var);
                continue;
            }
            byte[] bytes = ack.getBytes(varLength);
            if (type == 35 || type == 29 || type == 30) {
                type = 26;
            }
            Accessor accessor = AccessorFactory.generateAccessorByDataType(type, session);
            switch (type) {
                case 19: 
                case 20: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    var.setVar(accessor.getString(bytes));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: {
                    var.setVar(accessor.getBigDecimal(bytes));
                    break;
                }
                case 13: 
                case 14: {
                    var.setVar(accessor.getDate(bytes, null));
                    break;
                }
                case 15: {
                    var.setVar(accessor.getTime(bytes, null));
                    break;
                }
                case 16: 
                case 17: 
                case 18: {
                    var.setVar(accessor.getTimestamp(bytes, null));
                    break;
                }
                case 1: {
                    var.setVar(accessor.getBoolean(bytes));
                    break;
                }
                case 31: {
                    var.setVar(accessor.getByte(bytes));
                    break;
                }
                case 32: {
                    var.setVar(accessor.getRowId(bytes));
                    break;
                }
                case 28: {
                    var.setVar(accessor.getString(bytes));
                    break;
                }
                case 34: {
                    var.setVar(null);
                    break;
                }
                default: {
                    throw SQLError.createSQLException("Unexpected DataType " + type, YasState.DATA_ERROR);
                }
            }
            debugVarList.add(var);
        }
    }

    private static void getDebugFrames(SessionImpl session, Packet ack, int varCount, ArrayList<DebugFrame> debugFrameList) throws SQLException {
        for (int i = 0; i < varCount; i = (int)((short)(i + 1))) {
            int strLength;
            if (ack.hasReadToEnd()) {
                ack = session.moreData();
            }
            DebugFrameImpl frame = new DebugFrameImpl();
            DebugVarInfo debugVarInfo = new DebugVarInfo(ack);
            int type = debugVarInfo.getType();
            frame.setClassInfo(debugVarInfo.getName());
            frame.setLineNum(debugVarInfo.getLineNo());
            frame.setBlockNo(debugVarInfo.getBlockNo());
            if (type != 24 && type != 26 && type != 25 && type != 27) {
                throw SQLError.createSQLException("Unexpected DataType", YasState.UNKNOWN_STATE);
            }
            if (ack.hasReadToEnd()) {
                ack = session.moreData();
            }
            if ((strLength = ack.getRowSize()) > 0) {
                byte[] strBytes = new byte[strLength];
                ack.getBytes(strLength, strBytes);
                String strValue = new String(strBytes, CharacterSet.getCharSet(session.getCharset()));
                frame.setMethodInfo(strValue);
            }
            debugFrameList.add(frame);
        }
    }

    private static void updateDebugStatus(SessionImpl session, YasDebugCallableStatement statement, Packet ack) throws SQLException {
        DebugVarInfo debugVarInfo = new DebugVarInfo(ack);
        int type = debugVarInfo.getType();
        if (type != 3 && type != 4 && type != 5 && type != 2 && type != 10 && type != 11 && type != 12) {
            throw SQLError.createSQLException("Unexpected DataType", YasState.UNKNOWN_STATE);
        }
        int valueLength = ack.getRowSize();
        if (valueLength > 0) {
            BigDecimal bigDecimal = ByteConverter.toBigDecimal(ack.getBytes(valueLength), 0);
            session.updateDebugStatus(statement, debugVarInfo.getObjectId(), debugVarInfo.getSubId(), bigDecimal.intValue());
        }
    }
}

