/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.IntervalType;
import com.yashandb.util.YasTime;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.util.Calendar;

public class TypeConverter {
    private static String asString(Clob in) throws SQLException {
        return in.getSubString(1L, (int)in.length());
    }

    public static int castToInt(Object in, int targetType) throws SQLException {
        try {
            if (in instanceof String) {
                return Integer.parseInt((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).intValue();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1 : 0;
            }
            if (in instanceof Clob) {
                return Integer.parseInt(TypeConverter.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Integer.parseInt(in.toString());
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName(), e);
        }
        throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName());
    }

    public static short castToShort(Object in, int targetType) throws SQLException {
        try {
            if (in instanceof String) {
                return Short.parseShort((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).shortValue();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? (short)1 : 0;
            }
            if (in instanceof Clob) {
                return Short.parseShort(TypeConverter.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Short.parseShort(in.toString());
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName(), e);
        }
        throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName());
    }

    public static long castToLong(Object in, int targetType) throws SQLException {
        try {
            if (in instanceof String) {
                return Long.parseLong((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).longValue();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1L : 0L;
            }
            if (in instanceof Clob) {
                return Long.parseLong(TypeConverter.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Long.parseLong(in.toString());
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName(), e);
        }
        throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName());
    }

    public static float castToFloat(Object in, int targetType) throws SQLException {
        try {
            if (in instanceof String) {
                return Float.parseFloat((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).floatValue();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0f : 0.0f;
            }
            if (in instanceof Clob) {
                return Float.parseFloat(TypeConverter.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Float.parseFloat(in.toString());
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName(), e);
        }
        throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName());
    }

    public static double castToDouble(Object in, int targetType) throws SQLException {
        try {
            if (in instanceof String) {
                return Double.parseDouble((String)in);
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue();
            }
            if (in instanceof Boolean) {
                return (Boolean)in != false ? 1.0 : 0.0;
            }
            if (in instanceof Clob) {
                return Double.parseDouble(TypeConverter.asString((Clob)in));
            }
            if (in instanceof Character) {
                return Double.parseDouble(in.toString());
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName(), e);
        }
        throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName());
    }

    public static BigDecimal castToBigDecimal(Object in, int scale, int targetType) throws SQLException {
        try {
            BigDecimal rc = null;
            if (in instanceof String) {
                rc = new BigDecimal((String)in);
            } else if (in instanceof BigDecimal) {
                rc = (BigDecimal)in;
            } else if (in instanceof BigInteger) {
                rc = new BigDecimal((BigInteger)in);
            } else if (in instanceof Long || in instanceof Integer || in instanceof Short || in instanceof Byte) {
                rc = BigDecimal.valueOf(((Number)in).longValue());
            } else if (in instanceof Double || in instanceof Float) {
                rc = BigDecimal.valueOf(((Number)in).doubleValue());
            } else if (in instanceof Boolean) {
                rc = (Boolean)in != false ? BigDecimal.ONE : BigDecimal.ZERO;
            } else if (in instanceof Clob) {
                rc = new BigDecimal(TypeConverter.asString((Clob)in));
            } else if (in instanceof Character) {
                rc = new BigDecimal(new char[]{((Character)in).charValue()});
            }
            if (rc != null) {
                if (scale >= 0) {
                    rc = rc.setScale(scale, RoundingMode.HALF_UP);
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName(), e);
        }
        throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName());
    }

    public static String castToString(Object in, int targetType, int scale) throws SQLException {
        try {
            if (in instanceof String) {
                return (String)in;
            }
            if (in instanceof Clob) {
                return TypeConverter.asString((Clob)in);
            }
            if (in instanceof byte[]) {
                return new String((byte[])in);
            }
            if (in instanceof InputStream) {
                return new String(TypeConverter.getBytesByInputStream((InputStream)in, scale));
            }
            if (in instanceof Boolean || in instanceof Number || in instanceof java.util.Date || in instanceof Calendar || in instanceof LocalDate || in instanceof LocalTime || in instanceof LocalDateTime || in instanceof OffsetTime || in instanceof OffsetDateTime) {
                return in.toString();
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName(), e);
        }
        throw SQLError.TransformException(in.getClass().getName(), JDBCType.valueOf(targetType).getName());
    }

    public static Timestamp castToTimeStamp(Object in) throws SQLException {
        try {
            if (in instanceof Timestamp) {
                return (Timestamp)in;
            }
            if (in instanceof Date) {
                return new Timestamp(((java.util.Date)in).getTime());
            }
            if (in instanceof Time) {
                return new Timestamp(((Time)in).getTime());
            }
            if (in instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)in).getTime());
            }
            if (in instanceof Calendar) {
                return new Timestamp(((Calendar)in).getTimeInMillis());
            }
            if (in instanceof LocalDateTime) {
                return Timestamp.valueOf((LocalDateTime)in);
            }
            if (in instanceof String) {
                return Timestamp.valueOf((String)in);
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), "Timestamp", e);
        }
        throw SQLError.TransformException(in.getClass().getName(), "Timestamp");
    }

    public static boolean castToBoolean(Object in) throws SQLException {
        try {
            if (in instanceof String) {
                if ("TRUE".equalsIgnoreCase((String)in) || "ON".equalsIgnoreCase((String)in) || "YES".equalsIgnoreCase((String)in) || "T".equalsIgnoreCase((String)in) || "Y".equalsIgnoreCase((String)in) || "1".equals((String)in)) {
                    return true;
                }
                if ("FALSE".equalsIgnoreCase((String)in) || "OFF".equalsIgnoreCase((String)in) || "NO".equalsIgnoreCase((String)in) || "F".equalsIgnoreCase((String)in) || "N".equalsIgnoreCase((String)in) || "0".equals((String)in)) {
                    return false;
                }
            }
            if (in instanceof Boolean) {
                return (Boolean)in;
            }
            if (in instanceof Number) {
                return ((Number)in).doubleValue() != 0.0;
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), "Boolean", e);
        }
        throw SQLError.TransformException(in.getClass().getName(), "Boolean");
    }

    public static Time castToTime(Object in) throws SQLException {
        try {
            if (in instanceof Time) {
                return (Time)in;
            }
            if (in instanceof Timestamp) {
                YasTime at = new YasTime(((Timestamp)in).getTime());
                at.setNanos(((Timestamp)in).getNanos());
                return at;
            }
            if (in instanceof java.util.Date) {
                return new Time(((java.util.Date)in).getTime());
            }
            if (in instanceof LocalTime) {
                return YasTime.valueOf((LocalTime)in);
            }
            if (in instanceof Calendar) {
                return new Time(((Calendar)in).getTimeInMillis());
            }
            if (in instanceof LocalDate) {
                return Time.valueOf((LocalTime)in);
            }
            if (in instanceof LocalDateTime) {
                return Time.valueOf(((LocalDateTime)in).toLocalTime());
            }
            if (in instanceof String) {
                return YasTime.valueOf((String)in);
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), "Time", e);
        }
        throw SQLError.TransformException(in.getClass().getName(), "Time");
    }

    public static Date castToDate(Object in) throws SQLException {
        try {
            if (in instanceof Date) {
                return (Date)in;
            }
            if (in instanceof String) {
                return Date.valueOf((String)in);
            }
            if (in instanceof Timestamp) {
                return new Date(((Timestamp)in).getTime());
            }
            if (in instanceof Time) {
                return new Date(((Time)in).getTime());
            }
            if (in instanceof java.util.Date) {
                return new Date(((java.util.Date)in).getTime());
            }
            if (in instanceof LocalDate) {
                return Date.valueOf((LocalDate)in);
            }
            if (in instanceof LocalDateTime) {
                return Date.valueOf(((LocalDateTime)in).toLocalDate());
            }
            if (in instanceof Calendar) {
                return new Date(((Calendar)in).getTimeInMillis());
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(in.getClass().getName(), "Date", e);
        }
        throw SQLError.TransformException(in.getClass().getName(), "Date");
    }

    public static long castToDsInterval(Object objectInterval) throws SQLException {
        try {
            if (objectInterval instanceof String) {
                return IntervalType.convertStringToDsInterval((String)objectInterval);
            }
            if (objectInterval instanceof Duration) {
                Duration duration = (Duration)objectInterval;
                return duration.getSeconds() * 1000000L + (long)duration.getNano() / 1000L;
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(objectInterval.getClass().getName(), "DsInterval", e);
        }
        throw SQLError.TransformException(objectInterval.getClass().getName(), "DsInterval");
    }

    public static int castToYmInterval(Object objectInterval) throws SQLException {
        try {
            if (objectInterval instanceof String) {
                return IntervalType.convertStringToYmInterval((String)objectInterval);
            }
            if (objectInterval instanceof Period) {
                Period period = (Period)objectInterval;
                return (int)period.toTotalMonths();
            }
        }
        catch (Exception e) {
            throw SQLError.TransformException(objectInterval.getClass().getName(), "YmInterval", e);
        }
        throw SQLError.TransformException(objectInterval.getClass().getName(), "YmInterval");
    }

    public static byte[] getBytesByInputStream(InputStream inputStream, int scale) throws SQLException {
        try {
            byte[] bytes = new byte[scale > 0 ? Math.min(inputStream.available(), scale) : inputStream.available()];
            inputStream.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            throw SQLError.createSQLException(e.getMessage(), YasState.IO_ERROR, (Throwable)e);
        }
    }
}

