/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.Buffer;
import com.yashandb.protocol.YasFilterInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.sql.SQLException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class YasSocketConnection
implements Closeable,
Flushable {
    private String sslRootCer;
    private final SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private final HostSpec hostSpec;
    private Socket socket;
    private YasFilterInputStream yashanInput;
    private BufferedOutputStream yashanOutput;

    public YasSocketConnection(SocketFactory socketFactory, HostSpec hostSpec, int timeout) throws IOException {
        this.socketFactory = socketFactory;
        this.hostSpec = hostSpec;
        Socket socket = this.createSocket(timeout);
        this.changeSocket(socket);
    }

    public YasSocketConnection(YasSocketConnection yasSocketConnection, int timeout, boolean duplicate) throws IOException {
        int sendBufferSize = 1024;
        int receiveBufferSize = 1024;
        int soTimeout = 0;
        boolean keepAlive = false;
        try {
            sendBufferSize = yasSocketConnection.getSocket().getSendBufferSize();
            receiveBufferSize = yasSocketConnection.getSocket().getReceiveBufferSize();
            soTimeout = yasSocketConnection.getSocket().getSoTimeout();
            keepAlive = yasSocketConnection.getSocket().getKeepAlive();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (!duplicate) {
            yasSocketConnection.close();
        }
        this.socketFactory = yasSocketConnection.socketFactory;
        this.hostSpec = yasSocketConnection.hostSpec;
        this.sslSocketFactory = yasSocketConnection.sslSocketFactory;
        Socket socket = this.createSocket(timeout);
        socket.setReceiveBufferSize(receiveBufferSize);
        socket.setSendBufferSize(sendBufferSize);
        this.setNetworkTimeout(soTimeout);
        socket.setKeepAlive(keepAlive);
    }

    public HostSpec getHostSpec() {
        return this.hostSpec;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSslRootCer(String sslRootCer) {
        this.sslRootCer = sslRootCer;
    }

    private Socket createSocket(int timeout) throws IOException {
        Socket socket = this.socketFactory.createSocket();
        if (!socket.isConnected()) {
            InetSocketAddress address = this.hostSpec.shouldResolve() != false ? new InetSocketAddress(this.hostSpec.getHost(), this.hostSpec.getPort()) : InetSocketAddress.createUnresolved(this.hostSpec.getHost(), this.hostSpec.getPort());
            socket.connect(address, timeout);
        }
        this.changeSocket(socket);
        return socket;
    }

    public void initSSLSocket() throws SQLException {
        if (this.sslSocketFactory != null) {
            return;
        }
        if (this.sslRootCer == null) {
            throw SQLError.createSQLException("sslRootCer can not be null", YasState.CONNECTION_FAILURE);
        }
        try {
            String provider = "SunX509";
            String storeType = "JKS";
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(provider);
            KeyStore keyStore = KeyStore.getInstance(storeType);
            keyStore.load(null);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            String certificateAlias = "ca";
            keyStore.setCertificateEntry(certificateAlias, certificateFactory.generateCertificate(new FileInputStream(this.sslRootCer)));
            trustManagerFactory.init(keyStore);
            sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
            sslContext.getSocketFactory();
            this.sslSocketFactory = sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw SQLError.createSQLException("Failed to obtain the sslContext instance. Please check the java version", YasState.UNKNOWN_STATE);
        }
        catch (Exception e) {
            throw SQLError.createSQLException(e.getMessage(), YasState.UNKNOWN_STATE, (Throwable)e);
        }
    }

    public void changeSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.socket.setTcpNoDelay(true);
        this.yashanInput = new YasFilterInputStream(this.socket.getInputStream());
        this.yashanOutput = new BufferedOutputStream(this.socket.getOutputStream(), 8192);
    }

    public void send(Buffer buffer) throws IOException {
        this.yashanOutput.write(buffer.getBuffer(), 0, buffer.getPostion());
    }

    public void receive(Buffer buffer) throws IOException {
        this.yashanInput.readFully(buffer.getBuffer());
    }

    public void receive(Buffer buffer, int offset, int len) throws IOException {
        this.yashanInput.readFully(buffer.getBuffer(), offset, len);
    }

    @Override
    public void flush() throws IOException {
        this.yashanOutput.flush();
    }

    @Override
    public void close() throws IOException {
        this.yashanOutput.close();
        this.yashanInput.close();
        this.socket.close();
    }

    public void setNetworkTimeout(int milliseconds) throws IOException {
        this.socket.setSoTimeout(milliseconds);
    }

    public int getNetworkTimeout() throws IOException {
        return this.socket.getSoTimeout();
    }

    public void changeSocketToSsl() throws SQLException, IOException {
        this.initSSLSocket();
        this.changeSocket(this.sslSocketFactory.createSocket(this.socket, this.hostSpec.getHost(), this.hostSpec.getPort(), true));
    }
}

