/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.YasonArray;
import com.yashandb.protocol.YasonObject;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.CharacterSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public abstract class Yason {
    protected int size;
    protected short charset;
    protected byte[] data;
    protected Object self;
    public static final int SIZE_OFFSET = 2;
    public static final int JSON_TYPE_POS = 0;
    public static final int LENGTH_OFFSET = 4;
    private static final int JASON_STR_LEN_MASK = 127;
    public static final int MAX_STR_LEN_BYTE_SIZE = 4;
    public static final int OBJECT_TYPE = 1;
    public static final int ARRAY_TYPE = 2;
    public static final int STRING_TYPE = 3;
    public static final int NUMBER_TYPE = 4;
    public static final int BOOL_TYPE = 5;
    public static final int NULL_TYPE = 6;
    public static final Map<Character, String> escapedSymbols = new HashMap<Character, String>(){
        {
            this.put(Character.valueOf('\b'), "\\b");
            this.put(Character.valueOf('\t'), "\\t");
            this.put(Character.valueOf('\n'), "\\n");
            this.put(Character.valueOf('\f'), "\\f");
            this.put(Character.valueOf('\r'), "\\r");
            this.put(Character.valueOf('\"'), "\\\"");
            this.put(Character.valueOf('\\'), "\\\\");
        }
    };

    public Yason(byte[] data, short charset) throws SQLException {
        this.data = data;
        this.charset = charset;
        this.init();
    }

    protected abstract void init() throws SQLException;

    protected static int getStringLen(byte[] bytes, int start, int sizeLength) {
        int length = 0;
        for (int i = 0; i < sizeLength; ++i) {
            length += (bytes[start + i] & 0x7F) << i * 7;
        }
        return length;
    }

    protected static String getStringValue(byte[] data, int start, short charset) {
        int strLenByteSize = Yason.getStrLenByteSize(data, start);
        int stringSize = Yason.getStringLen(data, start, strLenByteSize);
        return "\"" + Yason.decodeJsonString(data, start + strLenByteSize, stringSize, charset) + "\"";
    }

    public static String decodeJsonString(byte[] bytes, int start, int length, short charset) {
        String str = new String(bytes, start, length, CharacterSet.getCharSet(charset));
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (escapedSymbols.containsKey(Character.valueOf(str.charAt(i)))) {
                stringBuffer.append(escapedSymbols.get(Character.valueOf(str.charAt(i))));
                continue;
            }
            stringBuffer.append(str.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static Object getInstance(int valueType, byte[] data, int start, short charset) throws SQLException {
        Object value = null;
        if (valueType == 3) {
            value = Yason.getStringValue(data, start, charset);
        } else if (valueType == 1 || valueType == 2) {
            value = Yason.getChildYason(valueType, data, start, charset);
        } else if (valueType == 4) {
            value = Yason.getNumberValue(data, start);
        } else if (valueType == 5) {
            value = data[start] == 1;
        } else if (valueType == 6) {
            value = null;
        } else {
            throw SQLError.createSQLException("protocol error, invalid json type", YasState.PROTOCOL_VIOLATION);
        }
        return value;
    }

    protected static BigDecimal getNumberValue(byte[] data, int start) {
        int length = data[start] & 0xFF;
        byte[] arr2 = Arrays.copyOfRange(data, start + 1, start + 1 + length);
        return ByteConverter.toBigDecimal(arr2, 0);
    }

    protected static Yason getChildYason(int type, byte[] data, int start, short charset) throws SQLException {
        int length = ByteConverter.int4(data, start);
        byte[] childData = Arrays.copyOfRange(data, start + 4, start + 4 + length);
        switch (type) {
            case 1: {
                return new YasonObject(childData, charset);
            }
            case 2: {
                return new YasonArray(childData, charset);
            }
        }
        throw SQLError.createSQLException("protocol error, invalid json type", YasState.PROTOCOL_VIOLATION);
    }

    protected static int getStrLenByteSize(byte[] bytes, int start) {
        for (int i = 0; i < 4; ++i) {
            if ((bytes[start + i] & 0x80) != 0) continue;
            return i + 1;
        }
        return 4;
    }

    protected void appendValueToJsonBuffer(StringBuffer jsonBuffer, Object value) {
        if (value == null) {
            jsonBuffer.append("null");
        } else if (value instanceof String) {
            jsonBuffer.append(value);
        } else if (value instanceof BigDecimal) {
            jsonBuffer.append(value);
        } else if (value instanceof Boolean) {
            jsonBuffer.append((Boolean)value != false ? "true" : "false");
        } else if (value instanceof Yason) {
            jsonBuffer.append(value);
        }
    }
}

