/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol;

import com.yashandb.protocol.Yason;
import com.yashandb.util.ByteConverter;
import java.sql.SQLException;

public class YasonArray
extends Yason {
    private static final int ARRAY_ELEMENT_LENGTH = 5;

    public YasonArray(byte[] data, short charset) throws SQLException {
        super(data, charset);
    }

    @Override
    protected void init() throws SQLException {
        byte valueType;
        int i;
        this.size = ByteConverter.int2(this.data, 0);
        Object[] array = new Object[this.size];
        int[] arrayOffsets = new int[this.size];
        block5: for (i = 0; i < this.size; ++i) {
            int typeIndex = 2 + i * 5;
            valueType = this.data[typeIndex];
            switch (valueType) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    arrayOffsets[i] = ByteConverter.int4(this.data, typeIndex + 1);
                    continue block5;
                }
                case 5: {
                    array[i] = this.data[typeIndex + 1] == 1;
                    arrayOffsets[i] = 0;
                    continue block5;
                }
                case 6: {
                    arrayOffsets[i] = 0;
                }
            }
        }
        for (i = 0; i < this.size; ++i) {
            if (arrayOffsets[i] == 0) continue;
            Object value = null;
            valueType = this.data[arrayOffsets[i]];
            if (valueType == 3) {
                value = YasonArray.getStringValue(this.data, arrayOffsets[i] + 1, this.charset);
            } else if (valueType == 1 || valueType == 2) {
                value = YasonArray.getChildYason(valueType, this.data, arrayOffsets[i] + 1, this.charset);
            } else if (valueType == 4) {
                value = YasonArray.getNumberValue(this.data, arrayOffsets[i] + 1);
            }
            array[i] = value;
        }
        this.self = array;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.self instanceof Object[]) {
            Object[] objects;
            for (Object value : objects = (Object[])this.self) {
                if (buffer.length() != 1) {
                    buffer.append(",");
                }
                this.appendValueToJsonBuffer(buffer, value);
            }
        }
        buffer.append("]");
        return buffer.toString();
    }
}

