/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasConnection;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.ClassInstanceConverter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.Calendar;

public interface Accessor {
    default public String getCurrentTypeName() {
        return this.getClass().getName();
    }

    default public String getString(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "STRING");
    }

    default public boolean getBoolean(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "BOOLEAN");
    }

    default public byte getByte(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "BYTE");
    }

    default public int getInt(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "INT");
    }

    default public BigInteger getBigInteger(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "BIGINTEGER");
    }

    default public short getShort(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "SHORT");
    }

    default public long getLong(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "LONG");
    }

    default public float getFloat(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "FLOAT");
    }

    default public double getDouble(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "DOUBLE");
    }

    default public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "BIGDECIMAL");
    }

    default public Time getTime(byte[] bytes, Calendar cal) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "TIME");
    }

    default public Date getDate(byte[] bytes, Calendar cal) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "DATE");
    }

    default public Timestamp getTimestamp(byte[] bytes, Calendar cal) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "TIMESTAMP");
    }

    default public LocalDateTime getLocalDateTime(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), LocalDateTime.class.getTypeName());
    }

    default public LocalDate getLocalDate(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), LocalDate.class.getTypeName());
    }

    default public LocalTime getLocalTime(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), LocalTime.class.getTypeName());
    }

    default public OffsetDateTime getOffsetDateTime(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), OffsetDateTime.class.getTypeName());
    }

    default public OffsetTime getOffsetTime(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), OffsetTime.class.getTypeName());
    }

    default public ZonedDateTime getZonedDateTime(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), ZonedDateTime.class.getTypeName());
    }

    default public YasClob getClob(byte[] bytes, Session session) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "CLOB");
    }

    default public YasBlob getBlob(byte[] bytes, Session session) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "BLOB");
    }

    default public RowId getRowId(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "ROWID");
    }

    default public byte[] getBytes(byte[] bytes) throws SQLException {
        return bytes;
    }

    default public ResultSet getCursor(byte[] bytes, YasConnection connection) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "CURSOR");
    }

    default public Reader getCharacterStream(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "READER");
    }

    default public InputStream getBinaryStream(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "INPUTSTREAM");
    }

    default public java.util.Date getJavaUtilDate(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "JAVA.UTIL.DATE");
    }

    default public Calendar getCalendar(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "CALENDAR");
    }

    default public Period getPeriod(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "PERIOD");
    }

    default public Duration getDuration(byte[] bytes) throws SQLException {
        throw SQLError.TransformException(this.getCurrentTypeName(), "DURATION");
    }

    default public void config(Session session) {
    }

    default public <T> T getObject(byte[] bytes, Class<T> type, YasConnection connection) throws SQLException {
        ClassInstanceConverter<T> classConverter = ClassInstanceConverter.getClassConverter(type);
        if (classConverter == null) {
            throw SQLError.TransformException(this.getCurrentTypeName(), type.getTypeName());
        }
        return classConverter.redirect(this, bytes, connection);
    }
}

