/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BigIntAccessor
implements Accessor {
    private long getValue(byte[] bytes) {
        return ByteConverter.int8(bytes, 0);
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(5);
    }

    @Override
    public String getString(byte[] bytes) {
        long value = this.getValue(bytes);
        return String.valueOf(value);
    }

    @Override
    public boolean getBoolean(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        return value != 0L;
    }

    @Override
    public byte getByte(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        if (value < -128L || value > 127L) {
            throw SQLError.OverFlowException("Long", "Byte");
        }
        return (byte)value;
    }

    @Override
    public short getShort(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        if (value < -32768L || value > 32767L) {
            throw SQLError.OverFlowException("Long", "Short");
        }
        return (short)value;
    }

    @Override
    public int getInt(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw SQLError.OverFlowException("Long", "Int");
        }
        return (int)value;
    }

    @Override
    public long getLong(byte[] bytes) throws SQLException {
        return this.getValue(bytes);
    }

    @Override
    public float getFloat(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        return value;
    }

    @Override
    public double getDouble(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        return BigDecimal.valueOf(this.getValue(bytes));
    }
}

