/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;

public class BitAccessor
implements Accessor {
    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(31);
    }

    @Override
    public String getString(byte[] bytes) throws SQLException {
        return ByteConverter.bitBytesToString(bytes);
    }

    @Override
    public boolean getBoolean(byte[] bytes) throws SQLException {
        long value = ByteConverter.bitBytesToLong(bytes);
        return value != 0L;
    }

    @Override
    public byte getByte(byte[] bytes) throws SQLException {
        long value = ByteConverter.bitBytesToLong(bytes);
        if (value < -128L || value > 127L) {
            throw SQLError.OverFlowException("Bit", "Byte");
        }
        return (byte)value;
    }

    @Override
    public short getShort(byte[] bytes) throws SQLException {
        long value = ByteConverter.bitBytesToLong(bytes);
        if (value < -32768L || value > 32767L) {
            throw SQLError.OverFlowException("Bit", "Short");
        }
        return (short)value;
    }

    @Override
    public int getInt(byte[] bytes) throws SQLException {
        long value = ByteConverter.bitBytesToLong(bytes);
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw SQLError.OverFlowException("Bit", "Int");
        }
        return (int)value;
    }

    @Override
    public long getLong(byte[] bytes) throws SQLException {
        return ByteConverter.bitBytesToLong(bytes);
    }

    @Override
    public float getFloat(byte[] bytes) throws SQLException {
        long value = ByteConverter.bitBytesToLong(bytes);
        if ((float)value < Float.MIN_VALUE || (float)value > Float.MAX_VALUE) {
            throw SQLError.OverFlowException("Bit", "Float");
        }
        return value;
    }

    @Override
    public double getDouble(byte[] bytes) throws SQLException {
        long value = ByteConverter.bitBytesToLong(bytes);
        if ((double)value < Double.MIN_VALUE || (double)value > Double.MAX_VALUE) {
            throw SQLError.OverFlowException("Bit", "Double");
        }
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        long value = ByteConverter.bitBytesToLong(bytes);
        return BigDecimal.valueOf(value);
    }
}

