/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.jdbc.YasBlob;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.protocol.accessor.LobAccessor;
import com.yashandb.util.CharacterSet;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.SQLException;

public class BlobAccessor
extends LobAccessor {
    private static final int HEX_CHAR_CNT_PER_BYTE = 2;
    private static final int BITS_PER_BYTE = 8;
    private static final int HEX_BYTE_LEN = 4;

    @Override
    public YasBlob getBlob(byte[] bytes, Session session) throws SQLException {
        YasLobProcessor lobProcessor = this.getLobProcessor(bytes, session, 30);
        YasBlob blob = new YasBlob(false);
        blob.setLobProcessor(lobProcessor);
        blob.setConnection(session.getConnection());
        return blob;
    }

    @Override
    public byte[] getBytes(byte[] bytes) throws SQLException {
        YasBlob blob = this.getBlob(bytes, this.session);
        return blob.getBytes(1L, (int)blob.length());
    }

    @Override
    public InputStream getBinaryStream(byte[] bytes) throws SQLException {
        YasBlob blob = this.getBlob(bytes, this.session);
        return blob.getBinaryStream();
    }

    private String getString(Blob blob, Charset charset) throws SQLException {
        int strBufSize = (int)blob.length() * 2;
        byte[] strBuf = new byte[strBufSize];
        byte[] lobBytes = blob.getBytes(1L, (int)blob.length());
        int index = 0;
        int pos = 0;
        byte value = 0;
        for (int i = 0; i < strBufSize; ++i) {
            index = i / 2;
            value = (byte)(pos % 8 != 0 ? lobBytes[index] & 0xF : (lobBytes[index] & 0xF0) >> 4);
            strBuf[i] = (byte)(value >= 10 ? value - 10 + 65 : value + 48);
            pos += 4;
        }
        return new String(strBuf, charset);
    }

    @Override
    public String getString(byte[] bytes) throws SQLException {
        YasBlob blob = this.getBlob(bytes, this.session);
        return this.getString(blob, CharacterSet.getCharSet(this.session.getCharset()));
    }
}

