/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.CharacterSet;
import com.yashandb.util.Utils;
import com.yashandb.util.YasTime;
import com.yashandb.util.YasTimestamp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class CharCommonAccessor
implements Accessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(CharCommonAccessor.class);
    private static final DateTimeFormatter YAS_DATE_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 1, 9, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 1, 2, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().optionalEnd().optionalStart().appendLiteral(' ').appendZoneId().optionalEnd().toFormatter();
    private static final DateTimeFormatter YAS_TIME = new DateTimeFormatterBuilder().appendValue(ChronoField.HOUR_OF_DAY, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 1, 2, SignStyle.NEVER).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 1, 2, SignStyle.NEVER).optionalStart().appendLiteral('.').appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, false).optionalEnd().optionalStart().appendLiteral(' ').appendZoneId().optionalEnd().toFormatter();
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{YAS_DATE_TIME, DateTimeFormatter.ISO_DATE_TIME, YAS_TIME, DateTimeFormatter.RFC_1123_DATE_TIME, DateTimeFormatter.ISO_DATE, DateTimeFormatter.ISO_TIME, DateTimeFormatter.ISO_LOCAL_TIME};
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss z", "HH:mm:ss"};
    private int dataType;
    private Charset charset = StandardCharsets.UTF_8;

    public CharCommonAccessor(int dataType) {
        this.dataType = dataType;
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(this.dataType);
    }

    private String getValue(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, this.charset);
    }

    @Override
    public String getString(byte[] bytes) {
        return this.getValue(bytes);
    }

    @Override
    public boolean getBoolean(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        if ("TRUE".equalsIgnoreCase(strValue) || "ON".equalsIgnoreCase(strValue) || "YES".equalsIgnoreCase(strValue) || "T".equalsIgnoreCase(strValue) || "1".equals(strValue) || "Y".equalsIgnoreCase(strValue)) {
            return true;
        }
        if ("FALSE".equalsIgnoreCase(strValue) || "OFF".equalsIgnoreCase(strValue) || "NO".equalsIgnoreCase(strValue) || "F".equalsIgnoreCase(strValue) || "0".equals(strValue) || "N".equalsIgnoreCase(strValue)) {
            return false;
        }
        YasException sqlexception = SQLError.ConvertValueException("String", strValue, "Boolean");
        LOGGER.warn(sqlexception.getMessage());
        throw sqlexception;
    }

    @Override
    public byte getByte(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return Byte.parseByte(strValue);
        }
        catch (Exception exception) {
            try {
                return Double.valueOf(strValue).byteValue();
            }
            catch (Exception formatException) {
                LOGGER.warn(exception.getMessage() + "\n" + formatException.getMessage());
                throw SQLError.ConvertValueException("String", strValue, "Byte");
            }
        }
    }

    @Override
    public short getShort(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return Short.parseShort(strValue);
        }
        catch (NumberFormatException exception) {
            try {
                return Double.valueOf(strValue).shortValue();
            }
            catch (NumberFormatException formatException) {
                LOGGER.warn(exception.getMessage() + "\n" + formatException.getMessage());
                throw SQLError.ConvertValueException("String", strValue, "Short", formatException);
            }
        }
    }

    @Override
    public int getInt(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException exception) {
            try {
                return Double.valueOf(strValue).intValue();
            }
            catch (NumberFormatException formatException) {
                LOGGER.warn(exception.getMessage() + "\n" + formatException.getMessage());
                throw SQLError.ConvertValueException("String", strValue, "Int", formatException);
            }
        }
    }

    @Override
    public long getLong(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException exception) {
            try {
                return Double.valueOf(strValue).longValue();
            }
            catch (NumberFormatException formatException) {
                LOGGER.warn(exception.getMessage() + "\n" + formatException.getMessage());
                throw SQLError.ConvertValueException("String", strValue, "Long");
            }
        }
    }

    @Override
    public float getFloat(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return Float.parseFloat(strValue);
        }
        catch (NumberFormatException exception) {
            try {
                return Double.valueOf(strValue).floatValue();
            }
            catch (NumberFormatException formatException) {
                LOGGER.warn(exception.getMessage() + "\n" + formatException.getMessage());
                throw SQLError.ConvertValueException("String", strValue, "Float", formatException);
            }
        }
    }

    @Override
    public double getDouble(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return Double.parseDouble(strValue);
        }
        catch (NumberFormatException exception) {
            try {
                return new BigDecimal(strValue).doubleValue();
            }
            catch (NumberFormatException formatException) {
                LOGGER.warn(exception.getMessage() + "\n" + formatException.getMessage());
                throw SQLError.ConvertValueException("String", strValue, "Double", formatException);
            }
        }
    }

    @Override
    public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return new BigDecimal(strValue);
        }
        catch (NumberFormatException exception) {
            LOGGER.warn(exception.getMessage());
            throw SQLError.ConvertValueException("String", strValue, "BigDecimal", exception);
        }
    }

    @Override
    public Time getTime(byte[] bytes, Calendar cal) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        LocalTime localTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                localTime = LocalTime.parse(strValue, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        if (localTime == null) {
            YasException sqlException = SQLError.ConvertValueException("String", strValue, "Time");
            LOGGER.warn(sqlException.getMessage());
            throw sqlException;
        }
        return YasTime.valueOf(localTime);
    }

    private Date getDateFromStr(String strValue) {
        try {
            return Date.valueOf(strValue);
        }
        catch (IllegalArgumentException argumentException) {
            try {
                Timestamp timestamp = Timestamp.valueOf(strValue);
                return new Date(timestamp.getTime());
            }
            catch (Exception e) {
                throw argumentException;
            }
        }
    }

    @Override
    public Date getDate(byte[] bytes, Calendar cal) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return this.getDateFromStr(strValue);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            throw SQLError.ConvertValueException("String", strValue, "Date", e);
        }
    }

    private Timestamp getTimeStampFromStr(String strValue) {
        try {
            return YasTimestamp.valueOf(strValue);
        }
        catch (IllegalArgumentException argExp) {
            if (argExp.getMessage().contains("Timestamp format must be yyyy-mm-dd hh:mm:ss")) {
                try {
                    Date date = Date.valueOf(strValue);
                    return new Timestamp(date.getTime());
                }
                catch (Exception e) {
                    throw argExp;
                }
            }
            throw argExp;
        }
    }

    @Override
    public Timestamp getTimestamp(byte[] bytes, Calendar cal) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        try {
            return this.getTimeStampFromStr(strValue);
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
            throw SQLError.ConvertValueException("String", strValue, "Timestamp", e);
        }
    }

    @Override
    public LocalDateTime getLocalDateTime(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        LocalDateTime localDateTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                localDateTime = LocalDateTime.parse(strValue, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        if (localDateTime == null) {
            throw SQLError.ConvertValueException("String", strValue, "LocalDateTime");
        }
        if (localDateTime.getYear() < 0) {
            localDateTime = localDateTime.minusYears(-1L);
        }
        return localDateTime;
    }

    @Override
    public LocalDate getLocalDate(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        LocalDate localDate = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                localDate = LocalDate.parse(strValue, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        if (localDate == null) {
            throw SQLError.ConvertValueException("String", strValue, "LocalDate");
        }
        if (localDate.getYear() < 0) {
            localDate = localDate.minusYears(-1L);
        }
        return localDate;
    }

    @Override
    public LocalTime getLocalTime(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                return LocalTime.parse(strValue, dateTimeFormatter);
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        throw SQLError.ConvertValueException("String", strValue, "LocalTime");
    }

    @Override
    public OffsetDateTime getOffsetDateTime(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        OffsetDateTime offsetDateTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                offsetDateTime = OffsetDateTime.parse(strValue, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        if (offsetDateTime == null) {
            throw SQLError.ConvertValueException("String", strValue, "OffsetDateTime");
        }
        if (offsetDateTime.getYear() < 0) {
            offsetDateTime = offsetDateTime.minusYears(-1L);
        }
        return offsetDateTime;
    }

    @Override
    public OffsetTime getOffsetTime(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                return OffsetTime.parse(strValue, dateTimeFormatter);
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        throw SQLError.ConvertValueException("String", strValue, "OffsetTime");
    }

    @Override
    public ZonedDateTime getZonedDateTime(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        ZonedDateTime zonedDateTime = null;
        for (DateTimeFormatter dateTimeFormatter : DATE_TIME_FORMATTERS) {
            try {
                zonedDateTime = ZonedDateTime.parse(strValue, dateTimeFormatter);
                break;
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        if (zonedDateTime == null) {
            throw SQLError.ConvertValueException("String", strValue, "ZonedDateTime");
        }
        if (zonedDateTime.getYear() < 0) {
            zonedDateTime = zonedDateTime.minusYears(-1L);
        }
        return zonedDateTime;
    }

    @Override
    public Reader getCharacterStream(byte[] bytes) throws SQLException {
        String strValue = this.getValue(bytes);
        return new StringReader(strValue);
    }

    @Override
    public InputStream getBinaryStream(byte[] bytes) throws SQLException {
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public java.util.Date getJavaUtilDate(byte[] bytes) throws SQLException {
        String strValue = Utils.trimString(this.getValue(bytes));
        java.util.Date utilDate = null;
        for (String dateFormat : DATE_FORMATS) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            try {
                utilDate = simpleDateFormat.parse(strValue);
            }
            catch (ParseException parseException) {
                continue;
            }
            if (utilDate != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(utilDate);
                if (calendar.isSet(0) && calendar.get(0) == 0 && calendar.get(1) != 1) {
                    calendar.set(1, calendar.get(1) - 1);
                    utilDate = calendar.getTime();
                }
            }
            return utilDate;
        }
        throw SQLError.ConvertValueException("String", strValue, "java.util.Date");
    }

    @Override
    public Calendar getCalendar(byte[] bytes) throws SQLException {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(this.getJavaUtilDate(bytes));
        return calendar;
    }

    @Override
    public void config(Session session) {
        if (this.dataType == 25 || this.dataType == 27) {
            this.charset = CharacterSet.getCharSet(session.getnCharset());
            return;
        }
        this.charset = CharacterSet.getCharSet(session.getCharset());
    }
}

