/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.jdbc.YasClob;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.LobAccessor;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

public class ClobAccessor
extends LobAccessor {
    private int dataType;

    public ClobAccessor(int dataType) {
        this.dataType = dataType;
    }

    @Override
    public YasClob getClob(byte[] bytes, Session session) throws SQLException {
        YasLobProcessor lobProcessor = this.getLobProcessor(bytes, session, this.dataType);
        YasClob clob = new YasClob(false);
        clob.setLobProcessor(lobProcessor);
        clob.setConnection(session.getConnection());
        return clob;
    }

    @Override
    public String getString(byte[] bytes) throws SQLException {
        YasClob clob = this.getClob(bytes, this.session);
        return clob.getSubString(1L, (int)clob.length());
    }

    @Override
    public Reader getCharacterStream(byte[] bytes) throws SQLException {
        YasClob clob = this.getClob(bytes, this.session);
        return clob.getCharacterStream();
    }

    @Override
    public InputStream getBinaryStream(byte[] bytes) throws SQLException {
        YasClob clob = this.getClob(bytes, this.session);
        return clob.getAsciiStream();
    }

    @Override
    public byte[] getBytes(byte[] bytes) throws SQLException {
        throw SQLError.TransformException("CLOB", "BYTES");
    }
}

