/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class DoubleAccessor
implements Accessor {
    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(11);
    }

    private double getValue(byte[] bytes) {
        return ByteConverter.float8(bytes, 0);
    }

    @Override
    public String getString(byte[] bytes) {
        double value = this.getValue(bytes);
        return String.valueOf(value);
    }

    @Override
    public byte getByte(byte[] bytes) throws SQLException {
        Double value = this.getValue(bytes);
        Double minByte = -129.0;
        Double maxByte = 128.0;
        if (value.compareTo(minByte) <= 0 || value.compareTo(maxByte) >= 0) {
            throw SQLError.OverFlowException("Double", "Byte");
        }
        return value.byteValue();
    }

    @Override
    public short getShort(byte[] bytes) throws SQLException {
        Double value = this.getValue(bytes);
        Double minValue = -32769.0;
        Double maxValue = 32768.0;
        if (value.compareTo(minValue) <= 0 || value.compareTo(maxValue) >= 0) {
            throw SQLError.OverFlowException("Double", "Short");
        }
        return value.shortValue();
    }

    @Override
    public int getInt(byte[] bytes) throws SQLException {
        Double value = this.getValue(bytes);
        Double minValue = -2.147483649E9;
        Double maxValue = 2.147483648E9;
        if (value.compareTo(minValue) <= 0 || value.compareTo(maxValue) >= 0) {
            throw SQLError.OverFlowException("Double", "Int");
        }
        return value.intValue();
    }

    @Override
    public long getLong(byte[] bytes) throws SQLException {
        Double value = this.getValue(bytes);
        Double minValue = -9.223372036854776E18;
        Double maxValue = 9.223372036854776E18;
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw SQLError.OverFlowException("Double", "Long");
        }
        return value.longValue();
    }

    @Override
    public float getFloat(byte[] bytes) throws SQLException {
        double value = this.getValue(bytes);
        return (float)value;
    }

    @Override
    public double getDouble(byte[] bytes) throws SQLException {
        return this.getValue(bytes);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        return new BigDecimal(String.valueOf(this.getValue(bytes)));
    }

    @Override
    public BigInteger getBigInteger(byte[] bytes) throws SQLException {
        return new BigInteger(this.getBigDecimal(bytes).toPlainString());
    }

    @Override
    public boolean getBoolean(byte[] bytes) throws SQLException {
        double value = this.getValue(bytes);
        return value != 0.0;
    }
}

