/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class FloatAccessor
implements Accessor {
    float getValue(byte[] bytes) {
        float value = ByteConverter.float4(bytes, 0);
        return value;
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(10);
    }

    @Override
    public String getString(byte[] bytes) {
        float value = this.getValue(bytes);
        return String.valueOf(value);
    }

    @Override
    public byte getByte(byte[] bytes) throws SQLException {
        Float value = Float.valueOf(this.getValue(bytes));
        Float minByte = Float.valueOf(-129.0f);
        Float maxByte = Float.valueOf(128.0f);
        if (value.compareTo(minByte) <= 0 || value.compareTo(maxByte) >= 0) {
            throw SQLError.OverFlowException("Float", "Byte");
        }
        return value.byteValue();
    }

    @Override
    public short getShort(byte[] bytes) throws SQLException {
        Float value = Float.valueOf(this.getValue(bytes));
        Float minValue = Float.valueOf(-32769.0f);
        Float maxValue = Float.valueOf(32768.0f);
        if (value.compareTo(minValue) <= 0 || value.compareTo(maxValue) >= 0) {
            throw SQLError.OverFlowException("Float", "Short");
        }
        return value.shortValue();
    }

    @Override
    public int getInt(byte[] bytes) throws SQLException {
        Float value = Float.valueOf(this.getValue(bytes));
        Float minValue = Float.valueOf(-2.1474836E9f);
        Float maxValue = Float.valueOf(2.1474836E9f);
        if (value.compareTo(minValue) <= 0 || value.compareTo(maxValue) >= 0) {
            throw SQLError.OverFlowException("Float", "Int");
        }
        return value.intValue();
    }

    @Override
    public long getLong(byte[] bytes) throws SQLException {
        Float value = Float.valueOf(this.getValue(bytes));
        Float minValue = Float.valueOf(-9.223372E18f);
        Float maxValue = Float.valueOf(9.223372E18f);
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw SQLError.OverFlowException("Float", "Long");
        }
        return value.longValue();
    }

    @Override
    public float getFloat(byte[] bytes) throws SQLException {
        return this.getValue(bytes);
    }

    @Override
    public double getDouble(byte[] bytes) throws SQLException {
        return this.getValue(bytes);
    }

    @Override
    public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        return new BigDecimal(String.valueOf(this.getValue(bytes)));
    }

    @Override
    public BigInteger getBigInteger(byte[] bytes) throws SQLException {
        return new BigInteger(this.getBigDecimal(bytes).toPlainString());
    }

    @Override
    public boolean getBoolean(byte[] bytes) throws SQLException {
        float value = this.getValue(bytes);
        return value != 0.0f;
    }
}

