/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IntAccessor
implements Accessor {
    int getValue(byte[] bytes) {
        return ByteConverter.int4(bytes, 0);
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(4);
    }

    @Override
    public String getString(byte[] bytes) {
        int value = this.getValue(bytes);
        return String.valueOf(value);
    }

    @Override
    public boolean getBoolean(byte[] bytes) throws SQLException {
        int value = this.getValue(bytes);
        return value != 0;
    }

    @Override
    public byte getByte(byte[] bytes) throws SQLException {
        int value = this.getValue(bytes);
        if ((long)value < -128L || (long)value > 127L) {
            throw SQLError.OverFlowException("Int", "Byte");
        }
        return (byte)value;
    }

    @Override
    public short getShort(byte[] bytes) throws SQLException {
        int value = this.getValue(bytes);
        if ((long)value < -32768L || (long)value > 32767L) {
            throw SQLError.OverFlowException("Int", "Short");
        }
        return (short)value;
    }

    @Override
    public int getInt(byte[] bytes) throws SQLException {
        return this.getValue(bytes);
    }

    @Override
    public long getLong(byte[] bytes) throws SQLException {
        return this.getValue(bytes);
    }

    @Override
    public float getFloat(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        return value;
    }

    @Override
    public double getDouble(byte[] bytes) throws SQLException {
        long value = this.getValue(bytes);
        return value;
    }

    @Override
    public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        return BigDecimal.valueOf(this.getValue(bytes));
    }
}

