/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.Session;
import com.yashandb.jdbc.YasLobProcessor;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.sql.SQLException;

public class LobAccessor
implements Accessor {
    protected Session session = null;

    protected YasLobProcessor getLobProcessor(byte[] bytes, Session session, int lobType) throws SQLException {
        int prefetchLen = ByteConverter.int2(bytes, 0) & 0xFFFF;
        int locatorLen = ByteConverter.int2(bytes, 2) & 0xFFFF;
        YasLobProcessor lobProcessor = new YasLobProcessor();
        lobProcessor.setLobType(lobType);
        lobProcessor.setSession(session);
        byte[] data = null;
        if (prefetchLen > 0) {
            data = new byte[prefetchLen];
            System.arraycopy(bytes, 4, data, 0, prefetchLen);
        }
        if (locatorLen != 0) {
            byte[] lobLocator = new byte[locatorLen];
            System.arraycopy(bytes, 4 + prefetchLen, lobLocator, 0, locatorLen);
            lobProcessor.setLobLocator(lobLocator);
            int innerLobType = lobLocator[0] & 0xFF;
            lobProcessor.setInnerLobType(innerLobType);
            if (innerLobType == 3 || innerLobType == 4) {
                lobProcessor.setLobLength(prefetchLen);
            } else {
                lobProcessor.initLobLength();
            }
            short chunkSize = session.getLobChunkSize(lobProcessor);
            lobProcessor.setChunkSize(chunkSize);
        } else {
            lobProcessor.setLobLength(prefetchLen);
        }
        int initCacheLen = Math.max(prefetchLen, lobProcessor.getStepSize());
        lobProcessor.initCacheBuffer(initCacheLen);
        if (data != null) {
            lobProcessor.setCacheData(data, 0, data.length);
            lobProcessor.setEndPos(data.length);
        }
        return lobProcessor;
    }

    @Override
    public void config(Session session) {
        this.session = session;
    }
}

