/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import java.math.BigDecimal;
import java.sql.SQLException;

public class NumberAccessor
implements Accessor {
    BigDecimal getValue(byte[] bytes) {
        return ByteConverter.toBigDecimal(bytes, 0);
    }

    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(12);
    }

    @Override
    public String getString(byte[] bytes) {
        BigDecimal bigDecimal = this.getValue(bytes);
        return bigDecimal.toPlainString();
    }

    @Override
    public boolean getBoolean(byte[] bytes) throws SQLException {
        BigDecimal bigDecimal = this.getValue(bytes);
        return bigDecimal.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public byte getByte(byte[] bytes) throws SQLException {
        BigDecimal bigDecimal = this.getValue(bytes);
        BigDecimal minByte = BigDecimal.valueOf(-129L);
        BigDecimal maxByte = BigDecimal.valueOf(128L);
        if (bigDecimal.compareTo(minByte) <= 0 || bigDecimal.compareTo(maxByte) >= 0) {
            throw SQLError.OverFlowException("Number", "Byte");
        }
        return bigDecimal.byteValue();
    }

    @Override
    public short getShort(byte[] bytes) throws SQLException {
        BigDecimal value = this.getValue(bytes);
        BigDecimal minValue = BigDecimal.valueOf(-32769L);
        BigDecimal maxValue = BigDecimal.valueOf(32768L);
        if (value.compareTo(minValue) <= 0 || value.compareTo(maxValue) >= 0) {
            throw SQLError.OverFlowException("Number", "Short");
        }
        return value.shortValue();
    }

    @Override
    public int getInt(byte[] bytes) throws SQLException {
        BigDecimal value = this.getValue(bytes);
        BigDecimal minValue = BigDecimal.valueOf(-2147483649L);
        BigDecimal maxValue = BigDecimal.valueOf(0x80000000L);
        if (value.compareTo(minValue) <= 0 || value.compareTo(maxValue) >= 0) {
            throw SQLError.OverFlowException("Number", "Int");
        }
        return value.intValue();
    }

    @Override
    public long getLong(byte[] bytes) throws SQLException {
        BigDecimal value = this.getValue(bytes);
        BigDecimal minValue = BigDecimal.valueOf(Long.MIN_VALUE);
        BigDecimal maxValue = BigDecimal.valueOf(Long.MAX_VALUE);
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw SQLError.OverFlowException("Number", "Long");
        }
        return value.longValue();
    }

    @Override
    public float getFloat(byte[] bytes) throws SQLException {
        BigDecimal value = this.getValue(bytes);
        return value.floatValue();
    }

    @Override
    public double getDouble(byte[] bytes) throws SQLException {
        BigDecimal value = this.getValue(bytes);
        return value.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(byte[] bytes) throws SQLException {
        return this.getValue(bytes);
    }
}

