/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.protocol.accessor;

import com.yashandb.core.DataType;
import com.yashandb.protocol.InternalTimeStamp;
import com.yashandb.protocol.accessor.Accessor;
import com.yashandb.util.ByteConverter;
import com.yashandb.util.YasTime;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;

public class TimeStampAccessor
implements Accessor {
    @Override
    public String getCurrentTypeName() {
        return DataType.getTypeName(16);
    }

    @Override
    public String getString(byte[] bytes) {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        Calendar cal = Calendar.getInstance();
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        cal.set(internalTimeStamp.year, internalTimeStamp.month - 1, internalTimeStamp.date, internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second);
        cal.set(14, internalTimeStamp.fraction / 1000);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        timestamp.setNanos(internalTimeStamp.fraction * 1000);
        return String.valueOf(timestamp);
    }

    @Override
    public Time getTime(byte[] bytes, Calendar cal) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        cal.set(internalTimeStamp.year, internalTimeStamp.month - 1, internalTimeStamp.date, internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second);
        cal.set(14, internalTimeStamp.fraction / 1000);
        YasTime time = new YasTime(cal.getTimeInMillis());
        time.setNanos(internalTimeStamp.fraction * 1000);
        return time;
    }

    @Override
    public java.sql.Date getDate(byte[] bytes, Calendar cal) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.set(internalTimeStamp.year, internalTimeStamp.month - 1, internalTimeStamp.date, internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second);
        cal.set(14, internalTimeStamp.fraction / 1000);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    @Override
    public Timestamp getTimestamp(byte[] bytes, Calendar cal) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        cal.set(internalTimeStamp.year, internalTimeStamp.month - 1, internalTimeStamp.date, internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second);
        cal.set(14, internalTimeStamp.fraction / 1000);
        Timestamp timestamp = new Timestamp(cal.getTimeInMillis());
        timestamp.setNanos(internalTimeStamp.fraction * 1000);
        return timestamp;
    }

    @Override
    public LocalDateTime getLocalDateTime(byte[] bytes) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        return LocalDateTime.of(internalTimeStamp.year, internalTimeStamp.month, internalTimeStamp.date, internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second, internalTimeStamp.fraction * 1000);
    }

    @Override
    public LocalDate getLocalDate(byte[] bytes) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        return LocalDate.of(internalTimeStamp.year, internalTimeStamp.month, internalTimeStamp.date);
    }

    @Override
    public LocalTime getLocalTime(byte[] bytes) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        return LocalTime.of(internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second, internalTimeStamp.fraction * 1000);
    }

    @Override
    public OffsetDateTime getOffsetDateTime(byte[] bytes) throws SQLException {
        LocalDateTime localDateTime = this.getLocalDateTime(bytes);
        return OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
    }

    @Override
    public ZonedDateTime getZonedDateTime(byte[] bytes) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        LocalDateTime localDateTime = LocalDateTime.of(internalTimeStamp.year, internalTimeStamp.month, internalTimeStamp.date, internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second, internalTimeStamp.fraction * 1000);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        return offsetDateTime.atZoneSameInstant(offsetDateTime.getOffset());
    }

    @Override
    public OffsetTime getOffsetTime(byte[] bytes) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        LocalTime localTime = LocalTime.of(internalTimeStamp.hour, internalTimeStamp.minute, internalTimeStamp.second, internalTimeStamp.fraction * 1000);
        return OffsetTime.of(localTime, ZoneOffset.UTC);
    }

    @Override
    public Date getJavaUtilDate(byte[] bytes) throws SQLException {
        Calendar calendar = this.getCalendar(bytes);
        return calendar.getTime();
    }

    @Override
    public Calendar getCalendar(byte[] bytes) throws SQLException {
        long timeFromBase = ByteConverter.int8(bytes, 0);
        InternalTimeStamp internalTimeStamp = InternalTimeStamp.transValueToTimeStamp(timeFromBase);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, internalTimeStamp.year);
        calendar.set(2, internalTimeStamp.month - 1);
        calendar.set(5, internalTimeStamp.date);
        calendar.set(11, internalTimeStamp.hour);
        calendar.set(12, internalTimeStamp.minute);
        calendar.set(13, internalTimeStamp.second);
        calendar.set(14, internalTimeStamp.fraction / 1000);
        if (internalTimeStamp.year > 0 && calendar.isSet(0)) {
            calendar.set(0, 1);
        }
        return calendar;
    }
}

