/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.CharacterSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.CharBuffer;
import java.sql.SQLException;

public class ByteConverter {
    private static final int NBASE = 10000;
    private static final int NUMERIC_DSCALE_MASK = 16383;
    private static final int SIGN_MASK = 1;
    private static final int EXP_SIGN_MASK = 2;
    private static final short NUMERIC_POS = 0;
    private static final short NUMERIC_NEG = 16384;
    private static final short NUMERIC_NAN = -16384;
    private static final int DEC_DIGITS = 4;
    private static final int[] round_powers = new int[]{0, 1000, 100, 10};
    private static final int SHORT_BYTES = 2;
    private static final int SCALE_MIN = -131;
    private static final int SCALE_MAX = 124;

    private ByteConverter() {
    }

    private static void digitToString(int idx, short[] digits, CharBuffer buffer, boolean alwaysPutIt) {
        short dig = idx >= 0 && idx < digits.length ? digits[idx] : (short)0;
        for (int p = 1; p < round_powers.length; ++p) {
            boolean putit;
            int pow = round_powers[p];
            short d1 = (short)(dig / pow);
            dig = (short)(dig - d1 * pow);
            boolean bl = putit = d1 > 0;
            if (!putit && !alwaysPutIt) continue;
            buffer.put((char)(d1 + 48));
        }
        buffer.put((char)(dig + 48));
    }

    private static String numberBytesToString(short[] digits, int scale, int weight, int sign) {
        int d;
        int i = (weight + 1) * 4;
        if (i <= 0) {
            i = 1;
        }
        CharBuffer buffer = CharBuffer.allocate(i + scale + 4 + 2);
        if (sign == 16384) {
            buffer.put('-');
        }
        if (weight < 0) {
            d = weight + 1;
            buffer.put('0');
        } else {
            for (d = 0; d <= weight; ++d) {
                ByteConverter.digitToString(d, digits, buffer, d != 0);
            }
        }
        if (scale > 0) {
            buffer.put('.');
            for (i = 0; i < scale; i += 4) {
                ByteConverter.digitToString(d, digits, buffer, true);
                ++d;
            }
        }
        int extra = (i - scale) % 4;
        return new String(buffer.array(), 0, buffer.position() - extra);
    }

    public static Number numeric(byte[] bytes) {
        return ByteConverter.numeric(bytes, 0, bytes.length);
    }

    public static Number numeric(byte[] bytes, int pos, int numBytes) {
        if (numBytes < 8) {
            throw new IllegalArgumentException("number of bytes should be at-least 8");
        }
        int len = ByteConverter.int2(bytes, pos);
        short weight = ByteConverter.int2(bytes, pos + 2);
        short sign = ByteConverter.int2(bytes, pos + 4);
        short scale = ByteConverter.int2(bytes, pos + 6);
        if (numBytes != len * 2 + 8) {
            throw new IllegalArgumentException("invalid length of bytes \"numeric\" value");
        }
        if (sign != 0 && sign != 16384 && sign != -16384) {
            throw new IllegalArgumentException("invalid sign in \"numeric\" value");
        }
        if (sign == -16384) {
            return Double.NaN;
        }
        if ((scale & 0x3FFF) != scale) {
            throw new IllegalArgumentException("invalid scale in \"numeric\" value");
        }
        short[] digits = new short[len];
        int idx = pos + 8;
        for (int i = 0; i < len; ++i) {
            short d = ByteConverter.int2(bytes, idx);
            idx += 2;
            if (d < 0 || d >= 10000) {
                throw new IllegalArgumentException("invalid digit in \"numeric\" value");
            }
            digits[i] = d;
        }
        String numString = ByteConverter.numberBytesToString(digits, scale, weight, sign);
        return new BigDecimal(numString);
    }

    public static long int8(byte[] bytes, int idx) {
        return (long)(bytes[idx] & 0xFF) + ((long)(bytes[idx + 1] & 0xFF) << 8) + ((long)(bytes[idx + 2] & 0xFF) << 16) + ((long)(bytes[idx + 3] & 0xFF) << 24) + ((long)(bytes[idx + 4] & 0xFF) << 32) + ((long)(bytes[idx + 5] & 0xFF) << 40) + ((long)(bytes[idx + 6] & 0xFF) << 48) + ((long)(bytes[idx + 7] & 0xFF) << 56);
    }

    public static int int4(byte[] bytes, int idx) {
        return (bytes[idx] & 0xFF) + ((bytes[idx + 1] & 0xFF) << 8) + ((bytes[idx + 2] & 0xFF) << 16) + ((bytes[idx + 3] & 0xFF) << 24);
    }

    public static short int2(byte[] bytes, int idx) {
        return (short)((bytes[idx] & 0xFF) + ((bytes[idx + 1] & 0xFF) << 8));
    }

    public static float float4(byte[] bytes, int idx) {
        return Float.intBitsToFloat(ByteConverter.int4(bytes, idx));
    }

    public static double float8(byte[] bytes, int idx) {
        return Double.longBitsToDouble(ByteConverter.int8(bytes, idx));
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int idx) {
        int dataLen = bytes.length - idx;
        if (dataLen <= 2) {
            if (dataLen == 1) {
                int value = bytes[idx] & 0xFF;
                return new BigDecimal(value);
            }
            int value = ByteConverter.int2(bytes, idx) & 0xFFFF;
            return new BigDecimal(value);
        }
        int numFlag = bytes[idx] & 1;
        int expFlag = bytes[idx] & 2;
        int expNumber = bytes[idx + 1] & 0xFF;
        if (expFlag == 2) {
            expNumber = -expNumber;
        }
        int signNumber = numFlag == 1 ? -1 : 1;
        byte[] bigEndianData = ByteConverter.getBigEndianBytes(bytes, idx + 2);
        BigInteger precision = new BigInteger(signNumber, bigEndianData);
        return new BigDecimal(precision, -expNumber);
    }

    public static long bitBytesToLong(byte[] bytes) {
        int len = bytes.length;
        if (len == 0) {
            return 0L;
        }
        long value = 0L;
        for (int i = 0; i < len; ++i) {
            value |= (long)(bytes[i] & 0xFF) << 8 * i;
        }
        return value;
    }

    public static String bitBytesToString(byte[] bytes) {
        int len = bytes.length;
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean oneFlag = false;
        int bit = 0;
        for (int i = len - 1; i >= 0; --i) {
            for (int j = 7; j >= 0; --j) {
                bit = bytes[i] >> j & 1;
                if (bit == 1) {
                    oneFlag = true;
                    sb.append("1");
                    continue;
                }
                if (!oneFlag) continue;
                sb.append("0");
            }
        }
        String bitStr = sb.toString();
        if (bitStr.isEmpty()) {
            return "0";
        }
        return bitStr;
    }

    private static byte[] getBigEndianBytes(byte[] data, int index) {
        int bytesCnt = 0;
        byte[] precisionData = new byte[data.length - index];
        for (int i = data.length - 1; i >= index; --i) {
            precisionData[bytesCnt++] = data[i];
        }
        return precisionData;
    }

    public static void int8(byte[] target, int idx, long value) {
        target[idx] = (byte)value;
        target[idx + 1] = (byte)(value >>> 8);
        target[idx + 2] = (byte)(value >>> 16);
        target[idx + 3] = (byte)(value >>> 24);
        target[idx + 4] = (byte)(value >>> 32);
        target[idx + 5] = (byte)(value >>> 40);
        target[idx + 6] = (byte)(value >>> 48);
        target[idx + 7] = (byte)(value >>> 56);
    }

    public static void int4(byte[] target, int idx, int value) {
        target[idx] = (byte)value;
        target[idx + 1] = (byte)(value >>> 8);
        target[idx + 2] = (byte)(value >>> 16);
        target[idx + 3] = (byte)(value >>> 24);
    }

    public static void int2(byte[] target, int idx, int value) {
        target[idx] = (byte)value;
        target[idx + 1] = (byte)(value >>> 8);
    }

    public static void bool(byte[] target, int idx, boolean value) {
        target[idx] = value ? (byte)1 : 0;
    }

    public static void float4(byte[] target, int idx, float value) {
        ByteConverter.int4(target, idx, Float.floatToRawIntBits(value));
    }

    public static void float8(byte[] target, int idx, double value) {
        ByteConverter.int8(target, idx, Double.doubleToRawLongBits(value));
    }

    public static BigDecimal adjustNumber(BigDecimal bigDecimal) {
        if (bigDecimal.precision() <= 38) {
            return bigDecimal;
        }
        int scale = bigDecimal.scale();
        int adjustScale = scale - (bigDecimal.precision() - 38);
        bigDecimal = new BigDecimal(bigDecimal.toPlainString());
        bigDecimal = bigDecimal.setScale(adjustScale, RoundingMode.HALF_UP);
        return bigDecimal;
    }

    public static int bigDecimalToBytes(byte[] target, int idx, BigDecimal bigDecimal) throws SQLException {
        int scale = -bigDecimal.scale();
        int signum = bigDecimal.signum();
        byte[] data = null;
        data = signum < 0 ? bigDecimal.negate().unscaledValue().toByteArray() : bigDecimal.unscaledValue().toByteArray();
        byte signFlag = 0;
        if (signum < 0) {
            signFlag = (byte)(signFlag | 1);
        }
        if (scale > 124 || scale < -131) {
            throw SQLError.createSQLException("Overflow Exception trying to bind " + bigDecimal, YasState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (scale < 0) {
            signFlag = (byte)(signFlag | 2);
            scale = -scale;
        }
        target[idx++] = signFlag;
        target[idx++] = (byte)scale;
        for (int i = data.length - 1; i >= 0; --i) {
            target[idx++] = data[i];
        }
        return data.length + 2;
    }

    public static String byteToString(byte[] bytes, int start, int length, short charset) {
        return new String(bytes, start, length, CharacterSet.getCharSet(charset));
    }
}

