/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;

public class CharacterSet {
    public static int getMaxCharLength(int byteLen) {
        return byteLen;
    }

    public static int convertBytesToChars(byte[] bytes, int start, int byteLen, char[] chars, int charStart, int charLen) throws SQLException {
        int copyCharLen = Math.min(byteLen, charLen);
        for (int i = 0; i < copyCharLen; ++i) {
            chars[charStart + i] = (char)bytes[start + i];
        }
        return copyCharLen;
    }

    public static Charset getCharSet(short charset) {
        CharacterType type = CharacterType.values()[charset];
        switch (type) {
            case ASCII: {
                return StandardCharsets.US_ASCII;
            }
            case UTF8: {
                return StandardCharsets.UTF_8;
            }
            case GBK: {
                return Charset.forName("GBK");
            }
            case ISO88591: {
                return StandardCharsets.ISO_8859_1;
            }
            case UTF16: {
                return StandardCharsets.UTF_16LE;
            }
            case GB18030: {
                return Charset.forName("GB18030");
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)type));
    }

    static enum CharacterType {
        ASCII,
        GBK,
        UTF8,
        ISO88591,
        UTF16,
        GB18030;

    }
}

