/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.HaPrimaryConnector;
import com.yashandb.util.HostConnector;
import com.yashandb.util.LoadBalanceConnector;
import com.yashandb.util.Messages;
import com.yashandb.util.StandAloneConnector;
import java.sql.SQLException;

public class ConnectorFactory {
    public static HostConnector generateConnector(SessionImpl session, HostSpec[] hostSpecs, String serverType) throws SQLException {
        if (hostSpecs == null) {
            return null;
        }
        if (hostSpecs.length == 1) {
            return new StandAloneConnector(session, hostSpecs[0]);
        }
        switch (serverType) {
            case "primary": {
                return new HaPrimaryConnector(session, hostSpecs);
            }
            case "loadBalance": {
                return new LoadBalanceConnector(session, hostSpecs);
            }
        }
        throw SQLError.createSQLException(Messages.get("invalid serverType: {0}", serverType), YasState.DATA_ERROR);
    }
}

