/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.DownHostsCache;
import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;

public class HaPrimaryConnector
extends HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HaPrimaryConnector.class.getName());
    private HostSpec[] hostSpecs;
    private int hostIndex = 0;

    public HaPrimaryConnector(SessionImpl session, HostSpec[] hostSpecs) {
        super(session);
        this.hostSpecs = hostSpecs;
    }

    private HostSpec nextHost() {
        if (this.hostIndex >= this.hostSpecs.length) {
            return this.hostSpecs[this.hostSpecs.length - 1];
        }
        return this.hostSpecs[this.hostIndex++];
    }

    private boolean hasNextHost() {
        return this.hostIndex < this.hostSpecs.length;
    }

    private void resetHostSpecs() {
        if (this.hostSpecs.length > 1) {
            DownHostsCache.getInstance().reorderHosts(this.hostSpecs);
        }
        this.hostIndex = 0;
    }

    private boolean isPrimaryHost() throws SQLException {
        this.session.setProtocol(this.protocol);
        this.session.setYasSocketConnection(this.yasSocketConnection);
        return this.session.isPrimaryHost();
    }

    @Override
    public void connect(String user, Properties info) throws SQLException {
        long startTime;
        SocketFactory socketFactory = SocketFactory.getDefault();
        this.resetHostSpecs();
        long currentTime = startTime = System.currentTimeMillis();
        long poolTimeout = Utils.toMillisecond(YasProperty.POOL_TIMEOUT.getInt(info));
        while (true) {
            block7: {
                HostSpec hostSpec = this.nextHost();
                LOGGER.debug("Trying to establish a connection to {}", (Object)hostSpec);
                try {
                    this.yasSocketConnection = this.tryConnect(user, info, socketFactory, hostSpec);
                    if (this.isPrimaryHost()) break;
                    this.closeStream(this.yasSocketConnection);
                }
                catch (Exception e) {
                    currentTime = System.currentTimeMillis();
                    DownHostsCache.getInstance().markDownHost(hostSpec);
                    LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {} ", hostSpec, e.getMessage(), currentTime - startTime);
                    if (this.hasNextHost() || currentTime - startTime <= poolTimeout) break block7;
                    String errMsg = Messages.get("Connect Failed, spend time: {0} ms", currentTime - startTime);
                    LOGGER.error(errMsg);
                    this.closeStream(this.yasSocketConnection);
                    throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
                }
            }
            if (!this.hasNextHost()) {
                if (currentTime - startTime > poolTimeout) {
                    String errMsg = Messages.get("Connect Failed, spend time: {0} ms", currentTime - startTime);
                    LOGGER.error(errMsg);
                    throw SQLError.createSQLException(errMsg, YasState.CONNECTION_UNABLE_TO_CONNECT);
                }
                this.resetHostSpecs();
                try {
                    Thread.sleep(Utils.toMillisecond(2));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            currentTime = System.currentTimeMillis();
        }
        this.session.setProtocol(this.protocol);
        this.session.setYasSocketConnection(this.yasSocketConnection);
    }

    @Override
    public YasLinkInfo failoverConnect(String user, Properties info) throws SQLException {
        long startTime;
        SocketFactory socketFactory = SocketFactory.getDefault();
        if (!this.hasNextHost()) {
            this.resetHostSpecs();
        }
        long currentTime = startTime = System.currentTimeMillis();
        long poolTimeout = Utils.toMillisecond(YasProperty.POOL_TIMEOUT.getInt(info));
        while (true) {
            block7: {
                HostSpec hostSpec = this.nextHost();
                LOGGER.debug("Trying to establish a connection to {}", (Object)hostSpec);
                try {
                    this.yasSocketConnection = this.tryConnect(user, info, socketFactory, hostSpec);
                    if (this.isPrimaryHost()) break;
                    this.closeStream(this.yasSocketConnection);
                    if (hostSpec == this.session.getHostSpec()) {
                        break;
                    }
                }
                catch (Exception e) {
                    currentTime = System.currentTimeMillis();
                    DownHostsCache.getInstance().markDownHost(hostSpec);
                    LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {} ", hostSpec, e.getMessage(), currentTime - startTime);
                    if (this.hasNextHost() || currentTime - startTime <= poolTimeout) break block7;
                    String errMsg = Messages.get("Connect Failed, spend time: {0} ms", currentTime - startTime);
                    LOGGER.error(errMsg);
                    this.closeStream(this.yasSocketConnection);
                    throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)e);
                }
            }
            if (!this.hasNextHost()) {
                if (currentTime - startTime > poolTimeout) {
                    String errMsg = Messages.get("Connect Failed, spend time: {0} ms", currentTime - startTime);
                    LOGGER.error(errMsg);
                    throw SQLError.createSQLException(errMsg, YasState.CONNECTION_UNABLE_TO_CONNECT);
                }
                this.resetHostSpecs();
            }
            currentTime = System.currentTimeMillis();
        }
        YasLinkInfo yasLinkInfo = new YasLinkInfo();
        yasLinkInfo.setProtocol(this.protocol);
        yasLinkInfo.setYasSocketConnection(this.yasSocketConnection);
        return yasLinkInfo;
    }
}

