/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.conf.YasProperty;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.ConnectionServerMode;
import com.yashandb.protocol.NativeProtocol;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.util.Messages;
import com.yashandb.util.Utils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;

public abstract class HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostConnector.class.getName());
    protected NativeProtocol protocol;
    protected YasSocketConnection yasSocketConnection;
    protected SessionImpl session;
    protected ConnectionServerMode serverMode = ConnectionServerMode.SHARED_MODE;

    public HostConnector(SessionImpl session) {
        this.session = session;
    }

    public abstract void connect(String var1, Properties var2) throws SQLException;

    public abstract YasLinkInfo failoverConnect(String var1, Properties var2) throws SQLException;

    protected void closeStream(YasSocketConnection newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void checkConfigurations(Properties info) throws SQLException {
        int connectTimeout = YasProperty.CONNECT_TIMEOUT.getInt(info);
        if (connectTimeout < 0) {
            throw SQLError.createSQLException(Messages.get("connectTimeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        int loginTimeout = YasProperty.LOGIN_TIMEOUT.getInt(info);
        if (loginTimeout < 0) {
            throw SQLError.createSQLException(Messages.get("loginTimeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        int socketTimeout = YasProperty.SOCKET_TIMEOUT.getInt(info);
        if (socketTimeout < 0) {
            throw SQLError.createSQLException(Messages.get("socketTimeout must be a value greater than or equal to 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        int poolTimeout = YasProperty.POOL_TIMEOUT.getInt(info);
        if (poolTimeout <= 0) {
            throw SQLError.createSQLException(Messages.get("poolTimeout must be a value greater than 0.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
        }
        this.serverMode = ConnectionServerMode.getServerMode(YasProperty.SERVER_MODE.get(info));
    }

    protected YasSocketConnection tryConnect(String user, Properties info, SocketFactory socketFactory, HostSpec hostSpec) throws SQLException, IOException {
        int connectTimeout = Utils.toMillisecond(YasProperty.CONNECT_TIMEOUT.getInt(info));
        YasSocketConnection newStream = null;
        try {
            int sendBufferSize;
            newStream = new YasSocketConnection(socketFactory, hostSpec, connectTimeout);
            int socketTimeout = Utils.toMillisecond(YasProperty.SOCKET_TIMEOUT.getInt(info));
            if (socketTimeout > 0) {
                newStream.getSocket().setSoTimeout(socketTimeout);
            }
            boolean requireTCPKeepAlive = YasProperty.TCP_KEEP_ALIVE.getBoolean(info);
            newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
            int receiveBufferSize = YasProperty.RECEIVE_BUFFER_SIZE.getInt(info);
            if (receiveBufferSize > -1) {
                if (receiveBufferSize > 0) {
                    newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
                } else {
                    LOGGER.warn("Ignore invalid value for receiveBufferSize: {}", (Object)receiveBufferSize);
                }
            }
            if ((sendBufferSize = YasProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
                if (sendBufferSize > 0) {
                    newStream.getSocket().setSendBufferSize(sendBufferSize);
                } else {
                    LOGGER.warn("Ignore invalid value for sendBufferSize: {}", (Object)sendBufferSize);
                }
            }
            LOGGER.debug("Receive Buffer Size is {}", (Object)newStream.getSocket().getReceiveBufferSize());
            LOGGER.debug("Send Buffer Size is {}", (Object)newStream.getSocket().getSendBufferSize());
            String password = YasProperty.PASSWORD.get(info);
            this.protocol = new NativeProtocol(this.session, newStream);
            this.protocol.setServerMode(this.serverMode);
            this.protocol.connect(user, password, info);
            return newStream;
        }
        catch (Exception e) {
            if (newStream != null) {
                newStream.close();
            }
            throw e;
        }
    }
}

