/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.protocol.NativeProtocol;
import com.yashandb.protocol.YasSocketConnection;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.net.SocketFactory;

public class LoadBalanceConnector
extends HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalanceConnector.class.getName());
    private HostSpec[] hostSpecs;
    private final Map<Integer, LinkedList<NativeProtocol>> connectedSockets = new TreeMap<Integer, LinkedList<NativeProtocol>>();

    public LoadBalanceConnector(SessionImpl session, HostSpec[] hostSpecs) {
        super(session);
        this.yasSocketConnection = null;
        this.hostSpecs = hostSpecs;
    }

    private int getNodeConnections() throws SQLException {
        String querySql = "select count(*) from v$session where type!='BACKGROUND'";
        int connectCnt = 0;
        Statement statement = this.session.getConnection().createStatement();
        ResultSet resultSet = statement.executeQuery(querySql);
        if (!resultSet.next()) {
            resultSet.close();
            return connectCnt;
        }
        connectCnt = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return connectCnt;
    }

    @Override
    public void connect(String user, Properties info) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        for (HostSpec hostSpec : this.hostSpecs) {
            LOGGER.debug("Trying to establish a connection to {}", (Object)hostSpec);
            YasSocketConnection trySocketConn = null;
            long startTime = System.currentTimeMillis();
            try {
                trySocketConn = this.tryConnect(user, info, socketFactory, hostSpec);
                this.session.setYasSocketConnection(trySocketConn);
                this.session.setProtocol(this.protocol);
                int nodeConnections = this.getNodeConnections();
                if (!this.connectedSockets.containsKey(nodeConnections)) {
                    LinkedList protocolList = new LinkedList();
                    this.connectedSockets.put(nodeConnections, protocolList);
                }
                this.connectedSockets.get(nodeConnections).add(this.protocol);
            }
            catch (Exception e) {
                long currentTime = System.currentTimeMillis();
                LOGGER.warn("Connect to hostSpec {} failed, Exception: {},spend time: {} ", hostSpec, e.getMessage(), currentTime - startTime);
                this.closeStream(trySocketConn);
            }
        }
        if (this.connectedSockets.isEmpty()) {
            String errMsg = Messages.get("Connect Failed.", new Object[0]);
            LOGGER.error(errMsg);
            throw SQLError.createSQLException(errMsg, YasState.CONNECTION_UNABLE_TO_CONNECT);
        }
        int nodeCount = 0;
        for (Map.Entry<Integer, LinkedList<NativeProtocol>> entry : this.connectedSockets.entrySet()) {
            LinkedList<NativeProtocol> protocolList = entry.getValue();
            for (NativeProtocol nativeProtocol : protocolList) {
                if (nodeCount == 0) {
                    this.yasSocketConnection = nativeProtocol.getSocketConnection();
                    this.protocol = nativeProtocol;
                    ++nodeCount;
                    continue;
                }
                this.closeStream(nativeProtocol.getSocketConnection());
                ++nodeCount;
            }
            protocolList.clear();
        }
        this.connectedSockets.clear();
        this.session.setProtocol(this.protocol);
        this.session.setYasSocketConnection(this.yasSocketConnection);
    }

    @Override
    public YasLinkInfo failoverConnect(String user, Properties info) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        for (HostSpec hostSpec : this.hostSpecs) {
            LOGGER.debug("Trying to establish a connection to {}", (Object)hostSpec);
            YasSocketConnection trySocketConn = null;
            long startTime = System.currentTimeMillis();
            try {
                trySocketConn = this.tryConnect(user, info, socketFactory, hostSpec);
                this.session.setYasSocketConnection(trySocketConn);
                this.session.setProtocol(this.protocol);
                int nodeConnections = this.getNodeConnections();
                if (!this.connectedSockets.containsKey(nodeConnections)) {
                    LinkedList protocolList = new LinkedList();
                    this.connectedSockets.put(nodeConnections, protocolList);
                }
                this.connectedSockets.get(nodeConnections).add(this.protocol);
            }
            catch (Exception e) {
                long currentTime = System.currentTimeMillis();
                LOGGER.warn("Connect to hostSpec {} failed, Exception: {},spend time: {} ", hostSpec, e.getMessage(), currentTime - startTime);
                this.closeStream(trySocketConn);
            }
        }
        if (this.connectedSockets.isEmpty()) {
            String errMsg = Messages.get("Connect Failed.", new Object[0]);
            LOGGER.error(errMsg);
            throw SQLError.createSQLException(errMsg, YasState.CONNECTION_UNABLE_TO_CONNECT);
        }
        int nodeCount = 0;
        for (Map.Entry<Integer, LinkedList<NativeProtocol>> entry : this.connectedSockets.entrySet()) {
            LinkedList<NativeProtocol> protocolList = entry.getValue();
            for (NativeProtocol nativeProtocol : protocolList) {
                if (nodeCount == 0) {
                    this.yasSocketConnection = nativeProtocol.getSocketConnection();
                    this.protocol = nativeProtocol;
                    ++nodeCount;
                    continue;
                }
                if (this.yasSocketConnection.getHostSpec() == this.session.getHostSpec()) {
                    this.closeStream(this.yasSocketConnection);
                    this.yasSocketConnection = nativeProtocol.getSocketConnection();
                    this.protocol = nativeProtocol;
                    ++nodeCount;
                    continue;
                }
                this.closeStream(nativeProtocol.getSocketConnection());
                ++nodeCount;
            }
            protocolList.clear();
        }
        this.connectedSockets.clear();
        YasLinkInfo yasLinkInfo = new YasLinkInfo();
        yasLinkInfo.setProtocol(this.protocol);
        yasLinkInfo.setYasSocketConnection(this.yasSocketConnection);
        return yasLinkInfo;
    }
}

