/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.SessionImpl;
import com.yashandb.conf.HostSpec;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.failover.YasLinkInfo;
import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import com.yashandb.util.HostConnector;
import com.yashandb.util.Messages;
import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.SocketFactory;

public class StandAloneConnector
extends HostConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandAloneConnector.class.getName());
    private HostSpec hostSpec;

    public StandAloneConnector(SessionImpl session, HostSpec hostSpec) {
        super(session);
        this.hostSpec = hostSpec;
    }

    @Override
    public void connect(String user, Properties info) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        long startTime = System.currentTimeMillis();
        LOGGER.debug("Trying to establish a connection to {}", (Object)this.hostSpec);
        try {
            try {
                this.yasSocketConnection = this.tryConnect(user, info, socketFactory, this.hostSpec);
            }
            catch (Exception e) {
                long currentTime = System.currentTimeMillis();
                LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {} ", this.hostSpec, e.getMessage(), currentTime - startTime);
                String errMsg = Messages.get("Connect Failed, spend time: {0} ms", currentTime - startTime);
                LOGGER.error(errMsg);
                throw e;
            }
        }
        catch (ConnectException cex) {
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("Connection to {0} refused. Check that the hostname and port are correct", this.hostSpec), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
        }
        catch (IOException ioe) {
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
        catch (SQLException se) {
            this.closeStream(this.yasSocketConnection);
            throw se;
        }
        this.session.setProtocol(this.protocol);
        this.session.setYasSocketConnection(this.yasSocketConnection);
    }

    @Override
    public YasLinkInfo failoverConnect(String user, Properties info) throws SQLException {
        SocketFactory socketFactory = SocketFactory.getDefault();
        long startTime = System.currentTimeMillis();
        LOGGER.debug("Trying to establish a connection to {}", (Object)this.hostSpec);
        try {
            try {
                this.yasSocketConnection = this.tryConnect(user, info, socketFactory, this.hostSpec);
            }
            catch (Exception e) {
                long currentTime = System.currentTimeMillis();
                LOGGER.warn("Connect Failed,then mark this hostSpec {}, Exception: {},spend time: {} ", this.hostSpec, e.getMessage(), currentTime - startTime);
                String errMsg = Messages.get("Connect Failed, spend time: {0} ms", currentTime - startTime);
                LOGGER.error(errMsg);
                throw e;
            }
        }
        catch (ConnectException cex) {
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("Connection to {0} refused. Check that the hostname and port are correct", this.hostSpec), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
        }
        catch (IOException ioe) {
            this.closeStream(this.yasSocketConnection);
            throw SQLError.createSQLException(Messages.get("The connection attempt failed.", new Object[0]), YasState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
        catch (SQLException se) {
            this.closeStream(this.yasSocketConnection);
            throw se;
        }
        YasLinkInfo yasLinkInfo = new YasLinkInfo();
        yasLinkInfo.setProtocol(this.protocol);
        yasLinkInfo.setYasSocketConnection(this.yasSocketConnection);
        return yasLinkInfo;
    }
}

