/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.jdbc.exception.YasException;
import com.yashandb.util.Messages;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamWrapper {
    private static final int MAX_MEMORY_BUFFER_BYTES = 51200;
    private static final String TEMP_FILE_PREFIX = "yashan-stream";
    private InputStream stream;
    private byte[] rawData;
    private int offset;
    private int length;

    public StreamWrapper(byte[] data, int offset, int length) {
        this.stream = null;
        this.rawData = data;
        this.offset = offset;
        this.length = length;
    }

    public StreamWrapper(InputStream stream, int length) throws YasException {
        this.readStream(stream, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStream(InputStream inputStream, int expectLen) throws YasException {
        block9: {
            try {
                ByteArrayOutputStream memoryOutputStream = new ByteArrayOutputStream();
                int memoryLength = this.copyStream(inputStream, memoryOutputStream, expectLen, 51200);
                byte[] rawData = memoryOutputStream.toByteArray();
                if (memoryLength == -1) {
                    int diskLength;
                    final File tempFile = File.createTempFile(TEMP_FILE_PREFIX, null);
                    diskOutputStream.write(rawData);
                    try (FileOutputStream diskOutputStream = new FileOutputStream(tempFile);){
                        if (expectLen != -1) {
                            expectLen -= rawData.length;
                        }
                        if ((diskLength = this.copyStream(inputStream, diskOutputStream, expectLen, Integer.MAX_VALUE - rawData.length)) == -1) {
                            throw SQLError.createSQLException(Messages.get("Stream is too large to send over the protocol.", new Object[0]), YasState.NUMERIC_CONSTANT_OUT_OF_RANGE);
                        }
                        diskOutputStream.flush();
                    }
                    this.offset = 0;
                    this.length = rawData.length + diskLength;
                    this.rawData = null;
                    this.stream = new FileInputStream(tempFile){
                        private boolean closed;
                        private int position;
                        {
                            super(x0);
                            this.closed = false;
                            this.position = 0;
                        }

                        private void checkShouldClose(int readResult) throws IOException {
                            if (readResult == -1) {
                                this.close();
                            } else {
                                this.position += readResult;
                                if (this.position >= StreamWrapper.this.length) {
                                    this.close();
                                }
                            }
                        }

                        @Override
                        public int read(byte[] b) throws IOException {
                            if (this.closed) {
                                return -1;
                            }
                            int result = super.read(b);
                            this.checkShouldClose(result);
                            return result;
                        }

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            if (this.closed) {
                                return -1;
                            }
                            int result = super.read(b, off, len);
                            this.checkShouldClose(result);
                            return result;
                        }

                        @Override
                        public void close() throws IOException {
                            if (!this.closed) {
                                super.close();
                                tempFile.delete();
                                this.closed = true;
                            }
                        }

                        protected void finalize() throws IOException {
                            this.close();
                            try {
                                super.finalize();
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Error e) {
                                throw e;
                            }
                            catch (IOException e) {
                                throw e;
                            }
                            catch (Throwable e) {
                                throw new RuntimeException("Unexpected exception from finalize", e);
                            }
                        }
                    };
                    break block9;
                }
                this.rawData = rawData;
                this.stream = null;
                this.offset = 0;
                this.length = rawData.length;
            }
            catch (IOException e) {
                throw SQLError.createSQLException(Messages.get("An I/O error occurred: " + e.getMessage(), new Object[0]), YasState.IO_ERROR, (Throwable)e);
            }
        }
    }

    public StreamWrapper(InputStream stream) throws YasException {
        this.readStream(stream, -1);
    }

    public InputStream getStream() {
        if (this.stream != null) {
            return this.stream;
        }
        return new ByteArrayInputStream(this.rawData, this.offset, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getBytes() {
        return this.rawData;
    }

    public String toString() {
        return "<stream of " + this.length + " bytes>";
    }

    private int copyStream(InputStream inputStream, OutputStream outputStream, int expectedLen, int limit) throws IOException, YasException {
        int expectStreamLen = expectedLen;
        boolean checkLen = true;
        if (expectedLen == -1) {
            checkLen = false;
            expectStreamLen = Integer.MAX_VALUE;
        }
        int totalLength = 0;
        byte[] buffer = new byte[2048];
        while (expectStreamLen > 0) {
            int readLength = inputStream.read(buffer, 0, Math.min(buffer.length, expectStreamLen));
            if (readLength == -1) {
                if (!checkLen) break;
                throw SQLError.createSQLException(expectStreamLen + " byte of Blob data can not be read", YasState.DATA_ERROR);
            }
            expectStreamLen -= readLength;
            outputStream.write(buffer, 0, readLength);
            if ((totalLength += readLength) < limit) continue;
            return -1;
        }
        return totalLength;
    }
}

