/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import com.yashandb.util.Messages;
import java.io.IOException;
import java.sql.SQLException;

public class Utils {
    public static String toHexString(byte[] data) {
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (byte element : data) {
            sb.append((char)Utils.nibbleToHex((byte)((element & 0xF0) >> 4)));
            sb.append((char)Utils.nibbleToHex((byte)(element & 0xF)));
        }
        return sb.toString();
    }

    public static byte nibbleToHex(byte nibble) {
        return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
    }

    public static StringBuilder escapeLiteral(StringBuilder sbuf, String value, boolean standardConformingStrings) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder((value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedLiteral(sbuf, value, standardConformingStrings);
        return sbuf;
    }

    private static void doAppendEscapedLiteral(Appendable sbuf, String value, boolean standardConformingStrings) throws SQLException {
        try {
            if (standardConformingStrings) {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw SQLError.createSQLException(Messages.get("Zero bytes may not occur in string parameters.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\'') {
                        sbuf.append('\'');
                    }
                    sbuf.append(ch);
                }
            } else {
                for (int i = 0; i < value.length(); ++i) {
                    char ch = value.charAt(i);
                    if (ch == '\u0000') {
                        throw SQLError.createSQLException(Messages.get("Zero bytes may not occur in string parameters.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
                    }
                    if (ch == '\\' || ch == '\'') {
                        sbuf.append(ch);
                    }
                    sbuf.append(ch);
                }
            }
        }
        catch (IOException e) {
            throw SQLError.createSQLException(Messages.get("No IOException expected from StringBuffer or StringBuilder", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    public static StringBuilder escapeIdentifier(StringBuilder sbuf, String value) throws SQLException {
        if (sbuf == null) {
            sbuf = new StringBuilder(2 + (value.length() + 10) / 10 * 11);
        }
        Utils.doAppendEscapedIdentifier(sbuf, value);
        return sbuf;
    }

    private static void doAppendEscapedIdentifier(Appendable sbuf, String value) throws SQLException {
        try {
            sbuf.append('\"');
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                if (ch == '\u0000') {
                    throw SQLError.createSQLException(Messages.get("Zero bytes may not occur in identifiers.", new Object[0]), YasState.INVALID_PARAMETER_VALUE);
                }
                if (ch == '\"') {
                    sbuf.append(ch);
                }
                sbuf.append(ch);
            }
            sbuf.append('\"');
        }
        catch (IOException e) {
            throw SQLError.createSQLException(Messages.get("No IOException expected from StringBuffer or StringBuilder", new Object[0]), YasState.UNEXPECTED_ERROR, (Throwable)e);
        }
    }

    public static String trimString(String str) {
        if (str != null) {
            return str.trim();
        }
        return str;
    }

    public static long[] toLongArray(int[] la) {
        long[] ia = new long[la.length];
        for (int i = 0; i < la.length; ++i) {
            ia[i] = la[i];
        }
        return ia;
    }

    public static int[] toIntArray(long[] la) {
        int[] ia = new int[la.length];
        for (int i = 0; i < la.length; ++i) {
            ia[i] = (int)la[i];
        }
        return ia;
    }

    public static int toMillisecond(int second) {
        int millisecond = second * 1000;
        if (second < 0) {
            return 0;
        }
        if (millisecond < 0) {
            return Integer.MAX_VALUE;
        }
        return millisecond;
    }
}

