/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.log.Logger;
import com.yashandb.log.LoggerFactory;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class YasEncrypt {
    private static final Logger LOGGER = LoggerFactory.getLogger(YasEncrypt.class.getName());
    private static final String CHARSET = "utf-8";
    private static final String CIPHER_ALGORITHM = "AES/CBC/NoPadding";
    private static final String ALGORITHM = "AES";
    private static final String IV_PARAMETER = "0000000000000000";
    private static final int ENCRY_VERSION_SHA256 = 1;
    private static final int TRANS_ENCRY_VERSION = 1;
    private static final int AES_ZERO_PADDING_LENGTH = 16;
    private static final int AES_BLOCK_SIZE = 16;

    public static String encryptSHA(String data, String salt, int encryptVersion) {
        String encryptData = null;
        switch (encryptVersion) {
            case 1: {
                encryptData = YasEncrypt.encryptSHA(data, salt, "SHA-256");
                break;
            }
            default: {
                encryptData = YasEncrypt.encryptSHA(data, salt, "SHA-256");
            }
        }
        return encryptData;
    }

    public static byte[] encryptAES(byte[] password, byte[] data, int encryptVersion) {
        byte[] encryptData = null;
        switch (encryptVersion) {
            case 1: {
                encryptData = YasEncrypt.encryptAES(password, data);
                break;
            }
            default: {
                encryptData = YasEncrypt.encryptAES(password, data);
            }
        }
        return encryptData;
    }

    public static byte[] decryptAES(byte[] password, byte[] data, int encryptVersion) {
        byte[] decryptData = null;
        switch (encryptVersion) {
            case 1: {
                decryptData = YasEncrypt.decryptAES(password, data);
                break;
            }
            default: {
                decryptData = YasEncrypt.decryptAES(password, data);
            }
        }
        return decryptData;
    }

    private static String encryptSHA(String data, String salt, String shaType) {
        MessageDigest sha = null;
        String encryptData = null;
        try {
            sha = MessageDigest.getInstance(shaType);
            byte[] byteArray = data.getBytes(CHARSET);
            sha.update(byteArray);
            if (salt != null) {
                byte[] saltByteArray = salt.getBytes(CHARSET);
                sha.update(saltByteArray);
            }
            byte[] shaBytes = sha.digest();
            StringBuffer hexValue = new StringBuffer();
            for (int i = 0; i < shaBytes.length; ++i) {
                int val = shaBytes[i] & 0xFF;
                if (val < 16) {
                    hexValue.append("0");
                }
                hexValue.append(Integer.toHexString(val));
            }
            encryptData = hexValue.toString();
            encryptData = encryptData.toUpperCase();
        }
        catch (Exception e) {
            LOGGER.error("No such SHA Algorithm or unsupport encoding.", e);
            return null;
        }
        return encryptData;
    }

    private static byte[] encryptAES(byte[] password, byte[] data) {
        if (password == null) {
            return null;
        }
        if (password.length != 16) {
            password = Arrays.copyOf(password, 16);
        }
        if (data == null) {
            return null;
        }
        SecretKeySpec secretKey = null;
        try {
            data = YasEncrypt.addZeroPadding(data, 16);
            secretKey = new SecretKeySpec(password, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(IV_PARAMETER.getBytes(CHARSET));
            cipher.init(1, (Key)secretKey, iv);
            byte[] bytes = cipher.doFinal(data);
            return bytes;
        }
        catch (Exception e) {
            LOGGER.error("Encrypt AES failed.data:" + data.length + "," + new String(data) + ",password: " + password.length + "," + new String(password) + ",secretKey: " + new String(secretKey.getEncoded()), e);
            return data;
        }
    }

    private static byte[] decryptAES(byte[] password, byte[] data) {
        if (password == null) {
            return null;
        }
        if (password.length > 16) {
            password = Arrays.copyOf(password, 16);
        }
        if (data == null) {
            return null;
        }
        if (data.length < 16) {
            data = Arrays.copyOf(data, 16);
        }
        SecretKeySpec secretKey = null;
        try {
            secretKey = new SecretKeySpec(password, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(IV_PARAMETER.getBytes(CHARSET));
            cipher.init(2, (Key)secretKey, iv);
            byte[] outData = cipher.doFinal(data);
            outData = YasEncrypt.removeZeroPadding(outData, 16);
            return outData;
        }
        catch (Exception e) {
            LOGGER.error("Decrypt AES failed.data:" + data.length + "," + new String(data) + ",password: " + password.length + "," + new String(password) + ",secretKey: " + new String(secretKey.getEncoded()), e);
            return data;
        }
    }

    private static byte[] addZeroPadding(byte[] data, int paddingLength) {
        byte[] outData = null;
        if (data == null) {
            return data;
        }
        outData = data.length % paddingLength != 0 ? Arrays.copyOf(data, data.length + paddingLength - data.length % paddingLength) : data;
        return outData;
    }

    private static byte[] removeZeroPadding(byte[] data, int paddingLength) {
        int zeroIndex;
        byte[] outData = null;
        if (data == null) {
            return data;
        }
        int len = data.length;
        for (zeroIndex = 0; zeroIndex < paddingLength - 1 && len - 1 - zeroIndex > 0 && data[len - 1 - zeroIndex] == 0; ++zeroIndex) {
        }
        outData = zeroIndex > 0 ? Arrays.copyOf(data, data.length - zeroIndex) : data;
        return outData;
    }
}

