/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

public class YasEscapeProcessor {
    private static String processEscape(String sql) {
        if (sql.length() < 2) {
            return sql;
        }
        if (sql.charAt(0) == '{') {
            if (sql.charAt(sql.length() - 1) != '}') {
                return sql;
            }
            StringBuilder processedSql = new StringBuilder();
            String tempSql = YasEscapeProcessor.removeWhiteSpace(sql).toUpperCase();
            if (tempSql.startsWith("{CALL")) {
                int startPos = tempSql.indexOf("CALL") + 4;
                int endPos = tempSql.length() - 1;
                processedSql.append("BEGIN ");
                processedSql.append(tempSql, startPos, endPos);
                processedSql.append("; END;");
                return processedSql.toString();
            }
            if (tempSql.startsWith("{?=CALL")) {
                int startPos = tempSql.indexOf("CALL") + 4;
                int endPos = tempSql.length() - 1;
                processedSql.append("BEGIN ? := ");
                processedSql.append(tempSql, startPos, endPos);
                processedSql.append("; END;");
                return processedSql.toString();
            }
            return sql;
        }
        return sql;
    }

    public static String process(String sql) {
        sql = YasEscapeProcessor.processEscape(sql);
        return sql;
    }

    private static String removeWhiteSpace(String sql) {
        if (sql == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(sql.length());
        for (int i = 0; i < sql.length(); ++i) {
            char character = sql.charAt(i);
            if (Character.isWhitespace(character)) continue;
            stringBuilder.append(character);
        }
        return stringBuilder.toString();
    }
}

