/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import com.yashandb.core.SqlKind;
import com.yashandb.exception.YasState;
import com.yashandb.jdbc.exception.SQLError;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class YasSQL {
    public static final String ROWID_ALIAS = "__Yas_JDBC_internal_ROWID__";
    static final String KEY_SELECT = "SELECT";
    static final String KEY_WITH = "WITH";
    static final String KEY_FROM = "FROM";
    static final String KEY_GROUP = "GROUP";
    static final String KEY_JOIN = "JOIN";
    static final String KEY_WHERE = "WHERE";
    static final String KEY_ORDER = "ORDER";
    static final String KEY_BEGIN = "BEGIN";
    static final String KEY_CALL = "CALL";
    static final String KEY_DELETE = "DELETE";
    static final String KEY_DECLARE = "DECLARE";
    static final String KEY_INSERT = "INSERT";
    static final String KEY_UPDATE = "UPDATE";
    static final String KEY_MERGE = "MERGE";
    static final String KEY_ALTER = "ALTER";
    static final String KEY_RETURNIN = "RETURNING";
    static final String KEY_INTO = "INTO";
    static final String KEY_DISTINCT = "DISTINCT";
    static final String KEY_LIMIT = "LIMIT";
    static final String KEY_TRUNCATE = "TRUNCATE";
    static final String KEY_SESSION = "SESSION";
    static final String KEY_CREATE = "CREATE";
    static final String KEY_DROP = "DROP";
    static final String KEY_BY = "BY";
    String originlSql;
    String rowIDSql = null;
    String updateSql = null;
    String insertSql = null;
    String deleteSql = null;
    String refreshSql = null;
    String tableName = null;
    static final int UNDEF = -1;
    int selectEndIndex = -1;
    int fromStartIndex = -1;
    int fromEndIndex = -1;
    int whereStartIndex = -1;
    int orderByStartIndex = -1;
    boolean hasRowID = false;
    boolean canRowID = false;
    boolean isSingleTable = true;
    boolean hasWith = false;
    boolean hasGroupBy = false;
    boolean hasAggr = false;
    boolean hasFrom = false;
    boolean hasWhere = false;
    boolean hasOrderBy = false;
    boolean hasJoin = false;
    boolean hasDML = false;
    boolean hasDDL = false;
    boolean hasAlterSession = false;
    boolean hasMerge = false;
    boolean hasCall = false;
    boolean hasLimit = false;
    boolean hasAnonymousBlock = false;
    boolean invalidColumn = false;
    SqlKind sqlKind = SqlKind.UNINITIALIZED;
    private int parameterCount = 0;

    public YasSQL(String sql) {
        this.originlSql = sql;
        this.parseSQL();
    }

    public boolean canUpdatable() {
        return this.canRowID;
    }

    public boolean canScrollSensitive() {
        return this.canRowID;
    }

    public boolean canScrollInSensitive() {
        return !this.hasDML && !this.hasDDL;
    }

    public String getRefreshSQL(ResultSetMetaData md) throws SQLException {
        if (this.refreshSql == null && this.tableName != null && md != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("select rowid ");
            for (int i = 0; i < md.getColumnCount(); ++i) {
                sb.append(",");
                sb.append(md.getColumnName(i + 1));
            }
            sb.append(" from ").append(this.tableName);
            sb.append(" where rowid = ?");
            this.refreshSql = sb.toString();
        }
        return this.refreshSql;
    }

    public String getUpdateSQL(ResultSetMetaData md, boolean[] updateFlags) throws SQLException {
        if (this.tableName != null && md != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("update ").append(this.tableName).append(" set ");
            int updateCount = 0;
            for (int i = 0; i < md.getColumnCount(); ++i) {
                if (!updateFlags[i]) continue;
                if (updateCount != 0) {
                    sb.append(",");
                }
                sb.append(md.getColumnName(i + 1)).append(" = ?");
                ++updateCount;
            }
            sb.append(" where rowid = ?");
            this.updateSql = sb.toString();
        }
        return this.updateSql;
    }

    public String getInsertSQL(ResultSetMetaData md, boolean[] updateFlags) throws SQLException {
        if (this.tableName != null && md != null) {
            StringBuilder sbHeader = new StringBuilder();
            StringBuilder sbValues = new StringBuilder();
            sbHeader.append("insert into ").append(this.tableName).append(" (");
            sbValues.append(") values (");
            int updateCount = 0;
            for (int i = 0; i < md.getColumnCount(); ++i) {
                if (!updateFlags[i]) continue;
                if (updateCount != 0) {
                    sbHeader.append(",");
                    sbValues.append(",");
                }
                sbHeader.append(md.getColumnName(i + 1));
                sbValues.append("?");
                ++updateCount;
            }
            sbValues.append(")");
            sbHeader.append(sbValues.toString());
            this.insertSql = sbHeader.toString();
        }
        return this.insertSql;
    }

    public String getDeleteSQL() throws SQLException {
        if (this.deleteSql == null && this.tableName != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("delete from ").append(this.tableName);
            sb.append(" where rowid = ?");
            this.deleteSql = sb.toString();
        }
        return this.deleteSql;
    }

    public String getRowIDAppendSQL() throws SQLException {
        if (this.rowIDSql == null) {
            if (this.canRowID) {
                this.hasRowID = true;
                this.rowIDSql = this.addRowID(this.originlSql);
            } else {
                this.rowIDSql = this.originlSql;
            }
        }
        return this.rowIDSql;
    }

    private boolean parseEqualWord(String sql, int beginIndex, String keyWord) {
        int endIndex = beginIndex + keyWord.length();
        if (endIndex > sql.length()) {
            return false;
        }
        boolean isEqual = sql.substring(beginIndex, endIndex).equalsIgnoreCase(keyWord);
        if (!isEqual) {
            return false;
        }
        if (sql.length() - endIndex >= 2) {
            String tail1 = sql.substring(endIndex, endIndex + 1);
            String tail2 = sql.substring(endIndex + 1, endIndex + 2);
            return tail1.equalsIgnoreCase(" ") || tail1.equalsIgnoreCase("/") && tail2.equalsIgnoreCase("*");
        }
        return true;
    }

    private int skipBlanks(int beginIndex) {
        char c;
        while (beginIndex < this.originlSql.length() && ((c = this.originlSql.charAt(beginIndex)) == ' ' || c == '\u0000' || c == '\t' || c == '\r' || c == '\n')) {
            ++beginIndex;
        }
        return beginIndex;
    }

    private int skipComment(int beginIndex) {
        int leftBoundery = 0;
        do {
            char c;
            if ((c = this.originlSql.charAt(beginIndex)) == '/' && beginIndex + 1 < this.originlSql.length() && this.originlSql.charAt(beginIndex + 1) == '*') {
                ++leftBoundery;
                beginIndex += 2;
                continue;
            }
            if (c == '*' && beginIndex + 1 < this.originlSql.length() && this.originlSql.charAt(beginIndex + 1) == '/') {
                --leftBoundery;
                beginIndex += 2;
                continue;
            }
            ++beginIndex;
        } while (beginIndex < this.originlSql.length() && leftBoundery != 0);
        return beginIndex;
    }

    private void checkParameter(char curChar, int curPos) {
        if (curChar == '?') {
            ++this.parameterCount;
            return;
        }
        if (curChar != ':') {
            return;
        }
        if (curPos == 0) {
            return;
        }
        char preChar = this.originlSql.charAt(curPos - 1);
        switch (preChar) {
            case '\n': 
            case ' ': 
            case '(': 
            case ',': 
            case '=': 
            case '|': {
                ++this.parameterCount;
                break;
            }
        }
    }

    private void parseSQL() {
        if (this.originlSql == null) {
            this.canRowID = false;
            this.hasRowID = false;
            this.sqlKind = SqlKind.UNINITIALIZED;
        } else {
            int len = this.originlSql.length();
            int i = 0;
            while (i < len) {
                int oldi = i;
                char c = this.originlSql.charAt(i);
                switch (c) {
                    case 'A': 
                    case 'a': {
                        if (this.sqlKind != SqlKind.UNINITIALIZED || this.hasDDL || !this.parseEqualWord(this.originlSql, i, KEY_ALTER)) break;
                        int nextPos = this.skipBlanks(i + KEY_ALTER.length());
                        if (this.parseEqualWord(this.originlSql, nextPos, KEY_SESSION)) {
                            this.hasAlterSession = true;
                            i = nextPos + KEY_SESSION.length();
                        } else {
                            this.hasDDL = true;
                            i += KEY_ALTER.length();
                        }
                        this.sqlKind = SqlKind.OTHER;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        if (this.sqlKind != SqlKind.UNINITIALIZED || this.hasAnonymousBlock || !this.parseEqualWord(this.originlSql, i, KEY_BEGIN)) break;
                        this.hasAnonymousBlock = true;
                        this.sqlKind = SqlKind.PLSQL_BLOCK;
                        i += KEY_BEGIN.length();
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        if (this.sqlKind == SqlKind.UNINITIALIZED && !this.hasDDL && this.parseEqualWord(this.originlSql, i, KEY_CREATE)) {
                            this.hasDDL = true;
                            this.sqlKind = SqlKind.OTHER;
                            i += KEY_CREATE.length();
                        }
                        if (this.sqlKind != SqlKind.UNINITIALIZED || this.hasCall || !this.parseEqualWord(this.originlSql, i, KEY_CALL)) break;
                        this.hasCall = true;
                        this.sqlKind = SqlKind.CALL_BLOCK;
                        i += KEY_CALL.length();
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (this.sqlKind == SqlKind.SELECT && !this.hasFrom && this.parseEqualWord(this.originlSql, i, KEY_DISTINCT)) {
                            this.invalidColumn = true;
                            i += KEY_DISTINCT.length();
                        }
                        if (this.sqlKind == SqlKind.UNINITIALIZED && !this.hasDML && this.parseEqualWord(this.originlSql, i, KEY_DELETE)) {
                            this.hasDML = true;
                            this.sqlKind = SqlKind.DELETE;
                            i += KEY_DELETE.length();
                        }
                        if (this.sqlKind == SqlKind.UNINITIALIZED && !this.hasDDL && this.parseEqualWord(this.originlSql, i, KEY_DROP)) {
                            this.hasDDL = true;
                            this.sqlKind = SqlKind.OTHER;
                            i += KEY_DROP.length();
                        }
                        if (this.sqlKind != SqlKind.UNINITIALIZED || this.hasAnonymousBlock || !this.parseEqualWord(this.originlSql, i, KEY_DECLARE)) break;
                        this.hasAnonymousBlock = true;
                        this.sqlKind = SqlKind.PLSQL_BLOCK;
                        i += KEY_DECLARE.length();
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        if (this.hasFrom || !this.parseEqualWord(this.originlSql, i, KEY_FROM)) break;
                        this.hasFrom = true;
                        this.fromStartIndex = i;
                        this.fromEndIndex = i + KEY_FROM.length();
                        i += KEY_FROM.length();
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        if (this.hasGroupBy || !this.parseEqualWord(this.originlSql, i, KEY_GROUP) || !this.parseEqualWord(this.originlSql, i = this.skipBlanks(i + KEY_GROUP.length()), KEY_BY)) break;
                        this.hasGroupBy = true;
                        i += KEY_BY.length();
                        break;
                    }
                    case 'I': 
                    case 'i': {
                        if (this.sqlKind != SqlKind.UNINITIALIZED || this.hasDML || !this.parseEqualWord(this.originlSql, i, KEY_INSERT)) break;
                        this.hasDML = true;
                        this.sqlKind = SqlKind.INSERT;
                        i += KEY_INSERT.length();
                        break;
                    }
                    case 'J': 
                    case 'j': {
                        if (this.hasJoin || !this.parseEqualWord(this.originlSql, i, KEY_JOIN)) break;
                        this.isSingleTable = false;
                        this.hasJoin = true;
                        i += KEY_JOIN.length();
                        break;
                    }
                    case 'L': 
                    case 'l': {
                        if (!this.hasFrom || !this.parseEqualWord(this.originlSql, i, KEY_LIMIT)) break;
                        this.hasLimit = true;
                        i += KEY_LIMIT.length();
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        if (this.sqlKind != SqlKind.UNINITIALIZED || this.hasMerge || !this.parseEqualWord(this.originlSql, i, KEY_MERGE)) break;
                        this.hasMerge = true;
                        this.sqlKind = SqlKind.MERGE;
                        i += KEY_MERGE.length();
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        if (this.hasOrderBy || !this.parseEqualWord(this.originlSql, i, KEY_ORDER) || !this.parseEqualWord(this.originlSql, i = this.skipBlanks(i + KEY_ORDER.length()), KEY_BY)) break;
                        this.hasOrderBy = true;
                        this.orderByStartIndex = i;
                        i += KEY_BY.length();
                        break;
                    }
                    case 'S': 
                    case 's': {
                        if (this.sqlKind != SqlKind.UNINITIALIZED || !this.parseEqualWord(this.originlSql, i, KEY_SELECT)) break;
                        this.selectEndIndex = i + KEY_SELECT.length();
                        this.sqlKind = SqlKind.SELECT;
                        i += KEY_SELECT.length();
                        break;
                    }
                    case 'T': 
                    case 't': {
                        if (this.sqlKind != SqlKind.UNINITIALIZED || this.hasDDL || !this.parseEqualWord(this.originlSql, i, KEY_TRUNCATE)) break;
                        this.hasDDL = true;
                        this.sqlKind = SqlKind.OTHER;
                        i += KEY_TRUNCATE.length();
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        if (this.sqlKind == SqlKind.UNINITIALIZED && !this.hasDML && this.parseEqualWord(this.originlSql, i, KEY_UPDATE)) {
                            this.hasDML = true;
                            this.sqlKind = SqlKind.UPDATE;
                            i += KEY_UPDATE.length();
                        }
                    }
                    case 'W': 
                    case 'w': {
                        if (!this.hasWith && this.parseEqualWord(this.originlSql, i, KEY_WITH)) {
                            this.hasWith = true;
                            i += KEY_WITH.length();
                        }
                        if (this.hasWhere || !this.parseEqualWord(this.originlSql, i, KEY_WHERE)) break;
                        this.hasWhere = true;
                        this.whereStartIndex = i;
                        i += KEY_WHERE.length();
                        break;
                    }
                    case ':': 
                    case '?': {
                        this.checkParameter(c, i);
                    }
                    case '(': {
                        if (this.sqlKind != SqlKind.SELECT || this.hasFrom) break;
                        this.invalidColumn = true;
                        break;
                    }
                    case ',': {
                        if (!this.hasFrom || this.hasLimit || this.hasWhere || this.hasGroupBy || this.hasOrderBy) break;
                        this.isSingleTable = false;
                        break;
                    }
                    case '/': {
                        if (i + 1 >= len || this.originlSql.charAt(i + 1) != '*') break;
                        i = this.skipComment(i);
                        break;
                    }
                }
                if (oldi == i) {
                    ++i;
                }
                i = this.skipBlanks(i);
            }
            if (!(this.sqlKind != SqlKind.SELECT || !this.isSingleTable || this.hasGroupBy || this.hasAggr || this.hasJoin || this.hasWith || this.hasDML || this.hasDDL || this.hasCall || this.hasMerge || this.hasAnonymousBlock || this.invalidColumn || this.hasAlterSession)) {
                this.canRowID = true;
                this.hasRowID = true;
            }
            if (this.canRowID && this.hasFrom && this.tableName == null) {
                this.tableName = this.hasWhere && this.whereStartIndex != -1 ? this.originlSql.substring(this.fromEndIndex + 1, this.whereStartIndex - 1) : (this.hasOrderBy && this.orderByStartIndex != -1 ? this.originlSql.substring(this.fromEndIndex + 1, this.orderByStartIndex - 1) : this.originlSql.substring(this.fromEndIndex + 1));
                this.tableName = this.tableName.trim();
                this.tableName = this.tableName.split(" ")[0];
            }
        }
    }

    private String addRowID(String sql) throws SQLException {
        if (this.sqlKind != SqlKind.SELECT) {
            throw SQLError.createSQLException("The sql did not have select statement", YasState.UNKNOWN_STATE);
        }
        String result = "select rowid as \"__Yas_JDBC_internal_ROWID__\"," + sql.substring(this.selectEndIndex);
        return result;
    }

    public boolean hasRowID() {
        return this.hasRowID;
    }

    public boolean canRowID() {
        return this.canRowID;
    }

    public boolean isReadOnlySQL() {
        return (this.sqlKind == SqlKind.SELECT || this.hasAlterSession) && !this.hasDML && !this.hasDDL && !this.hasCall && !this.hasAnonymousBlock;
    }

    public int getParameterCount() {
        return this.parameterCount;
    }

    private void clearState() {
        this.selectEndIndex = -1;
        this.fromEndIndex = -1;
        this.whereStartIndex = -1;
        this.orderByStartIndex = -1;
        this.hasRowID = false;
        this.canRowID = false;
        this.isSingleTable = true;
        this.hasWith = false;
        this.hasGroupBy = false;
        this.hasAggr = false;
        this.hasFrom = false;
        this.hasWhere = false;
        this.hasOrderBy = false;
        this.hasJoin = false;
        this.hasDML = false;
        this.hasDDL = false;
        this.hasAlterSession = false;
        this.hasMerge = false;
        this.hasCall = false;
        this.hasLimit = false;
        this.hasAnonymousBlock = false;
        this.invalidColumn = false;
        this.sqlKind = SqlKind.UNINITIALIZED;
    }

    public void parseSQL(String sql) {
        this.originlSql = sql;
        this.clearState();
        this.parseSQL();
    }

    public boolean isSELECT() {
        return this.sqlKind == SqlKind.SELECT;
    }

    public boolean isInsert() {
        if (this.sqlKind == SqlKind.UNINITIALIZED) {
            this.parseSQL();
        }
        return this.sqlKind == SqlKind.INSERT;
    }

    public String getSQL() {
        return this.originlSql;
    }

    public SqlKind getSqlKind() {
        if (this.sqlKind == SqlKind.UNINITIALIZED) {
            this.parseSQL();
        }
        return this.sqlKind;
    }

    public boolean hasOrderBy() {
        if (this.sqlKind == SqlKind.SELECT) {
            return this.hasOrderBy;
        }
        return false;
    }

    public boolean hasGroupBy() {
        if (this.sqlKind == SqlKind.SELECT) {
            return this.hasGroupBy;
        }
        return false;
    }

    public boolean hasAlterSession() {
        return this.hasAlterSession;
    }
}

