/*
 * Decompiled with CFR 0.152.
 */
package com.yashandb.util;

import java.sql.Time;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public class YasTime
extends Time {
    private static final long serialVersionUID = 3592492258676494276L;
    private Calendar calendar;
    private int nanos;

    public YasTime(long time) {
        this(time, null);
    }

    public YasTime(long time, Calendar calendar) {
        super(time / 1000L * 1000L);
        this.setCalendar(calendar);
        this.nanos = (int)(time % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((time / 1000L - 1L) * 1000L);
        }
    }

    @Override
    public void setTime(long time) {
        super.setTime(time / 1000L * 1000L);
        this.nanos = (int)(time % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((time / 1000L - 1L) * 1000L);
        }
    }

    @Override
    public long getTime() {
        long time = super.getTime();
        return time + (long)(this.nanos / 1000000);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.calendar == null ? 0 : this.calendar.hashCode());
        return result;
    }

    public boolean equals(YasTime at) {
        return this.getHours() == at.getHours() && this.getMinutes() == this.getMinutes() && this.getSeconds() == at.getSeconds() && this.nanos == at.nanos;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof YasTime)) {
            return false;
        }
        return this.equals((YasTime)obj);
    }

    @Override
    public Object clone() {
        YasTime clone = (YasTime)super.clone();
        if (this.getCalendar() != null) {
            clone.setCalendar((Calendar)this.getCalendar().clone());
        }
        return clone;
    }

    @Override
    public String toString() {
        String nanosString;
        int hour = super.getHours();
        int minute = super.getMinutes();
        int second = super.getSeconds();
        String zeros = "000000000";
        String hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        String minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        String secondString = second < 10 ? "0" + second : Integer.toString(second);
        if (this.nanos == 0) {
            nanosString = "000000";
        } else {
            nanosString = Integer.toString(this.nanos);
            nanosString = zeros.substring(0, 9 - nanosString.length()) + nanosString;
            nanosString = nanosString.substring(0, 6);
        }
        StringBuffer timestampBuf = new StringBuffer(20 + nanosString.length());
        timestampBuf.append(hourString);
        timestampBuf.append(":");
        timestampBuf.append(minuteString);
        timestampBuf.append(":");
        timestampBuf.append(secondString);
        timestampBuf.append(".");
        timestampBuf.append(nanosString);
        return timestampBuf.toString();
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int n) {
        if (n > 999999999 || n < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = n;
    }

    public static YasTime valueOf(LocalTime time) {
        Calendar useCal = Calendar.getInstance();
        useCal.set(11, time.getHour());
        useCal.set(12, time.getMinute());
        useCal.set(13, time.getSecond());
        long nanos = time.toNanoOfDay();
        YasTime at = new YasTime(useCal.getTimeInMillis());
        at.setNanos((int)(nanos % 1000000000L));
        return at;
    }

    public static Time valueOf(String times) {
        return YasTime.valueOf(LocalTime.parse(times, DateTimeFormatter.ISO_LOCAL_TIME));
    }

    @Override
    public LocalTime toLocalTime() {
        return LocalTime.of(this.getHours(), this.getMinutes(), this.getSeconds(), this.getNanos());
    }
}

