/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.core;

import com.kingbase8.KBProperty;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class ConnectionMangerV2 {
    public static Connection master;
    public static String passward;
    public static String dbName;
    public static ConcurrentHashMap<String, String> rates;
    public static ConcurrentHashMap<String, AtomicInteger> hostAcount;
    public static ConcurrentHashMap<String, AtomicInteger> totalAcount;
    public static AtomicInteger lastSlaveID;
    public static Stack<DispatchConnection> pool_available;
    public static Stack<DispatchConnection> pool_used;
    public static Object lock;
    public static ClusterMonitorThread ctmonitor;
    public static int Jdbcpoolsize;
    public static Thread thread_ct;
    public static DispatchConnection conn_check;
    public static boolean checkdb_init;
    public static boolean pgool_init;
    public static Connection pgpool_conn;
    public static boolean cluster_change;
    public static DispatchConnection ctmonitor_connect;
    public static String slave_online_ip;
    public static String master_online_ip;
    public static Map<String, Integer> connVersion;
    public static boolean monitorUp;
    public static Map<String, String> nodeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DispatchConnection createConnection(String url, String passward, String dbName, Properties props) throws SQLException {
        Object object;
        boolean useconn_pool = false;
        boolean usecluster_monitor = true;
        if (useconn_pool) {
            Object conn;
            Jdbcpoolsize = KBProperty.CONNECT_POOLSIZE.getIntNoCheck(props);
            LOGGER.log(Level.SEVERE, "createConnection:::current jdbcpool.size: {0})", pool_used.size() + pool_available.size());
            int currentsize = 0;
            while (true) {
                Object nodes;
                object = lock;
                synchronized (object) {
                    currentsize = pool_available.size() + pool_used.size();
                }
                if (currentsize >= Jdbcpoolsize) break;
                if (usecluster_monitor && ctmonitor == null) {
                    object = lock;
                    synchronized (object) {
                        if (ctmonitor == null) {
                            String[] stringArray = nodes = KBProperty.NODE_LIST.get(props) == null ? new String[]{} : KBProperty.NODE_LIST.get(props).split(",");
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String node = stringArray[i];
                                connVersion.put(node, 0);
                            }
                            ConnectionMangerV2.initNodeMap(props);
                            ctmonitor = new ClusterMonitorThread(props);
                            thread_ct = new Thread((Runnable)ctmonitor, "Kingbase8 JDBC driver cluster monitor");
                            thread_ct.setDaemon(true);
                            thread_ct.start();
                        }
                    }
                }
                while (!monitorUp) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                conn = new DispatchConnection(null, passward, dbName, props);
                if (rates.get(((DispatchConnection)conn).url) == null) {
                    rates.put(((DispatchConnection)conn).url, KBProperty.HOSTLOADRATE.get(props));
                    hostAcount.put(((DispatchConnection)conn).url, new AtomicInteger(0));
                    totalAcount.put(((DispatchConnection)conn).url, new AtomicInteger(0));
                }
                nodes = lock;
                synchronized (nodes) {
                    pool_available.push((DispatchConnection)conn);
                }
                LOGGER.log(Level.SEVERE, "createConnection:::jdbc pool initialize: {0})", pool_used.size() + pool_available.size());
            }
            conn = lock;
            synchronized (conn) {
                if (!pool_available.isEmpty()) {
                    DispatchConnection conn2 = pool_available.pop();
                    pool_used.push(conn2);
                    LOGGER.log(Level.SEVERE, "createConnection:::jdbc pool return idle connect: {0})", pool_available.size());
                    return conn2;
                }
            }
        }
        if (usecluster_monitor && ctmonitor == null) {
            Object currentsize = lock;
            synchronized (currentsize) {
                if (ctmonitor == null) {
                    String[] nodes;
                    for (String node : nodes = KBProperty.NODE_LIST.get(props) == null ? new String[]{} : KBProperty.NODE_LIST.get(props).split(",")) {
                        connVersion.put(node, 0);
                    }
                    ConnectionMangerV2.initNodeMap(props);
                    ctmonitor = new ClusterMonitorThread(props);
                    thread_ct = new Thread((Runnable)ctmonitor, "Kingbase8 JDBC driver cluster monitor");
                    thread_ct.setDaemon(true);
                    thread_ct.start();
                }
            }
        }
        while (!monitorUp) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        DispatchConnection conn = new DispatchConnection(null, passward, dbName, props);
        if (rates.get(conn.url) == null) {
            rates.put(conn.url, KBProperty.HOSTLOADRATE.get(props));
            hostAcount.put(conn.url, new AtomicInteger(0));
            totalAcount.put(conn.url, new AtomicInteger(0));
        }
        if (useconn_pool) {
            object = lock;
            synchronized (object) {
                pool_used.push(conn);
                LOGGER.log(Level.SEVERE, "createConnection:::jdbc pool extend pool size: {0})", pool_used.size() + pool_available.size());
            }
        }
        return conn;
    }

    public static void initNodeMap(Properties props) throws KSQLException {
        String[] slavePorts;
        String nodeList = KBProperty.NODE_LIST.get(props);
        if (nodeList == null || nodeList.isEmpty()) {
            throw new KSQLException("The nodeList cannot be empty.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        String[] nodes = nodeList.split(",");
        nodeMap.put(KBProperty.KB_HOST.get(props) + ":" + KBProperty.KB_PORT.get(props), nodes[0]);
        String slaveList = KBProperty.SLAVE_ADD.get(props);
        String slavePortList = KBProperty.SLAVE_PORT.get(props);
        if (slaveList == null || slaveList.isEmpty() || slavePortList == null || slavePortList.isEmpty()) {
            return;
        }
        String[] slaves = slaveList.split(",");
        if (slaves.length != (slavePorts = slavePortList.split(",")).length) {
            throw new KSQLException("The number of standby machines does not match the number of ports.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        if (slaves.length != nodes.length - 1) {
            throw new KSQLException("The number of hosts does not match the number of nodes.", KSQLState.INVALID_PARAMETER_VALUE);
        }
        for (int i = 1; i < nodes.length; ++i) {
            nodeMap.put(slaves[i - 1] + ":" + slavePorts[i - 1], nodes[i]);
        }
    }

    public static String getMasterIP() {
        return master_online_ip;
    }

    static {
        rates = new ConcurrentHashMap();
        hostAcount = new ConcurrentHashMap();
        totalAcount = new ConcurrentHashMap();
        lastSlaveID = new AtomicInteger(0);
        pool_available = new Stack();
        pool_used = new Stack();
        lock = new Object();
        ctmonitor = null;
        Jdbcpoolsize = 50;
        thread_ct = null;
        conn_check = null;
        checkdb_init = false;
        pgool_init = false;
        cluster_change = false;
        ctmonitor_connect = null;
        slave_online_ip = new String("");
        master_online_ip = new String("");
        connVersion = new HashMap<String, Integer>();
        nodeMap = new HashMap<String, String>();
    }

    public static class ClusterMonitorThread
    implements Runnable {
        private Properties props;

        ClusterMonitorThread(Properties props) {
            this.setprops(props);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            try {
                while (true) {
                    int monitor_interval = KBProperty.MONITORINTERVAL.getIntNoCheck(this.props);
                    try {
                        if (ctmonitor_connect == null) {
                            this.props.setProperty("isMonitor", "true");
                            this.props.setProperty("socketTimeout", "3");
                            for (String ip : connVersion.keySet()) {
                                connVersion.put(ip, connVersion.get(ip) + 1);
                            }
                            ctmonitor_connect = new DispatchConnection(null, passward, dbName, this.props);
                        }
                        master_online_ip = nodeMap.get(((KbConnection)ctmonitor_connect.getMainConn()).getHostIp() + ":" + ((KbConnection)ctmonitor_connect.getMainConn()).getHostPort());
                        String sql = String.format("select application_name from pg_stat_replication", new Object[0]);
                        Statement stcheck = ctmonitor_connect.getMainConn().createStatement();
                        ResultSet rs = stcheck.executeQuery(sql);
                        String sip = "";
                        while (rs.next()) {
                            sip = sip + rs.getString(1);
                            sip = sip + ",";
                        }
                        rs.close();
                        slave_online_ip = sip;
                        if (slave_online_ip.isEmpty()) {
                            Boolean bmaster = false;
                            sql = String.format("select * from pg_is_in_recovery()", new Object[0]);
                            rs = stcheck.executeQuery(sql);
                            if (rs.next()) {
                                bmaster = !rs.getBoolean(1);
                            }
                            rs.close();
                            if (!bmaster.booleanValue()) {
                                try {
                                    master_online_ip = "";
                                    ctmonitor_connect.CloseConnectCluter();
                                    ctmonitor_connect = null;
                                }
                                catch (SQLException e1) {
                                    ctmonitor_connect = null;
                                }
                            }
                        }
                        LOGGER.log(Level.SEVERE, "ClusterMonitorThread master online: {0}, current slave online: {1}", master_online_ip, slave_online_ip);
                        stcheck.close();
                    }
                    catch (SQLException e) {
                        LOGGER.log(Level.SEVERE, "ClusterMonitorThread check slave info Exception: {0}", e.getMessage());
                        LOGGER.log(Level.SEVERE, e);
                        slave_online_ip = "";
                        master_online_ip = "";
                        if (ctmonitor_connect != null) {
                            try {
                                ctmonitor_connect.CloseConnectCluter();
                                ctmonitor_connect = null;
                            }
                            catch (SQLException e1) {
                                ctmonitor_connect = null;
                            }
                        }
                    }
                    finally {
                        monitorUp = true;
                    }
                    Thread.sleep(monitor_interval * 1000);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, "ClusterMonitorThread check slave info InterruptedException: {0}", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
                pgool_init = false;
                pgpool_conn = null;
                return;
            }
        }

        public void setprops(Properties defaults) {
            this.props = new Properties(defaults);
        }
    }
}

