/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.dispatcher.executor;

import com.kingbase8.KBProperty;
import com.kingbase8.core.ParameterList;
import com.kingbase8.dispatcher.core.ConnectionMangerV2;
import com.kingbase8.dispatcher.entity.DispatchConnection;
import com.kingbase8.dispatcher.entity.FakeConnection;
import com.kingbase8.dispatcher.executor.command.StatementCreateCommand;
import com.kingbase8.dispatcher.parser.statement.Statement;
import com.kingbase8.dispatcher.sqlParser.sql.SqlParser;
import com.kingbase8.jdbc.KbCallableStatement;
import com.kingbase8.jdbc.KbConnection;
import com.kingbase8.jdbc.KbPreparedStatement;
import com.kingbase8.jdbc.KbStatement;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.LOGGER;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public abstract class DispatchAbstractStatement {
    public static final int DISPATCH_TYPE_MAIN = 0;
    public static final int DISPATCH_TYPE_SLAVE = 1;
    public static final int DISPATCH_TYPE_ALL = 2;
    public static final int DISPATCH_TYPE_ALL_CURRENT = 3;
    protected DispatchConnection dispatchConnection;
    protected java.sql.Statement mainStatement;
    protected java.sql.Statement slaveStatement;
    protected boolean poolable;
    StatementCreateCommand<? extends java.sql.Statement> createCommand;
    String strategyValue;
    String sqlType = "NULL";
    private boolean slaveConnectionDisable;
    protected volatile int dispatchType;
    protected volatile int currentDispatchType;
    ParameterList record_main_prepl = null;
    ParameterList record_slave_prepl = null;
    java.sql.Statement record_main_stmt = null;
    java.sql.Statement record_slave_stmt = null;
    protected static final String TYPE_INTRANSACTION = "in transaction";
    private static final String TYPE_UPDATE_IN_INTRANSACTION = "update in transaction";
    private static final String TYPE_SELECT = "select";
    private static final String TYPE_SET = "set or reset";
    protected static final String TYPE_UPDATE = "insert or delete or update";
    private String slavekey = "";
    Statement sqlStmt = null;

    public void cleanStatement() throws SQLException {
        if (this.mainStatement != null) {
            this.record_main_stmt = this.mainStatement;
            this.mainStatement.close();
            this.mainStatement = null;
        }
        if (this.slaveStatement != null) {
            this.record_slave_stmt = this.slaveStatement;
            this.slaveStatement.close();
            this.slaveStatement = null;
        }
    }

    public synchronized java.sql.Statement getMainStatement() throws SQLException {
        if (this.mainStatement == null) {
            Connection conn = this.dispatchConnection.getMainConn();
            if (conn instanceof FakeConnection) {
                throw new KSQLException("Master connection is FakeConnection.", KSQLState.CONNECTION_DOES_NOT_EXIST);
            }
            this.mainStatement = this.createCommand.getStatement(conn);
        }
        return this.mainStatement;
    }

    public List<java.sql.Statement> getAllStatement() throws SQLException {
        ArrayList<java.sql.Statement> result = new ArrayList<java.sql.Statement>();
        result.add(this.getMainStatement());
        int slaveCount = this.dispatchConnection.slaveCount;
        java.sql.Statement st = this.slaveStatement;
        while (slaveCount-- > 0) {
            if (this.slaveStatement != null) {
                this.slaveStatement = null;
            }
            this.slaveStatement = this.getSlaveStatement();
            if (this.slaveStatement == null) continue;
            result.add(this.slaveStatement);
        }
        if (st != null) {
            this.resetStmtInfo(this.slaveStatement, st);
        }
        return result;
    }

    public synchronized java.sql.Statement getSlaveStatement() throws SQLException {
        if (this.slaveStatement == null) {
            Connection conn = null;
            for (int j = 0; j < this.dispatchConnection.slaveCount; ++j) {
                String key;
                this.slavekey = key = DispatchConnection.SLAVE + ConnectionMangerV2.lastSlaveID.getAndIncrement() % this.dispatchConnection.slaveCount;
                conn = this.dispatchConnection.getSlaveConnection(key);
                if (conn instanceof FakeConnection) {
                    int masterport;
                    String node = ConnectionMangerV2.nodeMap.get(((FakeConnection)conn).getSlaveIP() + ":" + ((FakeConnection)conn).getSlavePort());
                    String dmsg = String.format("getSlaveStatement: slave_online_ip is : {%s}  FakeConnection is: {%s}", ConnectionMangerV2.slave_online_ip, node);
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, dmsg, new Object[0]);
                    }
                    String sip = ConnectionMangerV2.slave_online_ip;
                    String[] sip_arr = sip.split(",");
                    int i = 0;
                    for (i = 0; i < sip_arr.length; ++i) {
                        if (!sip_arr[i].equalsIgnoreCase(node)) continue;
                        ((FakeConnection)conn).setSlaveStatus(true);
                        String debugmsg = String.format("getSlaveStatement: need recreate slave connection for : {%s}", node);
                        if (!LOGGER.isLoggable(Level.INFO)) break;
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        break;
                    }
                    if (((FakeConnection)conn).getSlaveStatus()) continue;
                    String masterip = "";
                    String debugmsg = "";
                    Connection mastercon = this.dispatchConnection.getMainConn();
                    if (mastercon instanceof KbConnection) {
                        masterip = ((KbConnection)mastercon).getHostIp();
                        masterport = ((KbConnection)mastercon).getHostPort();
                        debugmsg = String.format("getSlaveStatement: offline slave connection for : {%s} and Master ip is :{%s}", node, ConnectionMangerV2.nodeMap.get(masterip + ":" + masterport));
                    } else if (mastercon instanceof FakeConnection) {
                        masterip = ((FakeConnection)mastercon).getSlaveIP();
                        masterport = ((FakeConnection)mastercon).getSlavePort();
                        debugmsg = String.format("getSlaveStatement: offline slave connection for : {%s} and FakeMaster ip is :{%s}", node, ConnectionMangerV2.nodeMap.get(masterip + ":" + masterport));
                    }
                    if (!LOGGER.isLoggable(Level.INFO)) continue;
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    continue;
                }
                String node = ConnectionMangerV2.nodeMap.get(((KbConnection)conn).getHostIp() + ":" + ((KbConnection)conn).getHostPort());
                if (ConnectionMangerV2.slave_online_ip.contains(node)) break;
                LOGGER.log(Level.INFO, node + " can connect, but is not included in slave_online_ip.", new Object[0]);
                conn = null;
            }
            if (conn == null || conn instanceof FakeConnection) {
                return null;
            }
            this.slaveStatement = this.createCommand.getStatement(conn);
        }
        return this.slaveStatement;
    }

    public List<java.sql.Statement> getAllCurrentStatement() throws SQLException {
        ArrayList<java.sql.Statement> result = new ArrayList<java.sql.Statement>();
        if (this.mainStatement != null) {
            result.add(this.mainStatement);
        }
        if (this.slaveStatement != null) {
            result.add(this.slaveStatement);
        }
        return result;
    }

    protected int getExecuteType(String sql) {
        int result;
        block11: {
            result = 0;
            if (this.strategyValue == null) {
                this.strategyValue = KBProperty.TRANSACTIONDISPATCHSTRATEGY.get(this.dispatchConnection.m_props);
            }
            SqlParser oscarParser = new SqlParser(sql, this.strategyValue);
            try {
                this.sqlStmt = oscarParser.doParse(this.dispatchConnection);
                this.strategyValue = oscarParser.getStrategyValue();
                this.sqlType = "NULL";
                int type = this.sqlStmt.getSQLType();
                switch (type) {
                    case 0: {
                        result = 0;
                        this.sqlType = TYPE_INTRANSACTION;
                        this.add();
                        break;
                    }
                    case 1: {
                        result = 0;
                        this.sqlType = TYPE_UPDATE_IN_INTRANSACTION;
                        this.add();
                        break;
                    }
                    case 2: {
                        result = 1;
                        result = this.changeExecuteType();
                        this.sqlType = TYPE_SELECT;
                        break;
                    }
                    case 5: {
                        result = 2;
                        this.sqlType = TYPE_SET;
                        this.add();
                        break;
                    }
                    default: {
                        result = 0;
                        this.sqlType = TYPE_UPDATE;
                        this.add();
                    }
                }
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, " getExecuteType (session={0} sql={1} sqlType={2})", this.dispatchConnection, sql, this.sqlType);
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block11;
                LOGGER.log(Level.SEVERE, " prase (Exception={0})", e.getMessage());
                LOGGER.log(Level.SEVERE, e);
            }
        }
        if (this.dispatchConnection.slaveCount == 0) {
            result = 0;
        }
        return result;
    }

    protected int getExecuteType() {
        return this.dispatchType;
    }

    protected ParameterList recordParamlist(java.sql.Statement st) {
        ParameterList prepl = null;
        if (st instanceof KbPreparedStatement) {
            prepl = ((KbPreparedStatement)st).getPreParmlist();
        } else if (st instanceof KbCallableStatement) {
            prepl = ((KbCallableStatement)st).getPreParmlist();
        }
        return prepl;
    }

    protected void resetParamlist(java.sql.Statement st, ParameterList prepl) {
        if (st instanceof KbPreparedStatement) {
            ((KbPreparedStatement)st).setPreParmlist(prepl);
        } else if (st instanceof KbCallableStatement) {
            ((KbCallableStatement)st).setPreParmlist(prepl);
        }
    }

    protected void resetStmtInfo(java.sql.Statement current_st, java.sql.Statement record_st) {
        if (current_st instanceof KbStatement) {
            ((KbStatement)current_st).copyStatementInfo((KbStatement)record_st);
        }
        if (current_st instanceof KbPreparedStatement) {
            ((KbPreparedStatement)current_st).copyPreparedStatementInfo((KbPreparedStatement)record_st);
        }
        if (current_st instanceof KbCallableStatement) {
            ((KbCallableStatement)current_st).copyCallableStatementInfo((KbCallableStatement)record_st);
        }
    }

    private synchronized void reconnect() throws SQLException {
        if (this.dispatchConnection.isClosed()) {
            LOGGER.log(Level.INFO, "CloseConnectCluter and ReConnectCluter", new Object[0]);
            this.dispatchConnection.CloseConnectCluter();
            this.dispatchConnection.ReConnectCluter();
            this.dispatchConnection.CheckClusteInfo(this.dispatchConnection.m_props);
            this.dispatchConnection.resetConnInfo();
        }
    }

    protected <R> R executeTemplet(ExecuteCommand<R> command, int dispatchType) throws SQLException {
        String debugmsg;
        this.currentDispatchType = dispatchType;
        R r = null;
        StringBuilder sql = null;
        java.sql.Statement st = null;
        if (LOGGER.isLoggable(Level.INFO)) {
            sql = new StringBuilder();
            sql.append("Main session: ").append(this.dispatchConnection).append(", ").append(DispatchAbstractStatement.class).append(", executeTemplet()" + command.getFunctionName() + " ,dispatchType :").append(dispatchType + " ");
            debugmsg = String.format("executeTemplet (Main session={%s} command={%s} dispatchType={%s})", this.dispatchConnection, command.getFunctionName(), dispatchType);
            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
        }
        if (this.dispatchConnection.getLastSqlType() != null && this.dispatchConnection.getLastSqlType().equals(TYPE_INTRANSACTION)) {
            this.sqlType = TYPE_INTRANSACTION;
        }
        AtomicLong t1 = new AtomicLong(System.currentTimeMillis());
        block12 : switch (dispatchType) {
            case 0: {
                try {
                    st = this.getMainStatement();
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    r = command.execute(st);
                    if (this.dispatchConnection.getAutoCommit() || !command.isExecuteFunction() || !this.sqlType.equalsIgnoreCase(TYPE_UPDATE)) break;
                    this.dispatchConnection.setHasUpdate(true);
                    this.sqlType = TYPE_INTRANSACTION;
                    if (!LOGGER.isLoggable(Level.INFO)) break;
                    LOGGER.log(Level.INFO, "Enter transactional state from sql[" + this.sqlStmt.getCommandText() + "].", new Object[0]);
                    break;
                }
                catch (SQLException e) {
                    if (this.expectionHandler(e, null, null) && (this.sqlType.equals("NULL") || !this.sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                        int loop;
                        if (LOGGER.isLoggable(Level.INFO) && st != null) {
                            LOGGER.log(Level.INFO, "Error Main statement url:" + ((KbConnection)st.getConnection()).getURL() + "\n", new Object[0]);
                        }
                        if ((loop = this.dispatchConnection.retrytimes) <= 0) {
                            this.dispatchConnection.close();
                            throw e;
                        }
                        int interval = this.dispatchConnection.retryinterval;
                        while (loop-- > 0) {
                            try {
                                if (this.dispatchConnection.isClosed()) {
                                    this.reconnect();
                                    if (!this.dispatchConnection.CheckIsMaster(this.dispatchConnection.getMainConn())) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n", new Object[0]);
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                }
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_main_stmt != null) {
                                    this.resetStmtInfo(st, this.record_main_stmt);
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to master statement, send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                r = command.execute(st);
                                if (!this.dispatchConnection.getAutoCommit() && command.isExecuteFunction() && this.sqlType.equalsIgnoreCase(TYPE_UPDATE)) {
                                    this.dispatchConnection.setHasUpdate(true);
                                    this.sqlType = TYPE_INTRANSACTION;
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Enter transactional state from sql[" + this.sqlStmt.getCommandText() + "].", new Object[0]);
                                    }
                                }
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                                break block12;
                            }
                            catch (SQLException ei) {
                                if (!this.expectionHandler(ei, null, null)) {
                                    throw ei;
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to master SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                if (loop > 0) {
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + " Exception \n", new Object[0]);
                                    }
                                    try {
                                        Thread.sleep(interval * 1000);
                                    }
                                    catch (InterruptedException e1) {
                                        LOGGER.log(Level.SEVERE, e1);
                                    }
                                    continue;
                                }
                                debugmsg = String.format("Send to master retry maximnum times still SQLException: %s", ei.getMessage());
                                if (LOGGER.isLoggable(Level.SEVERE)) {
                                    LOGGER.log(Level.SEVERE, debugmsg, new Object[0]);
                                    LOGGER.log(Level.SEVERE, ei);
                                }
                                this.dispatchConnection.close();
                                throw new SQLException(debugmsg, ei.getSQLState());
                            }
                            catch (InterruptedException e1) {
                                LOGGER.log(Level.SEVERE, e1);
                            }
                        }
                        break;
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        debugmsg = String.format("failare execute in Master Exception: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    throw e;
                }
            }
            case 1: {
                try {
                    st = this.getSlaveStatement();
                    if (st == null) {
                        this.currentDispatchType = 0;
                        this.slaveStatement = st = this.getMainStatement();
                        this.record_slave_stmt = st;
                        if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                            debugmsg = String.format("getSlaveStatement error ,send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        r = command.execute(st);
                        break;
                    }
                    if (command.isExecuteFunction() && this.sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) {
                        this.currentDispatchType = 0;
                        this.dispatchType = 0;
                        this.cleanStatement();
                        st = this.getMainStatement();
                        if (this.record_slave_stmt != null) {
                            this.resetStmtInfo(st, this.record_slave_stmt);
                        }
                        if (LOGGER.isLoggable(Level.INFO)) {
                            debugmsg = String.format("change this to master db: (master={%s}).Send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", ((KbConnection)st.getConnection()).getHostIp(), this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        r = command.execute(st);
                        break;
                    }
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to slave session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    r = command.execute(st);
                    break;
                }
                catch (SQLException e) {
                    if (command.getFunctionName().contains("executeBatch")) {
                        throw e;
                    }
                    int loop = this.dispatchConnection.retrytimes;
                    if (loop == 0 && this.currentDispatchType == 1 && !this.expectionHandler(e, null, null)) {
                        ++loop;
                    }
                    if (loop <= 0) {
                        this.dispatchConnection.close();
                        throw e;
                    }
                    int interval = this.dispatchConnection.retryinterval;
                    SQLException excep = e;
                    while (loop-- > 0) {
                        try {
                            if (this.currentDispatchType == 1) {
                                if (this.expectionHandler(excep, null, null)) {
                                    this.dispatchConnection.setSlaveToFakebyKey(this.slavekey);
                                    this.cleanStatement();
                                    st = this.getSlaveStatement();
                                    if (st != null) {
                                        this.resetStmtInfo(st, this.record_slave_stmt);
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            debugmsg = String.format("Send to slave exception: (%s) ,change this to anoter slave db: (slave={%s}).Send to slave session: (session={%s} url={%s} st={%s} sqlType={%s})", e.getMessage(), ((KbConnection)st.getConnection()).getHostIp(), this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                        }
                                        r = command.execute(st);
                                        break block12;
                                    }
                                }
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_slave_stmt != null) {
                                    this.resetStmtInfo(st, this.record_slave_stmt);
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to slave exception: (%s) ,change this to master db: (master={%s}).Send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", e.getMessage(), ((KbConnection)st.getConnection()).getHostIp() + ":" + ((KbConnection)st.getConnection()).getHostPort(), this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                r = command.execute(st);
                                break block12;
                            }
                            this.currentDispatchType = 0;
                            this.dispatchType = 0;
                            if (this.dispatchConnection.isClosed()) {
                                this.reconnect();
                                if (this.dispatchConnection.getMainConn() == null) {
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n", new Object[0]);
                                    }
                                    Thread.sleep(interval * 1000);
                                    continue;
                                }
                            }
                            this.cleanStatement();
                            st = this.getMainStatement();
                            if (this.record_main_stmt != null) {
                                this.resetStmtInfo(st, this.record_main_stmt);
                            }
                            if (LOGGER.isLoggable(Level.INFO)) {
                                debugmsg = String.format("Send switch slave to master session, send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                            }
                            r = command.execute(st);
                            break block12;
                        }
                        catch (SQLException ei) {
                            if (!this.expectionHandler(ei, null, null)) {
                                throw ei;
                            }
                            excep = ei;
                            if (LOGGER.isLoggable(Level.INFO)) {
                                debugmsg = String.format("Send to master from switch slave SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                            }
                            if (loop > 0) {
                                try {
                                    Thread.sleep(interval * 1000);
                                }
                                catch (InterruptedException e1) {
                                    LOGGER.log(Level.SEVERE, e1);
                                }
                                continue;
                            }
                            debugmsg = String.format("Send to master from switch slave retry failare maxtimes still SQLException: %s", ei.getMessage());
                            if (LOGGER.isLoggable(Level.INFO)) {
                                LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                            }
                            this.dispatchConnection.close();
                            throw new SQLException(debugmsg, ei.getSQLState());
                        }
                        catch (InterruptedException e1) {
                            LOGGER.log(Level.SEVERE, e1);
                        }
                    }
                    break;
                }
            }
            case 2: {
                List<java.sql.Statement> list = null;
                java.sql.Statement statement = null;
                try {
                    if (LOGGER.isLoggable(Level.INFO) && command.isExecuteFunction()) {
                        debugmsg = String.format("Send to all session: (sql={%s}, sqlType={%s})", sql.toString(), this.sqlType);
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    list = this.getAllStatement();
                    Iterator<java.sql.Statement> interval = list.iterator();
                    while (interval.hasNext()) {
                        java.sql.Statement stmt;
                        statement = stmt = interval.next();
                        r = command.execute(statement);
                    }
                }
                catch (SQLException e) {
                    if (!this.expectionHandler(e, null, null) && statement != null && ((KbConnection)statement.getConnection()).isSlave()) break;
                    if (this.expectionHandler(e, null, null) && (this.sqlType.equals("NULL") || !this.sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                        int loop = this.dispatchConnection.retrytimes;
                        if (loop <= 0) {
                            this.dispatchConnection.close();
                            throw e;
                        }
                        int interval = this.dispatchConnection.retryinterval;
                        while (loop-- > 0) {
                            try {
                                if (this.dispatchConnection.isClosed()) {
                                    this.reconnect();
                                    if (this.dispatchConnection.getMainConn() == null) {
                                        if (LOGGER.isLoggable(Level.INFO)) {
                                            LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n", new Object[0]);
                                        }
                                        Thread.sleep(interval * 1000);
                                        continue;
                                    }
                                }
                                this.cleanStatement();
                                st = this.getMainStatement();
                                if (this.record_main_stmt != null) {
                                    this.resetStmtInfo(st, this.record_main_stmt);
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to all statement,send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                r = command.execute(st);
                                this.currentDispatchType = 0;
                                this.dispatchType = 0;
                            }
                            catch (SQLException ei) {
                                if (!this.expectionHandler(ei, null, null)) {
                                    throw ei;
                                }
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    debugmsg = String.format("Send to AllStatement SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                if (loop > 0) {
                                    try {
                                        Thread.sleep(interval * 1000);
                                    }
                                    catch (InterruptedException e1) {
                                        LOGGER.log(Level.SEVERE, e1);
                                    }
                                    continue;
                                }
                                debugmsg = String.format("Send to AllStatement retry maxtimes still SQLException: %s", ei.getMessage());
                                if (LOGGER.isLoggable(Level.INFO)) {
                                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                }
                                this.dispatchConnection.close();
                                throw new SQLException(debugmsg, ei.getSQLState());
                            }
                            catch (InterruptedException e1) {
                                LOGGER.log(Level.SEVERE, e1);
                            }
                        }
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        debugmsg = String.format("failare execute in all main and slave SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                    }
                    throw e;
                }
                for (int i = 1; list != null && i < list.size() - 1; ++i) {
                    list.get(i).close();
                }
                break;
            }
            case 3: {
                List<java.sql.Statement> lis = this.getAllCurrentStatement();
                if (LOGGER.isLoggable(Level.INFO)) {
                    sql.append(", send to current:");
                    for (java.sql.Statement t : lis) {
                        sql.append("session : ").append(this.dispatchConnection).append(" , url:").append(((KbConnection)t.getConnection()).getURL() + " st" + st).append(" , ");
                    }
                    debugmsg = String.format("Send to current session: (sql={%s},sqlType={%s})", sql.toString(), this.sqlType);
                    LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                }
                block40: for (java.sql.Statement t : lis) {
                    try {
                        r = command.execute(t);
                    }
                    catch (SQLException e) {
                        if (this.expectionHandler(e, null, null) && (this.sqlType.equals("NULL") || !this.sqlType.equalsIgnoreCase(TYPE_INTRANSACTION)) && !command.getFunctionName().contains("executeBatch")) {
                            int loop = this.dispatchConnection.retrytimes;
                            if (loop <= 0) {
                                this.dispatchConnection.close();
                                throw e;
                            }
                            int interval = this.dispatchConnection.retryinterval;
                            while (loop-- > 0) {
                                try {
                                    if (this.dispatchConnection.isClosed()) {
                                        this.reconnect();
                                        if (this.dispatchConnection.getMainConn() == null) {
                                            if (LOGGER.isLoggable(Level.INFO)) {
                                                LOGGER.log(Level.INFO, "Connect Main error retry connect:" + loop + "\n", new Object[0]);
                                            }
                                            Thread.sleep(interval * 1000);
                                            continue;
                                        }
                                    }
                                    this.cleanStatement();
                                    st = this.getMainStatement();
                                    if (this.record_main_stmt != null) {
                                        this.resetStmtInfo(st, this.record_main_stmt);
                                    }
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to current statement,send to master session: (session={%s} url={%s} st={%s} sqlType={%s})", this.dispatchConnection, ((KbConnection)st.getConnection()).getURL(), st, this.sqlType);
                                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                    }
                                    r = command.execute(st);
                                    this.currentDispatchType = 0;
                                    this.dispatchType = 0;
                                    continue block40;
                                }
                                catch (SQLException ei) {
                                    if (!this.expectionHandler(ei, null, null)) {
                                        throw ei;
                                    }
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        debugmsg = String.format("Send to current SQLException: (ei.getSQLState={%s},ei.getMessage={%s})", ei.getSQLState(), ei.getMessage());
                                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                    }
                                    if (loop > 0) {
                                        try {
                                            Thread.sleep(interval * 1000);
                                        }
                                        catch (InterruptedException e1) {
                                            LOGGER.log(Level.SEVERE, e1);
                                        }
                                        continue;
                                    }
                                    debugmsg = String.format("Send to current retry failare maxtimes still SQLException: %s", ei.getMessage());
                                    if (LOGGER.isLoggable(Level.INFO)) {
                                        LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                                    }
                                    this.dispatchConnection.close();
                                    throw new SQLException(debugmsg, ei.getSQLState());
                                }
                                catch (InterruptedException e1) {
                                    LOGGER.log(Level.SEVERE, e1);
                                }
                            }
                            continue;
                        }
                        if (LOGGER.isLoggable(Level.INFO)) {
                            debugmsg = String.format("failare execute in current statement SQLException: (e.getSQLState={%s},e.getMessage={%s})", e.getSQLState(), e.getMessage());
                            LOGGER.log(Level.INFO, debugmsg, new Object[0]);
                        }
                        throw e;
                    }
                }
                break;
            }
        }
        if (command.isExecuteFunction()) {
            AtomicLong t2 = new AtomicLong(System.currentTimeMillis() - t1.get());
            if (LOGGER.isLoggable(Level.INFO)) {
                if (st instanceof PreparedStatement) {
                    LOGGER.log(Level.INFO, command.getFunctionName().substring(0, command.getFunctionName().length() - 1) + st + ") consume time:::" + t2.get() + "(ms)", new Object[0]);
                } else {
                    LOGGER.log(Level.INFO, command.getFunctionName() + " consume time:::" + t2.get() + "(ms)", new Object[0]);
                }
            }
            this.dispatchConnection.setLastSqlType(this.sqlType);
        }
        return r;
    }

    protected boolean getErrorCode(SQLException e) {
        boolean flag = false;
        if (e.getSQLState() == null) {
            flag = true;
            return flag;
        }
        if (KSQLState.isConnectionError(e.getSQLState()) || e.getSQLState().equals("57P01") || e.getSQLState().equals("57P02") || e.getSQLState().equals("57P03")) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "getErrorCode: (SQLState={0},Message={1})", e.getSQLState(), e.getMessage());
            }
            flag = true;
        }
        return flag;
    }

    private Integer changeExecuteType() {
        int result = 1;
        String rate = KBProperty.HOSTLOADRATE.get(this.dispatchConnection.m_props);
        if (Integer.valueOf(rate) > 0) {
            BigDecimal hostRate;
            String url = this.dispatchConnection.url;
            if (ConnectionMangerV2.totalAcount.get(url).get() == Integer.MAX_VALUE) {
                hostRate = new BigDecimal(ConnectionMangerV2.hostAcount.get(url).get()).divide(new BigDecimal(ConnectionMangerV2.totalAcount.get(url).get()), 2, 1);
                ConnectionMangerV2.totalAcount.get(url).set(100);
                ConnectionMangerV2.hostAcount.get(url).set(hostRate.multiply(new BigDecimal(100)).intValue());
            }
            ConnectionMangerV2.totalAcount.get(url).incrementAndGet();
            if (ConnectionMangerV2.hostAcount.get(url).get() > 0) {
                hostRate = new BigDecimal(ConnectionMangerV2.hostAcount.get(url).get()).divide(new BigDecimal(ConnectionMangerV2.totalAcount.get(url).get()), 2, 1);
                if (hostRate.multiply(new BigDecimal(100)).compareTo(new BigDecimal(rate)) == -1) {
                    result = 0;
                    ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
                }
            } else {
                result = 0;
                ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
            }
        }
        return result;
    }

    public void add() {
        if (KBProperty.HOSTLOADRATE.getIntNoCheck(this.dispatchConnection.m_props) > 0) {
            String url = this.dispatchConnection.url;
            if (ConnectionMangerV2.totalAcount.get(url).get() == Integer.MAX_VALUE) {
                BigDecimal hostRate = new BigDecimal(ConnectionMangerV2.hostAcount.get(url).get()).divide(new BigDecimal(ConnectionMangerV2.totalAcount.get(url).get()), 2, 1);
                ConnectionMangerV2.totalAcount.get(url).set(100);
                ConnectionMangerV2.hostAcount.get(url).set(hostRate.multiply(new BigDecimal(100)).intValue());
            }
            ConnectionMangerV2.totalAcount.get(url).incrementAndGet();
            ConnectionMangerV2.hostAcount.get(url).incrementAndGet();
        }
    }

    protected StatementCreateCommand<? extends java.sql.Statement> getCommand() {
        return this.createCommand;
    }

    protected abstract boolean expectionHandler(SQLException var1, java.sql.Statement var2, java.sql.Statement var3) throws SQLException;

    protected static interface ExecuteCommand<R> {
        public boolean isExecuteFunction();

        public String getFunctionName();

        public R execute(java.sql.Statement var1) throws SQLException;
    }
}

