/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.ssl;

import com.kingbase8.KBProperty;
import com.kingbase8.jdbc.SslMode;
import com.kingbase8.ssl.LazyKeyManager;
import com.kingbase8.ssl.NonValidatingFactory;
import com.kingbase8.ssl.PKCS12KeyManager;
import com.kingbase8.ssl.WrappedFactory;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.ObjectFactory;
import java.io.Console;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class LibPQFactory
extends WrappedFactory {
    KeyManager km;
    boolean defaultfile;

    private CallbackHandler getCallbackHandler(Properties info) throws KSQLException {
        CallbackHandler cbh;
        String sslpasswordcallback = KBProperty.SSL_PASSWORD_CALLBACK.get(info);
        if (sslpasswordcallback != null) {
            try {
                cbh = (CallbackHandler)ObjectFactory.instantiate(sslpasswordcallback, info, false, null);
            }
            catch (Exception e) {
                throw new KSQLException(GT.tr("The password callback class provided {0} could not be instantiated.", sslpasswordcallback), KSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        } else {
            cbh = new ConsoleCallbackHandler(KBProperty.SSL_PASSWORD.get(info));
        }
        return cbh;
    }

    private void initPk8(String sslkeyfile, String defaultdir, Properties info) throws KSQLException {
        String sslcertfile = KBProperty.SSL_CERT.get(info);
        if (sslcertfile == null) {
            this.defaultfile = true;
            sslcertfile = defaultdir + "kingbase8.crt";
        }
        this.km = new LazyKeyManager("".equals(sslcertfile) ? null : sslcertfile, "".equals(sslkeyfile) ? null : sslkeyfile, this.getCallbackHandler(info), this.defaultfile);
    }

    private void initP12(String sslkeyfile, Properties info) throws KSQLException {
        this.km = new PKCS12KeyManager(sslkeyfile, this.getCallbackHandler(info));
    }

    public LibPQFactory(Properties info) throws KSQLException {
        try {
            TrustManager[] tm;
            SslMode sslMode;
            SSLContext ctx = SSLContext.getInstance("TLS");
            String pathsep = System.getProperty("file.separator");
            String defaultdir = System.getProperty("os.name").toLowerCase().contains("windows") ? System.getenv("APPDATA") + pathsep + "kingbase8" + pathsep : System.getProperty("user.home") + pathsep + ".kingbase8" + pathsep;
            String sslkeyfile = KBProperty.SSL_KEY.get(info);
            if (sslkeyfile == null) {
                this.defaultfile = true;
                sslkeyfile = defaultdir + "kingbase8.pk8";
            }
            if (sslkeyfile.endsWith("pk8")) {
                this.initPk8(sslkeyfile, defaultdir, info);
            }
            if (sslkeyfile.endsWith("p12")) {
                this.initP12(sslkeyfile, info);
            }
            if (!(sslMode = SslMode.of(info)).verifyCertificate()) {
                tm = new TrustManager[]{new NonValidatingFactory.NonValidatingTM()};
            } else {
                FileInputStream fis;
                KeyStore ks;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                try {
                    ks = KeyStore.getInstance("jks");
                }
                catch (KeyStoreException e) {
                    throw new NoSuchAlgorithmException("jks KeyStore not available");
                }
                String sslrootcertfile = KBProperty.SSL_ROOT_CERT.get(info);
                if (sslrootcertfile == null) {
                    sslrootcertfile = defaultdir + "root.crt";
                }
                try {
                    fis = new FileInputStream(sslrootcertfile);
                }
                catch (FileNotFoundException ex) {
                    throw new KSQLException(GT.tr("Could not open SSL root certificate file {0}.", sslrootcertfile), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
                }
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Certificate[] certs = cf.generateCertificates(fis).toArray(new Certificate[0]);
                    ks.load(null, null);
                    for (int i = 0; i < certs.length; ++i) {
                        ks.setCertificateEntry("cert" + i, certs[i]);
                    }
                    tmf.init(ks);
                }
                catch (IOException ioex) {
                    throw new KSQLException(GT.tr("Could not read SSL root certificate file {0}.", sslrootcertfile), KSQLState.CONNECTION_FAILURE, (Throwable)ioex);
                }
                catch (GeneralSecurityException gsex) {
                    throw new KSQLException(GT.tr("Loading the SSL root certificate {0} into a TrustManager failed.", sslrootcertfile), KSQLState.CONNECTION_FAILURE, (Throwable)gsex);
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
                tm = tmf.getTrustManagers();
            }
            try {
                ctx.init(new KeyManager[]{this.km}, tm, null);
            }
            catch (KeyManagementException ex) {
                throw new KSQLException(GT.tr("Could not initialize SSL context.", new Object[0]), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
            }
            this.factory = ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new KSQLException(GT.tr("Could not find a java cryptographic algorithm: {0}.", ex.getMessage()), KSQLState.CONNECTION_FAILURE, (Throwable)ex);
        }
    }

    public void throwKeyManagerException() throws KSQLException {
        if (this.km != null) {
            if (this.km instanceof LazyKeyManager) {
                ((LazyKeyManager)this.km).throwKeyManagerException();
            }
            if (this.km instanceof PKCS12KeyManager) {
                ((PKCS12KeyManager)this.km).throwKeyManagerException();
            }
        }
    }

    public static class ConsoleCallbackHandler
    implements CallbackHandler {
        private char[] password = null;

        ConsoleCallbackHandler(String password) {
            if (password != null) {
                this.password = password.toCharArray();
            }
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Console cons = System.console();
            if (cons == null && this.password == null) {
                throw new UnsupportedCallbackException(callbacks[0], "Console is not available");
            }
            for (Callback callback : callbacks) {
                if (!(callback instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                PasswordCallback pwdCallback = (PasswordCallback)callback;
                if (this.password != null) {
                    pwdCallback.setPassword(this.password);
                    continue;
                }
                pwdCallback.setPassword(cons.readPassword("%s", pwdCallback.getPrompt()));
            }
        }
    }
}

