/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.clusterhealthy;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.SocketFactory;
import org.gbase.GlobalConnectionTracker;
import org.gbase.PGProperty;
import org.gbase.clusterhealthy.ClusterHeartBeatFailureCluster;
import org.gbase.clusterhealthy.ClusterHeartBeatFailureMaster;
import org.gbase.clusterhealthy.ClusterHeartBeatMaster;
import org.gbase.clusterhealthy.ClusterNodeCache;
import org.gbase.clusterhealthy.FailureCluster;
import org.gbase.core.PGStream;
import org.gbase.core.QueryExecutor;
import org.gbase.core.SocketFactoryFactory;
import org.gbase.core.v3.ConnectionFactoryImpl;
import org.gbase.core.v3.QueryExecutorImpl;
import org.gbase.jdbc.SslMode;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.HostSpec;
import org.gbase.util.PSQLState;

public class ClusterHeartBeat {
    public static final Map<HostSpec, Set<Properties>> CLUSTER_PROPERTIES = new ConcurrentHashMap<HostSpec, Set<Properties>>();
    private static Log LOGGER = Logger.getLogger(ClusterHeartBeat.class.getName());
    private static final ConnectionFactoryImpl FACTORY = new ConnectionFactoryImpl();
    private static final String UPDATE_TIME = "time";
    private volatile Long periodTime = 5000L;

    public void masterNodeProbe() {
        while (ClusterNodeCache.isOpen()) {
            LOGGER.debug("heartBeat thread start time: " + new Date(System.currentTimeMillis()));
            ClusterHeartBeatFailureMaster.getInstance().run();
            ClusterHeartBeatMaster.getInstance().run();
            ClusterHeartBeatFailureCluster.getInstance().run();
            try {
                Thread.sleep(this.periodTime);
            }
            catch (InterruptedException e) {
                LOGGER.debug(e.getStackTrace());
            }
        }
        this.periodTime = 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Properties> getProperties(HostSpec hostSpec) {
        Map<HostSpec, Set<Properties>> map = CLUSTER_PROPERTIES;
        synchronized (map) {
            return CLUSTER_PROPERTIES.computeIfAbsent(hostSpec, k -> new HashSet());
        }
    }

    public Map<HostSpec, Set<HostSpec>> getClusterRelationship() {
        return ClusterHeartBeatMaster.getInstance().getClusterRelationship();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNodeRelationship(HostSpec key, HostSpec[] value, Properties properties) {
        this.addClusterNode(key, value);
        this.addProperties(key, Collections.singleton(properties));
        if (PGProperty.HEARTBEAT_PERIOD.get(properties) == null) return;
        String period = PGProperty.HEARTBEAT_PERIOD.get(properties);
        long time = Long.parseLong(period);
        String string = UPDATE_TIME;
        synchronized (UPDATE_TIME) {
            if (time <= 0L) return;
            this.periodTime = Math.min(this.periodTime, time);
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(HostSpec hostSpec, Set<Properties> properties) {
        Map<HostSpec, Set<Properties>> map = CLUSTER_PROPERTIES;
        synchronized (map) {
            Set<Properties> propertiesSet = CLUSTER_PROPERTIES.get(hostSpec);
            if (propertiesSet == null) {
                propertiesSet = new HashSet<Properties>();
            }
            propertiesSet.addAll(properties);
            CLUSTER_PROPERTIES.put(hostSpec, propertiesSet);
        }
    }

    public void removeClusterNode(HostSpec key, HostSpec newKey, Set<HostSpec> slaves) {
        ClusterHeartBeatMaster.getInstance().removeClusterNode(key, newKey, slaves);
    }

    public void addClusterNode(HostSpec hostSpecs, HostSpec ... value) {
        ClusterHeartBeatMaster.getInstance().addClusterNode(hostSpecs, value);
    }

    public Set<HostSpec> getClusterSalveNode(HostSpec hostSpec) {
        return ClusterHeartBeatMaster.getInstance().getClusterSalveNode(hostSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperties(HostSpec hostSpec, Properties properties) {
        Map<HostSpec, Set<Properties>> map = CLUSTER_PROPERTIES;
        synchronized (map) {
            Set propertiesSet = CLUSTER_PROPERTIES.getOrDefault(hostSpec, null);
            if (propertiesSet != null) {
                propertiesSet.remove(properties);
                CLUSTER_PROPERTIES.put(hostSpec, propertiesSet);
            }
        }
    }

    public QueryExecutor getQueryExecutor(HostSpec hostSpec, Set<Properties> propSet) throws SQLException {
        Properties props = null;
        try {
            Iterator<Properties> iterator = propSet.iterator();
            if (iterator.hasNext()) {
                Properties properties;
                props = properties = iterator.next();
                SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(props);
                SslMode sslMode = SslMode.of(props);
                String user = props.getProperty("user", "");
                String database = props.getProperty("PGDBNAME", "");
                PGStream pgStream = FACTORY.tryConnect(user, database, props, socketFactory, hostSpec, sslMode);
                return new QueryExecutorImpl(pgStream, user, database, 1000, props);
            }
        }
        catch (SQLException e) {
            String sqlState = e.getSQLState();
            if (PSQLState.CONNECTION_REJECTED.getState().equals(sqlState) || "28P01".equals(sqlState)) {
                LOGGER.debug("node " + hostSpec + " is active, and connenction authentication fails.");
                LOGGER.debug("remove before propSet size :" + propSet.size());
                this.removeProperties(hostSpec, props);
                LOGGER.debug("remove after propSet size :" + propSet.size());
            }
            LOGGER.debug("acquire QueryExecutor failure " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.debug("acquire QueryExecutor failure " + e.getMessage());
            LOGGER.debug(e.getCause());
        }
        throw new SQLException();
    }

    public boolean nodeRoleIsMaster(QueryExecutor queryExecutor) {
        try {
            return FACTORY.isMaster(queryExecutor);
        }
        catch (IOException | SQLException e) {
            LOGGER.debug("Error obtaining node role " + e.getMessage());
            LOGGER.debug(e.getStackTrace());
            return false;
        }
    }

    public void cacheProcess(HostSpec hostSpec, Set<HostSpec> slaves, Set<Properties> props) {
        HostSpec maseterNode = this.findMasterNode(slaves, props);
        this.removeClusterNode(hostSpec, maseterNode, slaves);
        if (maseterNode != null) {
            this.addProperties(maseterNode, props);
            ClusterHeartBeatFailureMaster.getInstance().addFailureMaster(hostSpec, maseterNode);
        } else {
            FailureCluster cluster = new FailureCluster(hostSpec, slaves, props);
            ClusterHeartBeatFailureCluster.getInstance().addFailureCluster(cluster);
        }
        GlobalConnectionTracker.closeConnectionOfCrash(hostSpec.toString());
    }

    public HostSpec findMasterNode(Set<HostSpec> hostSpecSet, Set<Properties> properties) {
        for (HostSpec hostSpec : hostSpecSet) {
            List<QueryExecutor> queryExecutorList = GlobalConnectionTracker.getConnections(hostSpec.toString());
            for (QueryExecutor executor : queryExecutorList) {
                if (executor.isClosed() || !this.nodeRoleIsMaster(executor)) continue;
                return hostSpec;
            }
            QueryExecutor queryExecutor = null;
            try {
                queryExecutor = this.getQueryExecutor(hostSpec, properties);
            }
            catch (SQLException e) {
                continue;
            }
            boolean isMaster = this.nodeRoleIsMaster(queryExecutor);
            if (!isMaster) continue;
            return hostSpec;
        }
        return null;
    }
}

