/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.clusterhealthy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gbase.clusterhealthy.ClusterHeartBeat;
import org.gbase.clusterhealthy.FailureCluster;
import org.gbase.core.QueryExecutor;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.HostSpec;

public class ClusterHeartBeatFailureCluster
extends ClusterHeartBeat {
    public static List<FailureCluster> failureCluster = new ArrayList<FailureCluster>();
    private static volatile ClusterHeartBeatFailureCluster clusterHeartBeatFailureCluster;
    private static Log LOGGER;

    private ClusterHeartBeatFailureCluster() {
    }

    public static synchronized ClusterHeartBeatFailureCluster getInstance() {
        if (clusterHeartBeatFailureCluster == null) {
            clusterHeartBeatFailureCluster = new ClusterHeartBeatFailureCluster();
        }
        return clusterHeartBeatFailureCluster;
    }

    public void run() {
        if (failureCluster.isEmpty()) {
            return;
        }
        ArrayList<FailureCluster> list = new ArrayList<FailureCluster>(failureCluster);
        failureCluster.clear();
        LOGGER.debug("cluster does not have a master node" + list);
        for (FailureCluster cluster : list) {
            QueryExecutor queryExecutor = null;
            try {
                if (cluster == null || cluster.getMaster() == null) continue;
                queryExecutor = this.getQueryExecutor(cluster.getMaster(), cluster.getProps());
            }
            catch (SQLException e) {
                Set<HostSpec> salves = cluster.getSalves();
                int count = 0;
                for (HostSpec salf : salves) {
                    try {
                        this.getQueryExecutor(salf, cluster.getProps());
                    }
                    catch (SQLException ex) {
                        ++count;
                    }
                }
                if (count == salves.size()) continue;
                this.cacheProcess(cluster.getMaster(), salves, cluster.getProps());
            }
            if (queryExecutor == null) continue;
            boolean isMaster = this.nodeRoleIsMaster(queryExecutor);
            if (isMaster) {
                this.addClusterNode(cluster.getMaster(), cluster.getSalves().toArray(new HostSpec[0]));
                this.addProperties(cluster.getMaster(), cluster.getProps());
                continue;
            }
            HostSpec maseterNode = this.findMasterNode(cluster.getSalves(), cluster.getProps());
            if (maseterNode == null) continue;
            this.addProperties(maseterNode, cluster.getProps());
            Set<HostSpec> salves = cluster.getSalves();
            salves.add(cluster.getMaster());
            this.removeClusterNode(cluster.getMaster(), maseterNode, salves);
        }
    }

    public void addFailureCluster(FailureCluster cluster) {
        failureCluster.add(cluster);
    }

    public List<FailureCluster> getFailureCluster() {
        return failureCluster;
    }

    static {
        LOGGER = Logger.getLogger(ClusterHeartBeatFailureCluster.class.getName());
    }
}

