/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.clusterhealthy;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gbase.clusterhealthy.ClusterHeartBeat;
import org.gbase.core.QueryExecutor;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.HostSpec;

public class ClusterHeartBeatFailureMaster
extends ClusterHeartBeat {
    public static Map<HostSpec, HostSpec> failureMap = new ConcurrentHashMap<HostSpec, HostSpec>();
    private static volatile ClusterHeartBeatFailureMaster clusterHeartBeatFailureMaster;
    private static Log LOGGER;

    private ClusterHeartBeatFailureMaster() {
    }

    public static synchronized ClusterHeartBeatFailureMaster getInstance() {
        if (clusterHeartBeatFailureMaster == null) {
            clusterHeartBeatFailureMaster = new ClusterHeartBeatFailureMaster();
        }
        return clusterHeartBeatFailureMaster;
    }

    public void run() {
        HashMap<HostSpec, HostSpec> failureMapClone = new HashMap<HostSpec, HostSpec>(failureMap);
        LOGGER.debug("failure node " + failureMapClone);
        for (Map.Entry<HostSpec, HostSpec> next : failureMapClone.entrySet()) {
            HostSpec current;
            HostSpec key = next.getKey();
            HostSpec value = next.getValue();
            Set<Properties> properties = this.getProperties(key);
            QueryExecutor queryExecutor = null;
            try {
                queryExecutor = this.getQueryExecutor(key, properties);
                failureMap.remove(key);
            }
            catch (SQLException e) {
                LOGGER.error(key.toString() + " tryConnect failure.");
                continue;
            }
            boolean isMaster = this.nodeRoleIsMaster(queryExecutor);
            if (isMaster) {
                boolean currentIsMaster;
                current = value;
                while (failureMap.containsKey(current)) {
                    current = failureMap.get(current);
                }
                if (!this.getClusterRelationship().containsKey(current)) continue;
                Set<Properties> prop = this.getProperties(key);
                try {
                    QueryExecutor currentQueryExecutor = this.getQueryExecutor(current, prop);
                    currentIsMaster = this.nodeRoleIsMaster(currentQueryExecutor);
                }
                catch (SQLException e) {
                    currentIsMaster = false;
                }
                if (currentIsMaster) continue;
                Set<HostSpec> set = this.getClusterSalveNode(current);
                set.add(current);
                this.addClusterNode(key, set.toArray(new HostSpec[0]));
                continue;
            }
            current = value;
            while (failureMap.containsKey(current)) {
                if (current == failureMap.get(current)) {
                    failureMap.remove(current);
                    break;
                }
                current = failureMap.get(current);
            }
            this.addClusterNode(current, key);
        }
    }

    public void addFailureMaster(HostSpec hostSpec, HostSpec maseterNode) {
        failureMap.put(hostSpec, maseterNode);
    }

    public Map<HostSpec, HostSpec> getFailureMaster() {
        return failureMap;
    }

    public void remove(HostSpec hostSpec) {
        failureMap.remove(hostSpec);
    }

    static {
        LOGGER = Logger.getLogger(ClusterHeartBeatFailureMaster.class.getName());
    }
}

