/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.clusterhealthy;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gbase.GlobalConnectionTracker;
import org.gbase.clusterhealthy.ClusterHeartBeat;
import org.gbase.core.QueryExecutor;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.HostSpec;

public class ClusterHeartBeatMaster
extends ClusterHeartBeat {
    public static final Map<HostSpec, Set<HostSpec>> CLUSTER_NODE_RELATIONSHIP = new ConcurrentHashMap<HostSpec, Set<HostSpec>>();
    private static volatile ClusterHeartBeatMaster ClusterHeartBeatMaster;
    private static Log LOGGER;

    private ClusterHeartBeatMaster() {
    }

    public static synchronized ClusterHeartBeatMaster getInstance() {
        if (ClusterHeartBeatMaster == null) {
            ClusterHeartBeatMaster = new ClusterHeartBeatMaster();
        }
        return ClusterHeartBeatMaster;
    }

    public void run() {
        Iterator<Map.Entry<HostSpec, Set<HostSpec>>> iterator = CLUSTER_NODE_RELATIONSHIP.entrySet().iterator();
        LOGGER.debug("master nodes " + CLUSTER_NODE_RELATIONSHIP);
        while (iterator.hasNext()) {
            Map.Entry<HostSpec, Set<HostSpec>> nodeMap = iterator.next();
            HostSpec master = nodeMap.getKey();
            Set<HostSpec> slaves = nodeMap.getValue();
            LOGGER.debug("Current node " + master + " Standby node " + slaves);
            QueryExecutor queryExecutor = null;
            List<QueryExecutor> queryExecutorList = GlobalConnectionTracker.getConnections(master.toString());
            for (QueryExecutor executor : queryExecutorList) {
                if (executor.isClosed()) continue;
                queryExecutor = executor;
                break;
            }
            Set<Properties> propertiesSet = this.getProperties(master);
            if (queryExecutor == null) {
                try {
                    queryExecutor = super.getQueryExecutor(master, propertiesSet);
                }
                catch (SQLException e) {
                    LOGGER.debug("acquire QueryExecutor failure");
                    super.cacheProcess(master, slaves, propertiesSet);
                    continue;
                }
            }
            LOGGER.debug("Information about the current connected node " + queryExecutor.getSocketAddress());
            if (super.nodeRoleIsMaster(queryExecutor)) continue;
            LOGGER.debug(master + ":The host is degraded to the standby server.");
            super.cacheProcess(master, slaves, propertiesSet);
        }
    }

    @Override
    public Map<HostSpec, Set<HostSpec>> getClusterRelationship() {
        return CLUSTER_NODE_RELATIONSHIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClusterNode(HostSpec hostSpecs, HostSpec ... value) {
        Map<HostSpec, Set<HostSpec>> map = CLUSTER_NODE_RELATIONSHIP;
        synchronized (map) {
            Set hostSpecSet = CLUSTER_NODE_RELATIONSHIP.computeIfAbsent(hostSpecs, k -> new HashSet());
            Arrays.stream(value).filter(host -> !host.equals(hostSpecs)).forEach(hostSpecSet::add);
            CLUSTER_NODE_RELATIONSHIP.put(hostSpecs, hostSpecSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClusterNode(HostSpec key, HostSpec newKey, Set<HostSpec> slaves) {
        Map<HostSpec, Set<HostSpec>> map = CLUSTER_NODE_RELATIONSHIP;
        synchronized (map) {
            CLUSTER_NODE_RELATIONSHIP.remove(key);
            if (newKey != null) {
                Set<HostSpec> hostSpecSet = CLUSTER_NODE_RELATIONSHIP.get(newKey);
                if (hostSpecSet == null) {
                    hostSpecSet = new HashSet<HostSpec>();
                }
                hostSpecSet.addAll(slaves);
                hostSpecSet.remove(newKey);
                CLUSTER_NODE_RELATIONSHIP.put(newKey, hostSpecSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<HostSpec> get(HostSpec hostSpec) {
        Map<HostSpec, Set<HostSpec>> map = CLUSTER_NODE_RELATIONSHIP;
        synchronized (map) {
            return CLUSTER_NODE_RELATIONSHIP.get(hostSpec);
        }
    }

    static {
        LOGGER = Logger.getLogger(ClusterHeartBeatMaster.class.getName());
    }
}

