/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.clusterhealthy;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.gbase.PGProperty;
import org.gbase.clusterhealthy.ClusterHeartBeat;
import org.gbase.clusterhealthy.ClusterHeartBeatFailureMaster;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.HostSpec;
import org.gbase.util.PSQLException;

public class ClusterNodeCache {
    private static volatile boolean status;
    private static final String STATUS_LOCK = "status";
    private static Log LOGGER;
    private static final ExecutorService executorService;
    private static final ClusterHeartBeat CLUSTER_HEART_BEAT;

    public static boolean isOpen() {
        return status;
    }

    public static void checkReplacement(HostSpec[] hostSpecs) {
        if (hostSpecs == null) {
            return;
        }
        ClusterHeartBeatFailureMaster failureMaster = ClusterHeartBeatFailureMaster.getInstance();
        Map<HostSpec, HostSpec> failureMap = failureMaster.getFailureMaster();
        for (int i = 0; i < hostSpecs.length; ++i) {
            while (failureMap.containsKey(hostSpecs[i])) {
                if (hostSpecs[i] == failureMap.get(hostSpecs[i])) {
                    failureMaster.remove(hostSpecs[i]);
                    return;
                }
                hostSpecs[i] = failureMap.get(hostSpecs[i]);
            }
        }
    }

    public static void checkHostSpecs(HostSpec[] hostSpecs, Properties properties) throws PSQLException {
        Set set = Arrays.stream(hostSpecs).collect(Collectors.toSet());
        if (set.size() > 1) {
            ClusterNodeCache.checkReplacement(hostSpecs);
        }
    }

    public static void pushHostSpecs(HostSpec master, HostSpec[] hostSpecs, Properties properties) {
        long timePeriod;
        Set set = Arrays.stream(hostSpecs).collect(Collectors.toSet());
        String period = PGProperty.HEARTBEAT_PERIOD.get(properties);
        boolean open = true;
        if (!ClusterNodeCache.isNumeric(period)) {
            open = false;
            LOGGER.info("Invalid heartbeatPeriod value: " + period);
        }
        if ((timePeriod = Long.parseLong(period)) <= 0L) {
            open = false;
            LOGGER.info("Invalid heartbeatPeriod value: " + period);
        }
        if (set.size() > 1 && open) {
            CLUSTER_HEART_BEAT.addNodeRelationship(master, hostSpecs, properties);
            ClusterNodeCache.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void start() {
        if (status) {
            LOGGER.info("heartbeat thread ----> started");
            return;
        }
        String string = STATUS_LOCK;
        synchronized (STATUS_LOCK) {
            if (status) {
                LOGGER.info("heartbeat thread ----> started");
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            status = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            executorService.execute(CLUSTER_HEART_BEAT::masterNodeProbe);
            return;
        }
    }

    public static void stop() {
        status = false;
    }

    private static boolean isNumeric(CharSequence cs) {
        if (cs.length() == 0) {
            return false;
        }
        int size = cs.length();
        for (int i = 0; i < size; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        LOGGER = Logger.getLogger(ClusterNodeCache.class.getName());
        executorService = Executors.newCachedThreadPool();
        CLUSTER_HEART_BEAT = new ClusterHeartBeat();
    }
}

