/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.core;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import org.gbase.PGProperty;
import org.gbase.core.PGStream;
import org.gbase.core.QueryExecutor;
import org.gbase.core.v3.ConnectionFactoryImpl;
import org.gbase.log.Log;
import org.gbase.log.Logger;
import org.gbase.util.GT;
import org.gbase.util.HostSpec;
import org.gbase.util.PSQLException;
import org.gbase.util.PSQLState;

public abstract class ConnectionFactory {
    private static Log LOGGER = Logger.getLogger(ConnectionFactory.class.getName());

    public static QueryExecutor openConnection(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        ConnectionFactoryImpl connectionFactory;
        QueryExecutor queryExecutor;
        String protoName = PGProperty.PROTOCOL_VERSION.get(info);
        if ((protoName == null || protoName.isEmpty() || "3".equals(protoName)) && (queryExecutor = ((ConnectionFactory)(connectionFactory = new ConnectionFactoryImpl())).openConnectionImpl(hostSpecs, user, database, info)) != null) {
            return queryExecutor;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract QueryExecutor openConnectionImpl(HostSpec[] var1, String var2, String var3, Properties var4) throws SQLException;

    protected void closeStream(PGStream newStream) {
        if (newStream != null) {
            try {
                newStream.close();
            }
            catch (IOException e) {
                LOGGER.trace("Catch IOException on close:", e);
            }
        }
    }
}

