/*
 * Decompiled with CFR 0.152.
 */
package org.gbase.core;

import java.io.IOException;
import org.gbase.core.Encoding;
import org.gbase.log.Log;
import org.gbase.log.Logger;

public class EncodingPredictor {
    private static Log LOGGER = Logger.getLogger(EncodingPredictor.class.getName());
    private static final Translation[] FATAL_TRANSLATIONS = new Translation[]{new Translation("\u0412\u0410\u0416\u041d\u041e", null, "ru", "WIN", "ALT", "KOI8"), new Translation("KATASTROFALNY", null, "pl", "LATIN2"), new Translation("FATALE", null, "it", "LATIN1", "LATIN9"), new Translation(null, null, "fr/de/es/pt_BR", "LATIN1", "LATIN3", "LATIN4", "LATIN5", "LATIN7", "LATIN9")};

    public static DecodeResult decode(byte[] bytes, int offset, int length) {
        Encoding defaultEncoding = Encoding.defaultEncoding();
        for (Translation tr : FATAL_TRANSLATIONS) {
            for (String encoding : tr.encodings) {
                Encoding encoder = Encoding.getDatabaseEncoding(encoding);
                if (encoder == defaultEncoding) continue;
                if (tr.fatalText != null) {
                    byte[] encoded;
                    try {
                        byte[] tmp = encoder.encode(tr.fatalText);
                        encoded = new byte[tmp.length + 2];
                        encoded[0] = 83;
                        encoded[encoded.length - 1] = 0;
                        System.arraycopy(tmp, 0, encoded, 1, tmp.length);
                    }
                    catch (IOException e) {
                        continue;
                    }
                    if (!EncodingPredictor.arrayContains(bytes, offset, length, encoded, 0, encoded.length)) continue;
                }
                if (tr.texts != null) {
                    boolean foundOne = false;
                    for (String text : tr.texts) {
                        try {
                            byte[] textBytes = encoder.encode(text);
                            if (!EncodingPredictor.arrayContains(bytes, offset, length, textBytes, 0, textBytes.length)) continue;
                            foundOne = true;
                            break;
                        }
                        catch (IOException e) {
                            LOGGER.trace("Catch IOException while encoding. ", e);
                        }
                    }
                    if (!foundOne) continue;
                }
                try {
                    String decoded = encoder.decode(bytes, offset, length);
                    if (decoded.indexOf(65533) != -1) continue;
                    return new DecodeResult(decoded, encoder.name());
                }
                catch (IOException e) {
                    LOGGER.trace("Catch IOException while decoding. ", e);
                }
            }
        }
        return null;
    }

    private static boolean arrayContains(byte[] first, int firstOffset, int firstLength, byte[] second, int secondOffset, int secondLength) {
        if (firstLength < secondLength) {
            return false;
        }
        for (int i = 0; i < firstLength; ++i) {
            int j;
            while (i < firstLength && first[firstOffset + i] != second[secondOffset]) {
                ++i;
            }
            for (j = 1; j < secondLength && first[firstOffset + i + j] == second[secondOffset + j]; ++j) {
            }
            if (j != secondLength) continue;
            return true;
        }
        return false;
    }

    static class Translation {
        public final String fatalText;
        private final String[] texts;
        public final String language;
        public final String[] encodings;

        Translation(String fatalText, String[] texts, String language, String ... encodings) {
            this.fatalText = fatalText;
            this.texts = texts;
            this.language = language;
            this.encodings = encodings;
        }
    }

    public static class DecodeResult {
        public final String result;
        public final String encoding;

        DecodeResult(String result, String encoding) {
            this.result = result;
            this.encoding = encoding;
        }
    }
}

